/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.samples;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.DataSetMetaData;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.dataset.testdata.spi.RandomDataGenerator;
import de.gsi.dataset.utils.DataSetUtils;
import de.gsi.dataset.utils.ProcessingProfiler;
import de.gsi.serializer.IoBuffer;
import de.gsi.serializer.IoClassSerialiser;
import de.gsi.serializer.IoSerialiser;
import de.gsi.serializer.spi.BinarySerialiser;
import de.gsi.serializer.spi.FastByteBuffer;
import de.gsi.serializer.spi.iobuffer.DataSetSerialiser;
import de.gsi.serializer.utils.ClassUtils;
import java.io.ByteArrayOutputStream;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetToByteArraySample {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetToByteArraySample.class);
    private static final int N_SAMPLES = 10000;
    private final DoubleErrorDataSet original = new DoubleErrorDataSet("init", 10000);
    private final ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
    private final FastByteBuffer byteBuffer = new FastByteBuffer();
    private final IoSerialiser binarySerialiser = new BinarySerialiser((IoBuffer)this.byteBuffer);
    private final DataSetSerialiser dataSetSerialiser = DataSetSerialiser.withIoSerialiser((IoSerialiser)this.binarySerialiser);

    public DataSetToByteArraySample() {
        LOGGER.atInfo().log(DataSetToByteArraySample.class.getSimpleName() + " - init");
        DataSetToByteArraySample.generateData(this.original);
        LOGGER.atInfo().log(DataSetToByteArraySample.class.getSimpleName() + " - generated data");
        DataSetUtils.writeDataSetToByteArray((DataSet)this.original, (ByteArrayOutputStream)this.byteOutput, (boolean)false, (boolean)false);
        LOGGER.atInfo().addArgument((Object)DataSetToByteArraySample.encodingBits(false)).addArgument((Object)DataSetToByteArraySample.encodingBinary(false)).addArgument((Object)DataSetToByteArraySample.humanReadableByteCount(this.byteOutput.size(), true)).log("byte buffer array length with {} {} encoding = {}");
        DataSetUtils.writeDataSetToByteArray((DataSet)this.original, (ByteArrayOutputStream)this.byteOutput, (boolean)true, (boolean)true);
        LOGGER.atInfo().addArgument((Object)DataSetToByteArraySample.encodingBits(true)).addArgument((Object)DataSetToByteArraySample.encodingBinary(true)).addArgument((Object)DataSetToByteArraySample.humanReadableByteCount(this.byteOutput.size(), true)).log("byte buffer array length with {} {} encoding =  = {}");
        DataSetUtils.writeDataSetToByteArray((DataSet)this.original, (ByteArrayOutputStream)this.byteOutput, (boolean)true, (boolean)false);
        LOGGER.atInfo().addArgument((Object)DataSetToByteArraySample.encodingBits(false)).addArgument((Object)DataSetToByteArraySample.encodingBinary(true)).addArgument((Object)DataSetToByteArraySample.humanReadableByteCount(this.byteOutput.size(), true)).log("byte buffer array length with {} {} encoding =  = {}");
        this.byteBuffer.ensureCapacity(this.byteOutput.size() + 1000);
    }

    public void clearGarbage() {
        System.gc();
        System.gc();
        LOGGER.atInfo().log("");
    }

    public void testDataSetSerialiserIdentity(boolean withMetaData, boolean asFloat32) {
        this.dataSetSerialiser.setMetaDataSerialised(true);
        this.dataSetSerialiser.setDataLablesSerialised(true);
        this.byteBuffer.reset();
        this.dataSetSerialiser.write((DataSet)this.original, asFloat32);
        this.byteBuffer.reset();
        DoubleErrorDataSet dataSet = (DoubleErrorDataSet)this.dataSetSerialiser.read();
        this.testIdentityCore(true, asFloat32, (DataSetError)this.original, (DataSetError)dataSet);
        this.testIdentityLabelsAndStyles(true, (DataSet2D)this.original, (DataSet)dataSet);
        this.testIdentityMetaData(true, (DataSetMetaData)this.original, (DataSetMetaData)dataSet);
        LOGGER.atInfo().addArgument((Object)DataSetToByteArraySample.encodingBits(asFloat32)).addArgument((Object)DataSetToByteArraySample.encodingBinary(true)).addArgument((Object)(withMetaData ? "with" : "w/o")).log("testDataSetSerialiserIdentity passed for {} {} encoding {} meta-data");
    }

    public void testDataSetUtilsIdentity(boolean binary, boolean asFloat32) {
        DataSetUtils.writeDataSetToByteArray((DataSet)this.original, (ByteArrayOutputStream)this.byteOutput, (boolean)binary, (boolean)asFloat32);
        DataSet dataSet = DataSetUtils.readDataSetFromByteArray((byte[])this.byteOutput.toByteArray());
        if (!(dataSet instanceof DoubleErrorDataSet)) {
            throw new IllegalStateException("DataSet is not not instanceof DoubleErrorDataSet, might be DataSet3D or DoubleDataSet");
        }
        this.testIdentityCore(binary, asFloat32, (DataSetError)this.original, (DataSetError)((DoubleErrorDataSet)dataSet));
        this.testIdentityMetaData(binary, (DataSetMetaData)this.original, (DataSetMetaData)dataSet);
        LOGGER.atInfo().addArgument((Object)DataSetToByteArraySample.encodingBits(asFloat32)).addArgument((Object)DataSetToByteArraySample.encodingBinary(binary)).log("testDataSetUtilsIdentity passed for {} {} encoding with partial meta-data");
    }

    public void testGenericSerialiserIdentity(boolean asFloat32) {
        IoClassSerialiser serialiser = new IoClassSerialiser((IoBuffer)this.byteBuffer, new Class[]{BinarySerialiser.class});
        DataSetWrapper dsOrig = new DataSetWrapper();
        dsOrig.source = this.original;
        DataSetWrapper cpOrig = new DataSetWrapper();
        this.byteBuffer.reset();
        serialiser.serialiseObject((Object)dsOrig);
        this.byteBuffer.reset();
        Object retOrig = serialiser.deserialiseObject((Object)cpOrig);
        if (cpOrig != retOrig) {
            throw new IllegalStateException("Deserialisation should be in-place");
        }
        if (!(cpOrig.source instanceof DoubleErrorDataSet)) {
            throw new IllegalStateException("DataSet is not not instanceof DoubleErrorDataSet, might be DataSet3D or DoubleDataSet");
        }
        this.testIdentityCore(true, asFloat32, (DataSetError)this.original, (DataSetError)((DoubleErrorDataSet)cpOrig.source));
        this.testIdentityLabelsAndStyles(true, (DataSet2D)this.original, cpOrig.source);
        if (cpOrig.source instanceof DataSetMetaData) {
            this.testIdentityMetaData(true, (DataSetMetaData)this.original, (DataSetMetaData)cpOrig.source);
        }
        LOGGER.atInfo().addArgument((Object)DataSetToByteArraySample.encodingBits(asFloat32)).addArgument((Object)DataSetToByteArraySample.encodingBinary(true)).log("testGenericSerialiserIdentity passed for {} {} encoding with partial meta-data");
    }

    public void testGenericSerializerPerformance(int iterations, boolean asFloat32) {
        IoClassSerialiser serialiser = new IoClassSerialiser((IoBuffer)this.byteBuffer, new Class[]{BinarySerialiser.class});
        this.byteBuffer.reset();
        DoubleErrorDataSet copy = new DoubleErrorDataSet("init", 10000);
        copy.setErrorType(0, DataSetError.ErrorType.NO_ERROR);
        copy.setErrorType(1, DataSetError.ErrorType.NO_ERROR);
        DataSetWrapper dsOrig = new DataSetWrapper();
        dsOrig.source = this.original;
        DataSetWrapper cpOrig = new DataSetWrapper();
        cpOrig.source = new DoubleErrorDataSet("test", 10);
        this.binarySerialiser.setPutFieldMetaData(true);
        long startTime = ProcessingProfiler.getTimeStamp();
        for (int i = 0; i < iterations; ++i) {
            if (i == 1) {
                this.binarySerialiser.setPutFieldMetaData(false);
            }
            this.original.setName("data set name " + System.currentTimeMillis());
            this.byteBuffer.reset();
            serialiser.serialiseObject((Object)dsOrig);
            this.byteBuffer.reset();
            Object retOrig = serialiser.deserialiseObject((Object)cpOrig);
            if (retOrig != cpOrig) {
                throw new IllegalStateException("Deserialisation should be in-place");
            }
            if (dsOrig.source.getName().equals(cpOrig.source.getName())) continue;
            LOGGER.atError().addArgument((Object)dsOrig.source.getName()).addArgument((Object)cpOrig.source.getName()).log("ERROR DataSet '{}' does not match '{}' -> potential streaming error at index = " + i);
            if (dsOrig.source.equals(cpOrig.source)) break;
            throw new IllegalStateException("DataSet mismatch");
        }
        long stopTime = ProcessingProfiler.getTimeDiff((long)startTime, (String)"testGenericSerializerPerformance");
        this.binarySerialiser.setPutFieldMetaData(true);
        double diffMillis = TimeUnit.NANOSECONDS.toMillis(stopTime - startTime);
        double byteCount = (double)iterations * ((double)this.byteBuffer.position() / diffMillis * 1000.0);
        LOGGER.atInfo().addArgument((Object)DataSetToByteArraySample.encodingBits(asFloat32)).addArgument((Object)DataSetToByteArraySample.encodingBinary(true)).addArgument((Object)"with").addArgument((Object)DataSetToByteArraySample.humanReadableByteCount((long)byteCount, true)).addArgument((Object)(diffMillis / (double)iterations)).log("average {} {} IoClassSerialiser throughput {} meta infos = {}/s - time: {} ms per DataSet round-trip");
    }

    public void testIdentityCore(boolean binary, boolean asFloat32, DataSetError originalDS, DataSetError testDS) {
        if (originalDS.getDataCount() != testDS.getDataCount()) {
            throw new IllegalStateException("data set counts do not match (" + DataSetToByteArraySample.encodingBinary(binary) + "): original = " + originalDS.getDataCount() + " vs. copy = " + testDS.getDataCount());
        }
        if (!originalDS.getName().equals(testDS.getName())) {
            throw new IllegalStateException("data set name do not match (" + DataSetToByteArraySample.encodingBinary(binary) + "): original = " + originalDS.getName() + " vs. copy = " + testDS.getName());
        }
        for (int i = 0; i < originalDS.getDataCount(); ++i) {
            double x0 = originalDS.get(0, i);
            double y0 = originalDS.get(1, i);
            double exn0 = originalDS.getErrorNegative(0, i);
            double exp0 = originalDS.getErrorPositive(0, i);
            double eyn0 = originalDS.getErrorNegative(1, i);
            double eyp0 = originalDS.getErrorPositive(1, i);
            double x1 = testDS.get(0, i);
            double y1 = testDS.get(1, i);
            double exn1 = testDS.getErrorNegative(0, i);
            double exp1 = testDS.getErrorPositive(0, i);
            double eyn1 = testDS.getErrorNegative(1, i);
            double eyp1 = testDS.getErrorPositive(1, i);
            if (asFloat32) {
                if (this.floatIdentity(x0, x1) && this.floatIdentity(y0, y1) && this.floatIdentity(exn0, exn1) && this.floatIdentity(exp0, exp1) && this.floatIdentity(eyn0, eyn1) && eyp0 == eyp1) continue;
                String diff = String.format("(x=%e - %e, y=%e - %e, exn=%e - %e, exp=%e - %e, eyn=%e - %e, eyp=%e - %e)", x0, x1, y0, y1, exn0, exn1, exp0, exp1, eyn0, eyn1, eyp0, eyp1);
                String delta = String.format("(dx=%e, dy=%e, dexn=%e, dexp=%e, deyn=%e, deyp=%e)", x0 - x1, y0 - y1, exn0 - exn1, exp0 - exp1, eyn0 - eyn1, eyp0 - eyp1);
                String msg = String.format("data set values do not match (%s): original-copy = at index %d%n%s%n%s%n", DataSetToByteArraySample.encodingBinary(binary), i, diff, delta);
                throw new IllegalStateException(msg);
            }
            if (x0 == x1 && y0 == y1 && exn0 == exn1 && exp0 == exp1 && eyn0 == eyn1 && eyp0 == eyp1) continue;
            String diff = String.format("(x=%e - %e, y=%e - %e, exn=%e - %e, exp=%e - %e, eyn=%e - %e, eyp=%e - %e)", x0, x1, y0, y1, exn0, exn1, exp0, exp1, eyn0, eyn1, eyp0, eyp1);
            String delta = String.format("(dx=%e, dy=%e, dexn=%e, dexp=%e, deyn=%e, deyp=%e)", x0 - x1, y0 - y1, exn0 - exn1, exp0 - exp1, eyn0 - eyn1, eyp0 - eyp1);
            String msg = String.format("data set values do not match (%s): original-copy = at index %d%n%s%n%s%n", DataSetToByteArraySample.encodingBinary(binary), i, diff, delta);
            throw new IllegalStateException(msg);
        }
    }

    public void testIdentityLabelsAndStyles(boolean binary, DataSet2D originalDS, DataSet testDS) {
        int i;
        for (i = 0; i < originalDS.getDataCount(); ++i) {
            if (originalDS.getDataLabel(i) == null && testDS.getDataLabel(i) == null || originalDS.getDataLabel(i).equals(testDS.getDataLabel(i))) continue;
            String msg = String.format("data set label do not match (%s): original(%d) ='%s' vs. copy(%d) ='%s' %n", DataSetToByteArraySample.encodingBinary(binary), i, originalDS.getDataLabel(i), i, testDS.getDataLabel(i));
            throw new IllegalStateException(msg);
        }
        for (i = 0; i < originalDS.getDataCount(); ++i) {
            if (originalDS.getStyle(i) == null && testDS.getStyle(i) == null || originalDS.getStyle(i).equals(testDS.getStyle(i))) continue;
            String msg = String.format("data set style do not match (%s): original(%d) ='%s' vs. copy(%d) ='%s' %n", DataSetToByteArraySample.encodingBinary(binary), i, originalDS.getStyle(i), i, testDS.getStyle(i));
            throw new IllegalStateException(msg);
        }
    }

    public void testIdentityMetaData(boolean binary, DataSetMetaData originalDS, DataSetMetaData testDS) {
        if (!originalDS.getInfoList().equals(testDS.getInfoList())) {
            String msg = String.format("data set info lists do not match (%s): original ='%s' vs. copy ='%s' %n", DataSetToByteArraySample.encodingBinary(binary), originalDS.getInfoList(), testDS.getInfoList());
            throw new IllegalStateException(msg);
        }
    }

    public void testPerformance(int iterations, boolean withMetaInfos, boolean binary, boolean asFloat32) {
        long startTime = ProcessingProfiler.getTimeStamp();
        DataSetUtils.setExportMetaDataByDefault((boolean)withMetaInfos);
        for (int i = 0; i < iterations; ++i) {
            DataSetUtils.writeDataSetToByteArray((DataSet)this.original, (ByteArrayOutputStream)this.byteOutput, (boolean)binary, (boolean)asFloat32);
            DataSet dataSet = DataSetUtils.readDataSetFromByteArray((byte[])this.byteOutput.toByteArray());
            if (dataSet != null && this.original.getName().equals(dataSet.getName())) continue;
            LOGGER.atError().log("ERROR data set does not match -> potential streaming error at index = " + i);
            break;
        }
        long stopTime = ProcessingProfiler.getTimeDiff((long)startTime, (String)"testPerformance(int, boolean, boolean)");
        DataSetUtils.setExportMetaDataByDefault((boolean)true);
        double diffMillis = TimeUnit.NANOSECONDS.toMillis(stopTime - startTime);
        double byteCount = (double)iterations * ((double)this.byteOutput.size() / diffMillis * 1000.0);
        LOGGER.atInfo().addArgument((Object)DataSetToByteArraySample.encodingBits(asFloat32)).addArgument((Object)DataSetToByteArraySample.encodingBinary(binary)).addArgument((Object)(withMetaInfos ? "with" : "w/o")).addArgument((Object)DataSetToByteArraySample.humanReadableByteCount((long)byteCount, true)).addArgument((Object)(diffMillis / (double)iterations)).log("average {} {} DataSetUtils throughput {} meta infos = {}/s - time: {} ms per DataSet round-trip");
    }

    public void testSerializerPerformance(int iterations, boolean withMetaInfos, boolean asFloat32) {
        this.dataSetSerialiser.setMetaDataSerialised(withMetaInfos);
        this.dataSetSerialiser.setDataLablesSerialised(withMetaInfos);
        long startTime = ProcessingProfiler.getTimeStamp();
        this.byteBuffer.reset();
        for (int i = 0; i < iterations; ++i) {
            this.byteBuffer.reset();
            this.dataSetSerialiser.write((DataSet)this.original, asFloat32);
            this.byteBuffer.reset();
            DataSet dataSet = this.dataSetSerialiser.read();
            if (this.original.getName().equals(dataSet.getName())) continue;
            LOGGER.atError().log("ERROR data set does not match -> potential streaming error at index = " + i);
            break;
        }
        long stopTime = ProcessingProfiler.getTimeDiff((long)startTime, (String)"testSerializerPerformance");
        double diffMillis = TimeUnit.NANOSECONDS.toMillis(stopTime - startTime);
        double byteCount = (double)iterations * ((double)this.byteBuffer.position() / diffMillis * 1000.0);
        LOGGER.atInfo().addArgument((Object)DataSetToByteArraySample.encodingBits(asFloat32)).addArgument((Object)DataSetToByteArraySample.encodingBinary(true)).addArgument((Object)(withMetaInfos ? "with" : "w/o")).addArgument((Object)DataSetToByteArraySample.humanReadableByteCount((long)byteCount, true)).addArgument((Object)(diffMillis / (double)iterations)).log("average {} {} DataSetSerialiser throughput {} meta infos = {}/s - time: {} ms per DataSet round-trip");
    }

    protected boolean floatIdentity(double a, double b) {
        return (double)Math.abs((float)a - (float)b) <= 2.0 / Math.pow(2.0, 23.0);
    }

    private void performIdentityChecks() {
        int n;
        int n2;
        Boolean[] booleanArray;
        boolean bit32;
        int n3;
        Boolean[] booleanArray2 = new Boolean[]{true, false};
        int n4 = booleanArray2.length;
        for (n3 = 0; n3 < n4; ++n3) {
            bit32 = booleanArray2[n3];
            booleanArray = new Boolean[]{false, true};
            n2 = booleanArray.length;
            for (n = 0; n < n2; ++n) {
                boolean binary = booleanArray[n];
                this.testDataSetUtilsIdentity(binary, bit32);
            }
            this.testGenericSerialiserIdentity(bit32);
        }
        this.clearGarbage();
        booleanArray2 = new Boolean[]{true, false};
        n4 = booleanArray2.length;
        for (n3 = 0; n3 < n4; ++n3) {
            bit32 = booleanArray2[n3];
            booleanArray = new Boolean[]{false, true};
            n2 = booleanArray.length;
            for (n = 0; n < n2; ++n) {
                boolean withMetaData = booleanArray[n];
                this.testDataSetSerialiserIdentity(withMetaData, bit32);
            }
        }
        this.clearGarbage();
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static void main(String[] args) {
        ProcessingProfiler.setVerboseOutputState((boolean)false);
        ProcessingProfiler.setLoggerOutputState((boolean)true);
        ProcessingProfiler.setDebugState((boolean)true);
        DataSetToByteArraySample sample = new DataSetToByteArraySample();
        sample.performIdentityChecks();
        ClassUtils.getFieldDescription(DoubleErrorDataSet.class, (Class[])new Class[0]).printFieldStructure();
        sample.testPerformance(100, true, false, true);
        sample.testPerformance(100, true, false, false);
        sample.clearGarbage();
        int iterations = 4;
        Consumer<BiConsumer> loopFunction = func -> {
            Boolean[] booleanArray = new Boolean[]{true, false};
            int n = booleanArray.length;
            for (int i = 0; i < n; ++i) {
                boolean bit32 = booleanArray[i];
                Boolean[] booleanArray2 = new Boolean[]{true, false};
                int n2 = booleanArray2.length;
                for (int j = 0; j < n2; ++j) {
                    boolean header = booleanArray2[j];
                    for (int i2 = 0; i2 < 4; ++i2) {
                        func.accept(bit32, header);
                    }
                    sample.clearGarbage();
                }
            }
        };
        int nLoops = 2000;
        loopFunction.accept((bit32, header) -> sample.testPerformance(2000, (boolean)header, true, (boolean)bit32));
        loopFunction.accept((bit32, header) -> sample.testSerializerPerformance(2000, (boolean)header, (boolean)bit32));
        loopFunction.accept((bit32, header) -> sample.testGenericSerializerPerformance(2000, false));
    }

    private static String encodingBinary(boolean isBinaryEncoding) {
        return isBinaryEncoding ? "binary-based" : "string-based";
    }

    private static String encodingBits(boolean is32BitEncoding) {
        return is32BitEncoding ? "32-bit" : "64-bit";
    }

    private static void generateData(DoubleErrorDataSet dataSet) {
        long startTime = ProcessingProfiler.getTimeStamp();
        dataSet.autoNotification().set(false);
        dataSet.clearData();
        dataSet.setName("data set name " + System.currentTimeMillis());
        double oldY = 0.0;
        for (int n = 0; n < 10000; ++n) {
            double y = oldY += RandomDataGenerator.random() - 0.5;
            double eyNeg = 0.1;
            double eyPos = 10.0;
            dataSet.set(n, (double)n, y, 0.1, 10.0);
            if (n != 5000) continue;
            dataSet.getDataLabelMap().put((Object)n, (Object)"special outlier");
            dataSet.getDataStyleMap().put((Object)n, (Object)"-stroke-color=red");
        }
        dataSet.getInfoList().add("standard info1");
        dataSet.getInfoList().add("standard info2");
        dataSet.getWarningList().add("standard warning");
        dataSet.getErrorList().add("standard error");
        dataSet.getMetaInfo().put("metaKey#1", "metaValue#1");
        dataSet.getMetaInfo().put("metaKey#2", "metaValue#2");
        dataSet.getMetaInfo().put("metaKey#3", "metaValue#3");
        dataSet.autoNotification().set(true);
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"generating data DataSet");
    }

    private static class DataSetWrapper {
        private DataSet source;

        private DataSetWrapper() {
        }
    }
}

