/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples.legacy.utils;

import de.gsi.chart.samples.legacy.utils.ChartTestCase;
import de.gsi.chart.utils.SimplePerformanceMeter;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestApplication
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTestApplication.class);
    protected static final int MAX_DATA_POINTS_1K = 1000;
    protected static final int MAX_DATA_POINTS_10K = 10000;
    protected static final int MAX_DATA_POINTS_100K = 100000;
    protected static final int MAX_DATA_POINTS_200K = 200000;
    protected static final int FPS_METER_PERIOD = 100;
    protected static final int FPS_METER_AVERAGING_PERIOD = 20000;
    protected static ChartTestCase test;
    protected SimplePerformanceMeter meter;
    protected Timer timer;
    protected int downSampleCounter = 0;

    protected HBox getHeaderBar(Scene scene) {
        Button newDataSet1k = new Button("1k");
        newDataSet1k.setTooltip(new Tooltip("update present data set with 1k data points"));
        newDataSet1k.setMaxWidth(Double.MAX_VALUE);
        newDataSet1k.setOnAction(evt -> {
            test.setNumberOfSamples(1000);
            Platform.runLater(test::updateDataSet);
            LOGGER.atInfo().log("reset FPS averages");
            this.meter.resetAverages();
        });
        Button newDataSet100k = new Button("100k");
        newDataSet100k.setTooltip(new Tooltip("update present data set with 100k data points"));
        newDataSet100k.setMaxWidth(Double.MAX_VALUE);
        newDataSet100k.setOnAction(evt -> {
            test.setNumberOfSamples(100000);
            Platform.runLater(test::updateDataSet);
            LOGGER.atInfo().log("reset FPS averages");
            this.meter.resetAverages();
        });
        Button newDataSet10k = new Button("10k");
        newDataSet10k.setTooltip(new Tooltip("update present data set with 10k data points"));
        newDataSet10k.setMaxWidth(Double.MAX_VALUE);
        newDataSet10k.setOnAction(evt -> {
            test.setNumberOfSamples(10000);
            Platform.runLater(test::updateDataSet);
            LOGGER.atInfo().log("reset FPS averages");
            this.meter.resetAverages();
        });
        Button newDataSet200k = new Button("200k");
        newDataSet200k.setTooltip(new Tooltip("update present data set with 200k data points"));
        newDataSet200k.setMaxWidth(Double.MAX_VALUE);
        newDataSet200k.setOnAction(evt -> {
            test.setNumberOfSamples(200000);
            Platform.runLater(test::updateDataSet);
            LOGGER.atInfo().log("reset FPS averages");
            this.meter.resetAverages();
        });
        Button startTimer25Hz = new Button("T@25Hz");
        startTimer25Hz.setTooltip(new Tooltip("continuously update present data set @1Hz"));
        startTimer25Hz.setMaxWidth(Double.MAX_VALUE);
        startTimer25Hz.setOnAction(evt -> {
            if (this.timer == null) {
                this.timer = new Timer("sample-update-timer", true);
                this.timer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        test.updateDataSet();
                    }
                }, 0L, 40L);
            } else {
                this.timer.cancel();
                this.timer = null;
            }
            LOGGER.atInfo().log("reset FPS averages");
            this.meter.resetAverages();
        });
        Button startTimer1Hz = new Button("T@1Hz");
        startTimer1Hz.setTooltip(new Tooltip("continuously update present data set @1Hz"));
        startTimer1Hz.setMaxWidth(Double.MAX_VALUE);
        startTimer1Hz.setOnAction(evt -> {
            if (this.timer == null) {
                this.timer = new Timer(true);
                this.timer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        test.updateDataSet();
                    }
                }, 0L, 1000L);
            } else {
                this.timer.cancel();
                this.timer = null;
            }
            LOGGER.atInfo().log("reset FPS averages");
            this.meter.resetAverages();
        });
        Region spacer = new Region();
        spacer.setMinWidth(Double.NEGATIVE_INFINITY);
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        Label fxFPS = new Label();
        fxFPS.setFont(Font.font((String)"Monospaced", (double)12.0));
        Label chartFPS = new Label();
        chartFPS.setFont(Font.font((String)"Monospaced", (double)12.0));
        Label cpuLoadProcess = new Label();
        cpuLoadProcess.setFont(Font.font((String)"Monospaced", (double)12.0));
        Label cpuLoadSystem = new Label();
        cpuLoadSystem.setFont(Font.font((String)"Monospaced", (double)12.0));
        this.meter = new SimplePerformanceMeter(scene, 100L);
        this.meter.averageFactorProperty().set(0.004975124378109453);
        this.meter.fxFrameRateProperty().addListener((ch, o, n) -> {
            ++this.downSampleCounter;
            if (this.downSampleCounter % 20 != 0) {
                return;
            }
            String fxRate = String.format("%4.1f", this.meter.getFxFrameRate());
            String actualRate = String.format("%4.1f", this.meter.getActualFrameRate());
            String cpuProcess = String.format("%5.1f", this.meter.getProcessCpuLoad());
            String cpuSystem = String.format("%5.1f", this.meter.getSystemCpuLoad());
            String avgFxRate = String.format("%4.1f", this.meter.getAverageFxFrameRate());
            String avgActualRate = String.format("%4.1f", this.meter.getAverageFrameRate());
            String avgCpuProcess = String.format("%5.1f", this.meter.getAverageProcessCpuLoad());
            String avgCpuSystem = String.format("%5.1f", this.meter.getAverageSystemCpuLoad());
            fxFPS.setText(String.format("%-6s: %4s (%4s) %s", "JavaFX (avg)", fxRate, avgFxRate, "FPS, "));
            chartFPS.setText(String.format("%-6s: %4s (%4s) %s", "Actual (avg)", actualRate, avgActualRate, "FPS, "));
            cpuLoadProcess.setText(String.format("%-11s: %4s (%4s)%s", "Process-CPU (avg)", cpuProcess, avgCpuProcess, "%"));
            cpuLoadSystem.setText(String.format("%-11s: %4s (%4s)%s", "System -CPU (avg)", cpuSystem, avgCpuSystem, "%"));
        });
        return new HBox(new Node[]{new VBox(new Node[]{newDataSet1k, newDataSet100k}), new VBox(new Node[]{newDataSet10k, newDataSet200k}), new VBox(new Node[]{startTimer25Hz, startTimer1Hz}), spacer, new VBox(new Node[]{fxFPS, chartFPS}), new VBox(new Node[]{cpuLoadProcess, cpuLoadSystem})});
    }

    protected abstract void initChart();

    public void start(Stage stage) {
        stage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        this.initChart();
        BorderPane root = new BorderPane();
        Scene scene = new Scene((Parent)root, 1800.0, 400.0);
        root.setCenter(test.getChart(1000));
        root.setTop((Node)this.getHeaderBar(scene));
        stage.setScene(scene);
        stage.setOnCloseRequest(evt -> System.exit(0));
        stage.show();
    }
}

