/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples.legacy;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;

@Deprecated
public class MultipleAxesLineChart
extends StackPane {
    private final LineChart<?, ?> baseChart;
    private final ObservableList<LineChart<?, ?>> backgroundCharts = FXCollections.observableArrayList();
    private final Map<LineChart<?, ?>, Color> chartColorMap = new HashMap();
    private final double yAxisWidth = 60.0;
    private final AnchorPane detailsWindow;
    private final double yAxisSeparation = 20.0;
    private double strokeWidth = 0.3;

    public MultipleAxesLineChart(LineChart<?, ?> baseChart, Color lineColor) {
        this(baseChart, lineColor, null);
    }

    public MultipleAxesLineChart(LineChart<?, ?> baseChart, Color lineColor, Double strokeWidth) {
        if (strokeWidth != null) {
            this.strokeWidth = strokeWidth;
        }
        this.baseChart = baseChart;
        this.chartColorMap.put(baseChart, lineColor);
        this.styleBaseChart(baseChart);
        this.styleChartLine(baseChart, lineColor);
        this.setFixedAxisWidth(baseChart);
        this.setAlignment(Pos.CENTER_LEFT);
        this.backgroundCharts.addListener(observable -> this.rebuildChart());
        this.detailsWindow = new AnchorPane();
        this.bindMouseEvents(baseChart, this.strokeWidth);
        this.rebuildChart();
    }

    public void addSeries(XYChart.Series<Number, Number> series, Color lineColor) {
        NumberAxis yAxis = new NumberAxis();
        NumberAxis xAxis = new NumberAxis();
        xAxis.setAutoRanging(false);
        xAxis.setVisible(false);
        xAxis.setOpacity(0.0);
        xAxis.lowerBoundProperty().bind((ObservableValue)((NumberAxis)this.baseChart.getXAxis()).lowerBoundProperty());
        xAxis.upperBoundProperty().bind((ObservableValue)((NumberAxis)this.baseChart.getXAxis()).upperBoundProperty());
        xAxis.tickUnitProperty().bind((ObservableValue)((NumberAxis)this.baseChart.getXAxis()).tickUnitProperty());
        yAxis.setSide(Side.RIGHT);
        yAxis.setLabel(series.getName());
        LineChart lineChart = new LineChart((Axis)xAxis, (Axis)yAxis);
        lineChart.setAnimated(false);
        lineChart.setLegendVisible(false);
        lineChart.getData().add(series);
        this.styleBackgroundChart(lineChart, lineColor);
        this.setFixedAxisWidth(lineChart);
        this.chartColorMap.put(lineChart, lineColor);
        this.backgroundCharts.add((Object)lineChart);
    }

    private void bindMouseEvents(LineChart<?, ?> baseChart, Double strokeWidth) {
        this.getChildren().add((Object)this.detailsWindow);
        this.detailsWindow.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        this.detailsWindow.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.detailsWindow.setMouseTransparent(true);
        this.setOnMouseMoved(null);
        this.setMouseTransparent(false);
        Axis xAxis = baseChart.getXAxis();
        Axis yAxis = baseChart.getYAxis();
        Line xLine = new Line();
        Line yLine = new Line();
        yLine.setFill((Paint)Color.GRAY);
        xLine.setFill((Paint)Color.GRAY);
        yLine.setStrokeWidth(strokeWidth / 2.0);
        xLine.setStrokeWidth(strokeWidth / 2.0);
        xLine.setVisible(false);
        yLine.setVisible(false);
        Node chartBackground = baseChart.lookup(".chart-plot-background");
        for (Node n : chartBackground.getParent().getChildrenUnmodifiable()) {
            if (n == chartBackground || n == xAxis || n == yAxis) continue;
            n.setMouseTransparent(true);
        }
    }

    public Node getLegend() {
        HBox hBox = new HBox();
        CheckBox baseChartCheckBox = new CheckBox(this.baseChart.getYAxis().getLabel());
        baseChartCheckBox.setSelected(true);
        baseChartCheckBox.setStyle("-fx-text-fill: " + this.toRGBCode(this.chartColorMap.get(this.baseChart)) + "; -fx-font-weight: bold;");
        baseChartCheckBox.setDisable(true);
        baseChartCheckBox.getStyleClass().add((Object)"readonly-checkbox");
        baseChartCheckBox.setOnAction(event -> baseChartCheckBox.setSelected(true));
        hBox.getChildren().add((Object)baseChartCheckBox);
        for (LineChart lineChart : this.backgroundCharts) {
            CheckBox checkBox = new CheckBox(lineChart.getYAxis().getLabel());
            checkBox.setStyle("-fx-text-fill: " + this.toRGBCode(this.chartColorMap.get(lineChart)) + "; -fx-font-weight: bold");
            checkBox.setSelected(true);
            checkBox.setOnAction(event -> {
                if (this.backgroundCharts.contains((Object)lineChart)) {
                    this.backgroundCharts.remove((Object)lineChart);
                } else {
                    this.backgroundCharts.add((Object)lineChart);
                }
            });
            hBox.getChildren().add((Object)checkBox);
        }
        hBox.setAlignment(Pos.CENTER);
        hBox.setSpacing(20.0);
        hBox.setStyle("-fx-padding: 0 10 20 10");
        return hBox;
    }

    private void rebuildChart() {
        this.getChildren().clear();
        this.getChildren().add((Object)this.resizeBaseChart(this.baseChart));
        for (LineChart lineChart : this.backgroundCharts) {
            this.getChildren().add((Object)this.resizeBackgroundChart(lineChart));
        }
        this.getChildren().add((Object)this.detailsWindow);
    }

    private Node resizeBackgroundChart(LineChart<?, ?> lineChart) {
        HBox hBox = new HBox(new Node[]{lineChart});
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        hBox.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        hBox.setMouseTransparent(true);
        lineChart.minWidthProperty().bind((ObservableValue)this.widthProperty().subtract(80.0 * (double)this.backgroundCharts.size()));
        lineChart.prefWidthProperty().bind((ObservableValue)this.widthProperty().subtract(80.0 * (double)this.backgroundCharts.size()));
        lineChart.maxWidthProperty().bind((ObservableValue)this.widthProperty().subtract(80.0 * (double)this.backgroundCharts.size()));
        lineChart.translateXProperty().bind((ObservableValue)this.baseChart.getYAxis().widthProperty());
        lineChart.getYAxis().setTranslateX(80.0 * (double)this.backgroundCharts.indexOf(lineChart));
        lineChart.getXAxis().tickLabelRotationProperty().bind((ObservableValue)this.baseChart.getXAxis().tickLabelRotationProperty());
        return hBox;
    }

    private Node resizeBaseChart(LineChart<?, ?> lineChart) {
        HBox hBox = new HBox(new Node[]{lineChart});
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        hBox.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        lineChart.minWidthProperty().bind((ObservableValue)this.widthProperty().subtract(80.0 * (double)this.backgroundCharts.size()));
        lineChart.prefWidthProperty().bind((ObservableValue)this.widthProperty().subtract(80.0 * (double)this.backgroundCharts.size()));
        lineChart.maxWidthProperty().bind((ObservableValue)this.widthProperty().subtract(80.0 * (double)this.backgroundCharts.size()));
        return lineChart;
    }

    private void setFixedAxisWidth(LineChart<?, ?> chart) {
        chart.getYAxis().setPrefWidth(60.0);
        chart.getYAxis().setMaxWidth(60.0);
    }

    private void styleBackgroundChart(LineChart<?, ?> lineChart, Color lineColor) {
        Node chartPlotBackground;
        this.styleChartLine(lineChart, lineColor);
        Node chartContent = lineChart.lookup(".chart-content");
        if (chartContent != null && (chartPlotBackground = chartContent.lookup(".chart-plot-background")) != null) {
            chartPlotBackground.setStyle("-fx-background-color: transparent;");
        }
        lineChart.setVerticalZeroLineVisible(false);
        lineChart.setHorizontalZeroLineVisible(false);
        lineChart.setVerticalGridLinesVisible(false);
        lineChart.setHorizontalGridLinesVisible(false);
        lineChart.setCreateSymbols(false);
    }

    private void styleBaseChart(LineChart<?, ?> baseChart) {
        baseChart.setCreateSymbols(false);
        baseChart.setLegendVisible(false);
        baseChart.getXAxis().setAutoRanging(false);
        baseChart.getXAxis().setAnimated(false);
        baseChart.getYAxis().setAnimated(false);
    }

    private void styleChartLine(LineChart<?, ?> chart, Color lineColor) {
        chart.getYAxis().lookup(".axis-label").setStyle("-fx-text-fill: " + this.toRGBCode(lineColor) + "; -fx-font-weight: bold;");
        Node seriesLine = chart.lookup(".chart-series-line");
        seriesLine.setStyle("-fx-stroke: " + this.toRGBCode(lineColor) + "; -fx-stroke-width: " + this.strokeWidth + ";");
    }

    private String toRGBCode(Color color) {
        return String.format("#%02X%02X%02X", (int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0));
    }
}

