/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisLabelOverlapPolicy;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DoubleDataSet;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RotatedAxisLabelSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(RotatedAxisLabelSample.class);
    private static final int N_SAMPLES = 100;

    public void start(Stage primaryStage) {
        DefaultNumericAxis xAxis0 = new DefaultNumericAxis("default x-axis");
        xAxis0.setSide(Side.TOP);
        DefaultNumericAxis yAxis0 = new DefaultNumericAxis("default y-axis");
        yAxis0.setSide(Side.RIGHT);
        XYChart chart = new XYChart(new Axis[]{xAxis0, yAxis0});
        chart.getPlugins().add((Object)new Zoomer());
        DoubleDataSet dataSet1 = new DoubleDataSet("data set #1");
        chart.getDatasets().addAll((Object[])new DataSet[]{dataSet1});
        chart.setLegendVisible(false);
        for (AxisLabelOverlapPolicy policy : AxisLabelOverlapPolicy.values()) {
            DefaultNumericAxis xAxis1 = RotatedAxisLabelSample.getSynchedAxis(xAxis0, "x-axis (" + policy + ")");
            xAxis1.setSide(Side.BOTTOM);
            xAxis1.setOverlapPolicy(policy);
            DefaultNumericAxis yAxis1 = RotatedAxisLabelSample.getSynchedAxis(yAxis0, "y-axis (-90\u00b0, " + policy + ")");
            yAxis1.setSide(Side.LEFT);
            yAxis1.setTickLabelRotation(-90.0);
            yAxis1.setOverlapPolicy(policy);
            chart.getAxes().addAll((Object[])new Axis[]{xAxis1, yAxis1});
            if (!policy.equals((Object)AxisLabelOverlapPolicy.SKIP_ALT)) continue;
            DefaultNumericAxis xAxis2 = RotatedAxisLabelSample.getSynchedAxis(xAxis0, "x-axis (" + policy + ") + extra label spacing");
            xAxis2.setSide(Side.BOTTOM);
            xAxis2.setOverlapPolicy(policy);
            xAxis2.setTickLabelSpacing(10.0);
            DefaultNumericAxis yAxis2 = RotatedAxisLabelSample.getSynchedAxis(yAxis0, "y-axis (-90\u00b0, " + policy + ") + extra label spacing");
            yAxis2.setSide(Side.LEFT);
            yAxis2.setTickLabelRotation(-90.0);
            yAxis2.setOverlapPolicy(policy);
            yAxis2.setTickLabelSpacing(10.0);
            chart.getAxes().addAll((Object[])new Axis[]{xAxis2, yAxis2});
        }
        DefaultNumericAxis xAxis1 = RotatedAxisLabelSample.getSynchedAxis(xAxis0, "x-axis (45\u00b0)");
        xAxis1.setSide(Side.BOTTOM);
        xAxis1.setOverlapPolicy(AxisLabelOverlapPolicy.DO_NOTHING);
        xAxis1.setTickLabelRotation(45.0);
        xAxis1.setMaxMajorTickLabelCount(40);
        DefaultNumericAxis xAxis2 = RotatedAxisLabelSample.getSynchedAxis(xAxis0, "x-axis (90\u00b0)");
        xAxis2.setSide(Side.BOTTOM);
        xAxis2.setOverlapPolicy(AxisLabelOverlapPolicy.DO_NOTHING);
        xAxis2.setTickLabelRotation(90.0);
        xAxis2.setMaxMajorTickLabelCount(40);
        chart.getAxes().addAll((Object[])new Axis[]{xAxis1, xAxis2});
        DefaultNumericAxis yAxis1 = RotatedAxisLabelSample.getSynchedAxis(yAxis0, "y-axis (-45\u00b0)");
        yAxis1.setSide(Side.LEFT);
        yAxis1.setOverlapPolicy(AxisLabelOverlapPolicy.DO_NOTHING);
        yAxis1.setTickLabelRotation(-45.0);
        chart.getAxes().addAll((Object[])new Axis[]{yAxis1});
        for (int n = 0; n < 100; ++n) {
            dataSet1.add(12.34 * (double)n, 1330.0 * Math.cos(Math.toRadians(10.0 * (double)n)));
        }
        Scene scene = new Scene((Parent)new StackPane(new Node[]{chart}), 800.0, 800.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        LOGGER.atInfo().addArgument((Object)((Object)((Object)this)).getClass().getSimpleName()).log("sample {} started");
    }

    private static DefaultNumericAxis getSynchedAxis(DefaultNumericAxis orig, String newAxisName) {
        DefaultNumericAxis axis = new DefaultNumericAxis(newAxisName);
        axis.minProperty().bind((ObservableValue)orig.minProperty());
        axis.maxProperty().bind((ObservableValue)orig.maxProperty());
        axis.setTickLabelRotation(orig.getTickLabelRotation());
        return axis;
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

