/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Panner;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.spi.MountainRangeRenderer;
import de.gsi.chart.samples.ContourChartSample;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.GridDataSet;
import de.gsi.dataset.spi.AbstractDataSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MountainRangeRendererSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(MountainRangeRendererSample.class);
    private static final String EXPECTED_NON_NULL_LINE = "expected non-null line";

    public void start(Stage primaryStage) {
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        DefaultNumericAxis xAxis = new DefaultNumericAxis("X Position");
        DefaultNumericAxis yAxis = new DefaultNumericAxis("Y Position");
        XYChart chart = new XYChart(new Axis[]{xAxis, yAxis});
        chart.setTitle("Test data");
        MountainRangeRenderer mountainRangeRenderer = new MountainRangeRenderer();
        chart.getRenderers().set(0, (Object)mountainRangeRenderer);
        chart.getDatasets().setAll((Object[])new DataSet[]{this.createTestData(0.0)});
        chart.setLegendVisible(true);
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new Panner());
        chart.getPlugins().add((Object)new EditAxis());
        Spinner mountainRangeOffset = new Spinner(0.0, 10.0, mountainRangeRenderer.getMountainRangeOffset(), 0.1);
        mountainRangeRenderer.mountainRangeOffsetProperty().bind((ObservableValue)mountainRangeOffset.valueProperty());
        mountainRangeOffset.valueProperty().addListener((ch, o, n) -> {
            if (n.equals(o)) {
                return;
            }
            chart.requestLayout();
        });
        Scene scene = new Scene((Parent)new BorderPane((Node)chart, (Node)new ToolBar(new Node[]{new Label(""), mountainRangeOffset}), null, null, null), 1200.0, 800.0);
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
    }

    protected DataSet createData() {
        double[] x;
        double[] y = x = new double[]{-12.0, -9.0, -8.0, -7.0, -6.0, -5.0, -4.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 12.0};
        double[] z = new double[x.length * y.length];
        boolean i = false;
        for (double anY : y) {
            for (double anX : x) {
                z[0] = Math.sin(anY * anX);
            }
        }
        return new DefaultData("demoDataSet", x, y, z);
    }

    protected DataSet createTestData(double peakOffset) {
        double val;
        int i;
        int nPointsX = 2000;
        int nPointsY = 100;
        double[] x = new double[2000];
        double[] y = new double[100];
        for (i = 0; i < x.length; ++i) {
            x[i] = val = ((double)i / (double)x.length - 0.5) * 10.0;
        }
        for (i = 0; i < y.length; ++i) {
            y[i] = val = ((double)i / (double)y.length - 0.5) * 10.0;
        }
        double[] z = new double[x.length * y.length];
        int i2 = 0;
        for (int yIndex = 0; yIndex < y.length; ++yIndex) {
            for (double t : x) {
                double yRel = (double)yIndex / (double)y.length;
                double mean1 = -3.5;
                double mean2 = -1.0;
                double mean3 = 1.0;
                double mean4 = 3.5;
                double width1 = 2.0 * (1.0 - yRel);
                double width4 = 0.2 + 0.05 * Math.sin(Math.PI * 5 * yRel);
                double y1 = MountainRangeRendererSample.gaussian(t, -3.5 + peakOffset, width1);
                double y2 = MountainRangeRendererSample.gaussian(t, -1.0 + peakOffset + 0.3 * Math.sin(7.853981633974483 * yRel), 0.2);
                double y3 = MountainRangeRendererSample.gaussian(t, 1.0 + peakOffset + 0.3 * Math.sin(7.853981633974483 * yRel), 0.2);
                double y4 = MountainRangeRendererSample.gaussian(t, 3.5 + peakOffset, width4);
                z[i2++] = y1 + y2 + y3 + y4;
            }
        }
        return new DefaultData("demoDataSet", x, y, z);
    }

    protected DataSet readImage() {
        DefaultData defaultData;
        BufferedReader reader = new BufferedReader(new InputStreamReader(ContourChartSample.class.getResourceAsStream("./testdata/image.txt")));
        try {
            String skipLine = reader.readLine();
            if (skipLine == null) {
                throw new IllegalStateException(EXPECTED_NON_NULL_LINE);
            }
            String[] x = reader.readLine().split(" ");
            skipLine = reader.readLine();
            if (skipLine == null) {
                throw new IllegalStateException(EXPECTED_NON_NULL_LINE);
            }
            String[] y = reader.readLine().split(" ");
            skipLine = reader.readLine();
            if (skipLine == null) {
                throw new IllegalStateException(EXPECTED_NON_NULL_LINE);
            }
            String[] z = reader.readLine().split(" ");
            double[] xValues = MountainRangeRendererSample.toDouble(x);
            double[] yValues = MountainRangeRendererSample.toDouble(y);
            double[] zValues = new double[x.length * y.length];
            int i = 0;
            for (int yIdx = 0; yIdx < y.length; ++yIdx) {
                for (int xIdx = 0; xIdx < x.length; ++xIdx) {
                    zValues[i] = Double.parseDouble(z[i++]);
                }
            }
            defaultData = new DefaultData("contour data", xValues, yValues, zValues);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NullPointerException e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.atError().setCause((Throwable)e).log("error reading dataset");
                }
                return null;
            }
        }
        reader.close();
        return defaultData;
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private static double gaussian(double x, double mean, double sigma) {
        double norm = 1.0 / (sigma * Math.sqrt(Math.PI * 2));
        double is = 1.0 / sigma;
        double i2s2 = 0.5 * is * is;
        double xMinusMean = x - mean;
        return norm * Math.exp(-xMinusMean * xMinusMean * i2s2);
    }

    private static double[] toDouble(String[] stringValues) {
        double[] numberValues = new double[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            numberValues[i] = Double.parseDouble(stringValues[i]);
        }
        return numberValues;
    }

    public static class DefaultData
    extends AbstractDataSet<DefaultData>
    implements GridDataSet {
        private static final long serialVersionUID = 2094218221674496366L;
        private final double[] xValues;
        private final double[] yValues;
        private final double[] zValues;

        DefaultData(String name, double[] xValues, double[] yValues, double[] zValues) {
            super(name, 3);
            this.xValues = xValues;
            this.yValues = yValues;
            this.zValues = zValues;
        }

        public final double get(int dimIndex, int index) {
            switch (dimIndex) {
                case 0: {
                    return this.xValues[index % this.xValues.length];
                }
                case 1: {
                    return this.yValues[index / this.xValues.length];
                }
                case 2: {
                    return this.zValues[index];
                }
            }
            throw new IllegalArgumentException("dimIndex " + dimIndex + " not defined");
        }

        public int[] getShape() {
            return new int[]{this.xValues.length, this.yValues.length};
        }

        public int getDataCount() {
            return this.xValues.length * this.yValues.length;
        }

        public String getStyle(int index) {
            return null;
        }

        public double getValue(int dimIndex, double ... x) {
            return 0.0;
        }

        public DataSet set(DataSet other, boolean copy) {
            throw new UnsupportedOperationException("Copy setter not implemented");
        }

        public double getGrid(int dimIndex, int index) {
            switch (dimIndex) {
                case 0: {
                    return this.xValues[index];
                }
                case 1: {
                    return this.yValues[index];
                }
            }
            throw new IndexOutOfBoundsException("Dim index out of bounds 2 for 2d grid");
        }

        public int getGridIndex(int dimIndex, double x) {
            if (dimIndex >= this.getNGrid()) {
                throw new IndexOutOfBoundsException("dim index out of bounds");
            }
            if (this.getShape(dimIndex) == 0) {
                return 0;
            }
            if (!Double.isFinite(x)) {
                return 0;
            }
            if (x <= this.getAxisDescription(dimIndex).getMin()) {
                return 0;
            }
            int lastIndex = this.getShape(dimIndex) - 1;
            if (x >= this.getAxisDescription(dimIndex).getMax()) {
                return lastIndex;
            }
            return DefaultData.binarySearch((double)x, (int)0, (int)lastIndex, i -> this.getGrid(dimIndex, i));
        }

        public double get(int dimIndex, int ... indices) {
            switch (dimIndex) {
                case 0: {
                    return this.xValues[indices[0]];
                }
                case 1: {
                    return this.yValues[indices[1]];
                }
                case 2: {
                    return this.zValues[indices[0] + this.xValues.length * indices[1]];
                }
            }
            throw new IndexOutOfBoundsException("Dim index out of bounds 3 for 2d grid");
        }
    }
}

