/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.CategoryAxis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.plugins.DataPointTooltip;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.TableViewer;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.LineStyle;
import de.gsi.chart.renderer.spi.HistogramRenderer;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.Histogram;
import de.gsi.dataset.spi.AbstractHistogram;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistogramRendererBarSample
extends Application {
    public static final String TAG_REL = " rel.";
    public static final String TAG_ABS = " abs.";
    public static final int NBINS = 19;
    public static final String DEFAULT_COUNTRY = "OECD-total";
    private static final Logger LOGGER = LoggerFactory.getLogger(HistogramRendererBarSample.class);
    private static final String DEMO_DATA_FILE = "testdata/2007_OECD_population_age_distribution.csv";
    private static final String MEN = "men";
    private static final String WOMEN = "women";
    private static final Integer TAG_1980 = 1980;
    private static final Integer TAG_2000 = 2000;
    private static final Integer TAG_2050 = 2050;
    private final Map<String, Map<String, Map<Integer, Histogram>>> relDistribution = new ConcurrentHashMap<String, Map<String, Map<Integer, Histogram>>>();
    private final Map<String, Map<String, Map<Integer, Histogram>>> absDistribution = new ConcurrentHashMap<String, Map<String, Map<Integer, Histogram>>>();
    final HistogramRenderer histogramRenderer = new HistogramRenderer();

    public void start(Stage primaryStage) {
        this.loadDemoData(DEMO_DATA_FILE);
        BorderPane root = new BorderPane();
        Chart chart1 = HistogramRendererBarSample.getDefaultChart("population distribution by gender and age");
        root.setCenter((Node)chart1);
        this.histogramRenderer.setPolyLineStyle(LineStyle.HISTOGRAM);
        this.histogramRenderer.setAnimate(true);
        chart1.getRenderers().set(0, (Object)this.histogramRenderer);
        HistogramRendererParameterTooBar toolBarRenderer = new HistogramRendererParameterTooBar(this.histogramRenderer);
        ToolBar toolBarData = new ToolBar();
        ArrayList<String> countries = new ArrayList<String>(this.relDistribution.keySet());
        countries.sort(Comparator.comparing(String::toString));
        ComboBox country = new ComboBox(FXCollections.observableList(countries));
        country.getSelectionModel().select((Object)DEFAULT_COUNTRY);
        toolBarData.getItems().add((Object)new HBox(new Node[]{new Label("country: "), country}));
        ComboBox year = new ComboBox(FXCollections.observableList(List.of(TAG_1980, TAG_2000, TAG_2050)));
        year.getSelectionModel().select((Object)TAG_1980);
        toolBarData.getItems().add((Object)year);
        CheckBox relative = new CheckBox("relative: ");
        relative.setSelected(true);
        toolBarData.getItems().add((Object)relative);
        country.getSelectionModel().selectedItemProperty().addListener((ch, o, n) -> this.updateHistogram((String)country.getValue(), (Integer)year.getValue(), relative.isSelected()));
        year.getSelectionModel().selectedItemProperty().addListener((ch, o, n) -> this.updateHistogram((String)country.getValue(), (Integer)year.getValue(), relative.isSelected()));
        relative.selectedProperty().addListener((ch, o, n) -> this.updateHistogram((String)country.getValue(), (Integer)year.getValue(), relative.isSelected()));
        root.setTop((Node)new VBox(new Node[]{toolBarData, toolBarRenderer}));
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(new Scene((Parent)root, 800.0, 600.0));
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.show();
        this.updateHistogram((String)country.getValue(), (Integer)year.getValue(), relative.isSelected());
    }

    private void updateHistogram(String country, int year, boolean relative) {
        Map<String, Map<String, Map<Integer, Histogram>>> dist = relative ? this.relDistribution : this.absDistribution;
        this.histogramRenderer.getDatasets().setAll((Object[])new DataSet[]{(DataSet)dist.get(country).get(WOMEN).get(year), (DataSet)dist.get(country).get(MEN).get(year)});
        if (relative) {
            this.histogramRenderer.getFirstAxis(Orientation.HORIZONTAL).set("relative distribution", new String[]{"%"});
        } else {
            this.histogramRenderer.getFirstAxis(Orientation.HORIZONTAL).set("distribution", new String[0]);
            this.histogramRenderer.getFirstAxis(Orientation.HORIZONTAL).setUnit(null);
        }
    }

    private void loadDemoData(String fileName) {
        block10: {
            try (BufferedReader csvReader = Files.newBufferedReader(Paths.get(((Object)((Object)this)).getClass().getResource(fileName).toURI()));){
                String row = csvReader.readLine();
                assert (row != null && !row.isBlank() && row.contains("country"));
                while ((row = csvReader.readLine()) != null) {
                    String[] data = row.split(",");
                    String country = data[0];
                    String ageCategory = data[1];
                    Map relCountryMap = this.relDistribution.computeIfAbsent(country, c -> new ConcurrentHashMap());
                    Map relWomenDistribution = relCountryMap.computeIfAbsent(WOMEN, g -> new ConcurrentHashMap());
                    Map relMenDistribution = relCountryMap.computeIfAbsent(MEN, g -> new ConcurrentHashMap());
                    MyHistogram relWomenDistribution1980 = (MyHistogram)relWomenDistribution.computeIfAbsent(TAG_1980, y -> new MyHistogram(TAG_1980 + ": " + country + " - women rel."));
                    MyHistogram relMenDistribution1980 = (MyHistogram)relMenDistribution.computeIfAbsent(TAG_1980, y -> new MyHistogram(TAG_1980 + ": " + country + " - men rel."));
                    MyHistogram relWomenDistribution2000 = (MyHistogram)relWomenDistribution.computeIfAbsent(TAG_2000, y -> new MyHistogram(TAG_2000 + ": " + country + " - women rel."));
                    MyHistogram relMenDistribution2000 = (MyHistogram)relMenDistribution.computeIfAbsent(TAG_2000, y -> new MyHistogram(TAG_2000 + ": " + country + " - men rel."));
                    MyHistogram relWomenDistribution2050 = (MyHistogram)relWomenDistribution.computeIfAbsent(TAG_2050, y -> new MyHistogram(TAG_2050 + ": " + country + " - women rel."));
                    MyHistogram relMenDistribution2050 = (MyHistogram)relMenDistribution.computeIfAbsent(TAG_2050, y -> new MyHistogram(TAG_2050 + ": " + country + " - men rel."));
                    relWomenDistribution1980.fill(ageCategory, Double.parseDouble(data[5]));
                    relWomenDistribution2000.fill(ageCategory, Double.parseDouble(data[6]));
                    relWomenDistribution2050.fill(ageCategory, Double.parseDouble(data[7]));
                    relMenDistribution1980.fill(ageCategory, -Double.parseDouble(data[2]));
                    relMenDistribution2000.fill(ageCategory, -Double.parseDouble(data[3]));
                    relMenDistribution2050.fill(ageCategory, -Double.parseDouble(data[4]));
                    Map absCountryMap = this.absDistribution.computeIfAbsent(country, c -> new ConcurrentHashMap());
                    Map absWomenDistribution = absCountryMap.computeIfAbsent(WOMEN, g -> new ConcurrentHashMap());
                    Map absMenDistribution = absCountryMap.computeIfAbsent(MEN, g -> new ConcurrentHashMap());
                    MyHistogram absWomenDistribution1980 = (MyHistogram)absWomenDistribution.computeIfAbsent(TAG_1980, y -> new MyHistogram(TAG_1980 + ": " + country + " - women abs."));
                    MyHistogram absMenDistribution1980 = (MyHistogram)absMenDistribution.computeIfAbsent(TAG_1980, y -> new MyHistogram(TAG_1980 + ": " + country + " - men abs."));
                    MyHistogram absWomenDistribution2000 = (MyHistogram)absWomenDistribution.computeIfAbsent(TAG_2000, y -> new MyHistogram(TAG_2000 + ": " + country + " - women abs."));
                    MyHistogram absMenDistribution2000 = (MyHistogram)absMenDistribution.computeIfAbsent(TAG_2000, y -> new MyHistogram(TAG_2000 + ": " + country + " - men abs."));
                    MyHistogram absWomenDistribution2050 = (MyHistogram)absWomenDistribution.computeIfAbsent(TAG_2050, y -> new MyHistogram(TAG_2050 + ": " + country + " - women abs."));
                    MyHistogram absMenDistribution2050 = (MyHistogram)absMenDistribution.computeIfAbsent(TAG_2050, y -> new MyHistogram(TAG_2050 + ": " + country + " - men rel."));
                    absWomenDistribution1980.fill(ageCategory, Double.parseDouble(data[11]));
                    absWomenDistribution2000.fill(ageCategory, Double.parseDouble(data[12]));
                    absWomenDistribution2050.fill(ageCategory, Double.parseDouble(data[13]));
                    absMenDistribution1980.fill(ageCategory, -Double.parseDouble(data[8]));
                    absMenDistribution2000.fill(ageCategory, -Double.parseDouble(data[9]));
                    absMenDistribution2050.fill(ageCategory, -Double.parseDouble(data[10]));
                }
            }
            catch (IOException | URISyntaxException e) {
                if (!LOGGER.isErrorEnabled()) break block10;
                LOGGER.atError().setCause((Throwable)e).log("InterruptedException");
            }
        }
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private static Chart getDefaultChart(String title) {
        DefaultNumericAxis xAxis = new DefaultNumericAxis();
        xAxis.setAutoRangeRounding(true);
        xAxis.setAutoRangePadding(0.2);
        CategoryAxis yAxis = new CategoryAxis("age group");
        yAxis.setSide(Side.CENTER_VER);
        DefaultNumericAxis yAxis2 = new DefaultNumericAxis("age group", null);
        yAxis2.setSide(Side.CENTER_VER);
        XYChart chart = new XYChart(new Axis[]{xAxis, yAxis});
        chart.setTitle(title);
        chart.getPlugins().addAll((Object[])new ChartPlugin[]{new Zoomer(), new DataPointTooltip(), new TableViewer(), new EditAxis()});
        HBox.setHgrow((Node)chart, (Priority)Priority.ALWAYS);
        yAxis.setSide(Side.CENTER_VER);
        return chart;
    }

    private static class HistogramRendererParameterTooBar
    extends ToolBar {
        private final HistogramRenderer histogramRenderer;

        public HistogramRendererParameterTooBar(HistogramRenderer histogramRenderer) {
            this.histogramRenderer = histogramRenderer;
            this.init();
        }

        private void init() {
            ComboBox lineStyle = new ComboBox(FXCollections.observableList(List.of(LineStyle.values())));
            lineStyle.getSelectionModel().select((Object)LineStyle.HISTOGRAM);
            this.getItems().add((Object)lineStyle);
            CheckBox drawBars = new CheckBox();
            drawBars.setSelected(this.histogramRenderer.isDrawBars());
            this.addToParameterPane("Draw Bars: ", (Node)drawBars);
            lineStyle.valueProperty().addListener((ch, o, n) -> {
                this.histogramRenderer.setPolyLineStyle(n);
                if (n != LineStyle.NONE) {
                    drawBars.setSelected(false);
                }
                this.histogramRenderer.requestLayout();
            });
            drawBars.selectedProperty().addListener((ch, old, selected) -> {
                this.histogramRenderer.setDrawBars(selected.booleanValue());
                if (Boolean.TRUE.equals(selected)) {
                    lineStyle.getSelectionModel().select((Object)LineStyle.NONE);
                }
                this.histogramRenderer.requestLayout();
            });
            CheckBox dynBarWidthEnable = new CheckBox();
            dynBarWidthEnable.setSelected(this.histogramRenderer.isDynamicBarWidth());
            dynBarWidthEnable.selectedProperty().addListener((ch, old, selected) -> {
                this.histogramRenderer.setDynamicBarWidth(selected.booleanValue());
                this.histogramRenderer.requestLayout();
            });
            this.addToParameterPane("   Dyn. Bar Width: ", (Node)dynBarWidthEnable);
            Spinner dynBarWidth = new Spinner(0.0, 100.0, this.histogramRenderer.getBarWidthPercentage(), 10.0);
            dynBarWidth.valueProperty().addListener((ch, old, value) -> {
                this.histogramRenderer.setBarWidthPercentage((double)value.intValue());
                this.histogramRenderer.requestLayout();
            });
            this.addToParameterPane("   Dyn. Bar Width: ", (Node)dynBarWidth);
            Spinner barWidth = new Spinner(0, 100, this.histogramRenderer.getBarWidth());
            barWidth.valueProperty().addListener((ch, old, value) -> {
                this.histogramRenderer.setBarWidth(value.intValue());
                this.histogramRenderer.requestLayout();
            });
            this.addToParameterPane("   Abs. Bar Width: ", (Node)barWidth);
            CheckBox shiftBar = new CheckBox();
            shiftBar.setSelected(this.histogramRenderer.isShiftBar());
            shiftBar.selectedProperty().addListener((ch, old, selected) -> {
                this.histogramRenderer.setShiftBar(selected.booleanValue());
                this.histogramRenderer.requestLayout();
            });
            this.addToParameterPane("   Shift Bar (mult. data sets): ", (Node)shiftBar);
            Spinner shiftBarOffset = new Spinner(0, 100, this.histogramRenderer.getShiftBarOffset());
            shiftBarOffset.valueProperty().addListener((ch, old, value) -> {
                this.histogramRenderer.setshiftBarOffset(value.intValue());
                this.histogramRenderer.requestLayout();
            });
            this.addToParameterPane("   Shift Bar Offset (mult. DS): ", (Node)shiftBarOffset);
        }

        public void addToParameterPane(String label, Node node) {
            this.getItems().addAll((Object[])new Node[]{new Label(label), node});
        }
    }

    public static class MyHistogram
    extends de.gsi.dataset.spi.Histogram {
        public MyHistogram(String name) {
            super(name, 19, 0.0, 18.0, false, AbstractHistogram.HistogramOuterBounds.BINS_CENTERED_ON_BOUNDARY);
            this.addDataLabel(18, "-");
            this.addDataLabel(17, "85+");
            this.addDataLabel(16, "80 - 84");
            this.addDataLabel(15, "75 - 79");
            this.addDataLabel(14, "70 - 74");
            this.addDataLabel(13, "65 - 69");
            this.addDataLabel(12, "60 - 64");
            this.addDataLabel(11, "55 - 59");
            this.addDataLabel(10, "50 - 54");
            this.addDataLabel(9, "45 - 49");
            this.addDataLabel(8, "40 - 44");
            this.addDataLabel(7, "35 - 39");
            this.addDataLabel(6, "30 - 34");
            this.addDataLabel(5, "25 - 29");
            this.addDataLabel(4, "20 - 24");
            this.addDataLabel(3, "15 - 19");
            this.addDataLabel(2, "10 - 14");
            this.addDataLabel(1, "5 - 9");
            this.addDataLabel(0, "0 - 4");
        }

        public void fill(String dataLabel, double value) {
            for (int i = 0; i < this.getDataCount(); ++i) {
                if (this.getDataLabel(i) == null || !this.getDataLabel(i).equals(dataLabel)) continue;
                this.addBinContent(i + 1, value);
                return;
            }
            LOGGER.atWarn().addArgument((Object)dataLabel).addArgument((Object)value).log("encountered unknown label '{}' -  adding value = {} to under-flow bin");
            this.addBinContent(0, value);
        }
    }
}

