/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.ParameterMeasurements;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.LineStyle;
import de.gsi.chart.renderer.spi.ContourDataSetRenderer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.renderer.spi.MetaDataRenderer;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.chart.utils.FXUtils;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.AbstractHistogram;
import de.gsi.dataset.spi.Histogram2;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class Histogram2DimSample
extends Application {
    private static final int UPDATE_DELAY = 1000;
    private static final int UPDATE_PERIOD = 100;
    private static final int UPDATE_N_SAMPLES = 10;
    private static final int N_BINS_X = 120;
    private static final int N_BINS_Y = 120;
    private final Random rnd = new Random();
    private final Histogram2 histogram1 = new Histogram2("hist1", 120, 0.0, 20.0, 120, 0.0, 30.0, AbstractHistogram.HistogramOuterBounds.BINS_ALIGNED_WITH_BOUNDARY);
    private final Histogram2 histogram2 = new Histogram2("hist2", 120, 0.0, 20.0, 120, 0.0, 30.0, AbstractHistogram.HistogramOuterBounds.BINS_ALIGNED_WITH_BOUNDARY);
    private int counter;

    private void fillData() {
        ++this.counter;
        this.histogram1.autoNotification().set(false);
        this.histogram2.autoNotification().set(false);
        double angle = 0.7853981633974483;
        for (int i = 0; i < 10; ++i) {
            double x0 = this.rnd.nextGaussian() * 0.5 + 5.0;
            double y0 = this.rnd.nextGaussian() * 0.5 + 5.0;
            double x = this.rnd.nextGaussian() * 1.5;
            double y = this.rnd.nextGaussian() * 0.5;
            double x1 = x * Math.sin(0.7853981633974483) + y * Math.cos(0.7853981633974483);
            double x2 = x * Math.cos(0.7853981633974483) - y * Math.sin(0.7853981633974483);
            this.histogram1.fill(x0, y0);
            this.histogram2.fill(x1 + 14.0, x2 + 20.0);
        }
        this.histogram1.autoNotification().set(true);
        this.histogram2.autoNotification().set(true);
        this.histogram1.fireInvalidated(null);
        this.histogram2.fireInvalidated(null);
        if (this.counter % 500 == 0) {
            this.counter = 0;
            this.histogram1.reset();
            this.histogram2.reset();
        }
    }

    public void start(Stage primaryStage) {
        StackPane root = new StackPane();
        DefaultNumericAxis xAxis = new DefaultNumericAxis("x-Axis");
        xAxis.setAutoRanging(true);
        xAxis.setAutoRangeRounding(false);
        xAxis.setSide(Side.BOTTOM);
        DefaultNumericAxis yAxis = new DefaultNumericAxis("y-Axis");
        yAxis.setAutoRanging(true);
        yAxis.setAutoRangeRounding(false);
        yAxis.setSide(Side.LEFT);
        DefaultNumericAxis zAxis = new DefaultNumericAxis("z Amplitude");
        zAxis.setAnimated(false);
        zAxis.setAutoRangeRounding(false);
        zAxis.setAutoRanging(true);
        zAxis.setSide(Side.RIGHT);
        DefaultNumericAxis yAxis1 = new DefaultNumericAxis("y-Axis x-Projection");
        yAxis1.setLogAxis(false);
        yAxis1.setAnimated(false);
        yAxis1.setAutoRangeRounding(true);
        yAxis1.setAutoRangePadding(2.0);
        yAxis1.setAutoRanging(true);
        yAxis1.setSide(Side.RIGHT);
        DefaultNumericAxis xAxis1 = new DefaultNumericAxis("x-Axis y-Projection");
        xAxis1.setLogAxis(false);
        yAxis1.setAnimated(false);
        xAxis1.setAutoRangeRounding(true);
        xAxis1.setAutoRangePadding(2.0);
        xAxis1.setAutoRanging(true);
        xAxis1.setSide(Side.TOP);
        final XYChart chart = new XYChart(new Axis[]{xAxis, yAxis});
        chart.setAnimated(false);
        ContourDataSetRenderer heatMap = new ContourDataSetRenderer();
        heatMap.getAxes().addAll((Object[])new Axis[]{xAxis, yAxis, zAxis});
        heatMap.getDatasets().addAll((Object[])new DataSet[]{this.histogram1, this.histogram2});
        chart.getRenderers().set(0, (Object)heatMap);
        ErrorDataSetRenderer projectionRendererX = new ErrorDataSetRenderer();
        projectionRendererX.getAxes().setAll((Object[])new Axis[]{xAxis, yAxis1});
        projectionRendererX.getDatasets().setAll((Object[])new DataSet[]{this.histogram1.getProjectionX(), this.histogram2.getProjectionX()});
        this.histogram1.getProjectionX().setStyle("dsIndex=0");
        this.histogram2.getProjectionX().setStyle("dsIndex=1");
        projectionRendererX.setPolyLineStyle(LineStyle.HISTOGRAM);
        projectionRendererX.setPointReduction(false);
        chart.getRenderers().add((Object)projectionRendererX);
        ErrorDataSetRenderer projectionRendererY = new ErrorDataSetRenderer();
        projectionRendererY.getAxes().setAll((Object[])new Axis[]{xAxis1, yAxis});
        projectionRendererY.getDatasets().setAll((Object[])new DataSet[]{this.histogram1.getProjectionY(), this.histogram2.getProjectionY()});
        this.histogram1.getProjectionY().setStyle("dsIndex=0");
        this.histogram2.getProjectionY().setStyle("dsIndex=1");
        projectionRendererY.setPolyLineStyle(LineStyle.HISTOGRAM);
        projectionRendererY.setPointReduction(false);
        projectionRendererY.setAssumeSortedData(false);
        chart.getRenderers().add((Object)projectionRendererY);
        MetaDataRenderer metaRenderer = new MetaDataRenderer((Chart)chart);
        metaRenderer.getDatasets().addAll((Object[])new DataSet[]{this.histogram2, this.histogram1});
        chart.getRenderers().add((Object)metaRenderer);
        chart.legendVisibleProperty().set(true);
        chart.getPlugins().add((Object)new ParameterMeasurements());
        chart.getPlugins().add((Object)new EditAxis());
        Zoomer zoomer = new Zoomer();
        zoomer.setSliderVisible(false);
        chart.getPlugins().add((Object)zoomer);
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        root.getChildren().add((Object)chart);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.show();
        Timer timer = new Timer("sample-update-timer", true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Histogram2DimSample.this.fillData();
                FXUtils.runFX(() -> ((XYChart)chart).requestLayout());
            }
        }, 1000L, 100L);
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

