/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.DataPointTooltip;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Panner;
import de.gsi.chart.plugins.TableViewer;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.LineStyle;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.datareduction.DefaultDataReducer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.samples.RollingBufferSample;
import de.gsi.chart.ui.ProfilerInfoBox;
import de.gsi.dataset.testdata.spi.CosineFunction;
import de.gsi.dataset.testdata.spi.GaussFunction;
import de.gsi.dataset.testdata.spi.RandomStepFunction;
import de.gsi.dataset.testdata.spi.RandomWalkFunction;
import de.gsi.dataset.testdata.spi.SincFunction;
import de.gsi.dataset.testdata.spi.SineFunction;
import de.gsi.dataset.testdata.spi.SingleOutlierFunction;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorDataSetRendererStylingSample
extends Application {
    private static final String STOP_TIMER = "stop timer";
    private static final String START_TIMER = "start timer";
    private static final Logger LOGGER = LoggerFactory.getLogger(RollingBufferSample.class);
    private static final int DEBUG_UPDATE_RATE = 1000;
    private static final int DEFAULT_WIDTH = 1200;
    private static final int DEFAULT_HEIGHT = 600;
    private static final int UPDATE_DELAY = 1000;
    private static final int UPDATE_PERIOD = 100;
    private static final double N_MAX_SAMPLES = 10000.0;
    private DataSetType dataSetType = DataSetType.RANDOM_WALK;
    private int nSamples = 400;
    private Timer timer;

    private void generateData(XYChart chart) {
        long startTime = ProcessingProfiler.getTimeStamp();
        ArrayList<Object> dataSet = new ArrayList<Object>();
        switch (this.dataSetType) {
            case OUTLIER: {
                dataSet.add(new SingleOutlierFunction("function with single outlier", this.nSamples));
                break;
            }
            case STEP: {
                dataSet.add(new RandomStepFunction("random step function", this.nSamples));
                break;
            }
            case SINC: {
                dataSet.add(new SincFunction("sinc function", this.nSamples));
                break;
            }
            case GAUSS: {
                dataSet.add(new GaussFunction("gauss function", this.nSamples));
                break;
            }
            case SINE: {
                dataSet.add(new SineFunction("sine function", this.nSamples));
                break;
            }
            case COSINE: {
                dataSet.add(new CosineFunction("cosine function", this.nSamples));
                break;
            }
            case MIX_TRIGONOMETRIC: {
                dataSet.add(new SineFunction("dyn. sine function", this.nSamples, true));
                dataSet.add(new CosineFunction("dyn. cosine function", this.nSamples, true));
                break;
            }
            default: {
                dataSet.add(new RandomWalkFunction("random walk data", this.nSamples));
            }
        }
        Platform.runLater(() -> {
            ((Renderer)chart.getRenderers().get(0)).getDatasets().setAll((Collection)dataSet);
            chart.requestLayout();
        });
        startTime = ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data into DataSet");
    }

    private ParameterTab getAxisTab(String name, XYChart chart, DefaultNumericAxis axis) {
        ParameterTab pane = new ParameterTab(name);
        CheckBox animated = new CheckBox();
        animated.selectedProperty().bindBidirectional((Property)axis.animatedProperty());
        animated.selectedProperty().addListener((ch, old, selected) -> chart.requestLayout());
        pane.addToParameterPane("Amimated: ", (Node)animated);
        CheckBox autoranging = new CheckBox();
        autoranging.selectedProperty().bindBidirectional((Property)axis.autoRangingProperty());
        autoranging.selectedProperty().addListener((ch, old, selected) -> chart.requestLayout());
        pane.addToParameterPane("Auto-Ranging: ", (Node)autoranging);
        CheckBox autogrowranging = new CheckBox();
        autogrowranging.selectedProperty().bindBidirectional((Property)axis.autoGrowRangingProperty());
        autogrowranging.selectedProperty().addListener((ch, old, selected) -> chart.requestLayout());
        pane.addToParameterPane("Auto-Grow-Ranging: ", (Node)autogrowranging);
        Spinner upperRange = new Spinner(-10000.0, 10000.0, axis.getMin(), 0.1);
        upperRange.valueProperty().addListener((ch, old, value) -> {
            axis.setMax(value.doubleValue());
            chart.requestLayout();
        });
        pane.addToParameterPane("   Upper Bound): ", (Node)upperRange);
        Spinner lowerRange = new Spinner(-10000.0, 10000.0, axis.getMin(), 0.1);
        lowerRange.valueProperty().addListener((ch, old, value) -> {
            axis.setMin(value.doubleValue());
            chart.requestLayout();
        });
        pane.addToParameterPane("   Lower Bound): ", (Node)lowerRange);
        CheckBox autoRangeRounding = new CheckBox();
        autoRangeRounding.selectedProperty().bindBidirectional((Property)axis.autoRangeRoundingProperty());
        autoRangeRounding.selectedProperty().addListener((ch, old, selected) -> chart.requestLayout());
        pane.addToParameterPane("Auto-Range-Rounding: ", (Node)autoRangeRounding);
        Spinner autoRangePadding = new Spinner(0.0, 100.0, axis.getAutoRangePadding(), 0.05);
        autoRangePadding.valueProperty().addListener((ch, old, value) -> {
            axis.setAutoRangePadding(value.doubleValue());
            chart.requestLayout();
        });
        pane.addToParameterPane("   auto-range padding): ", (Node)autoRangePadding);
        CheckBox logAxis = new CheckBox();
        logAxis.selectedProperty().bindBidirectional((Property)axis.logAxisProperty());
        logAxis.selectedProperty().addListener((ch, old, selected) -> chart.requestLayout());
        pane.addToParameterPane("Log-Axis: ", (Node)logAxis);
        CheckBox timeAxis = new CheckBox();
        timeAxis.selectedProperty().bindBidirectional((Property)axis.timeAxisProperty());
        timeAxis.selectedProperty().addListener((ch, old, selected) -> chart.requestLayout());
        pane.addToParameterPane("Time-Axis: ", (Node)timeAxis);
        CheckBox invertAxis = new CheckBox();
        invertAxis.selectedProperty().bindBidirectional((Property)axis.invertAxisProperty());
        invertAxis.selectedProperty().addListener((ch, old, selected) -> chart.requestLayout());
        pane.addToParameterPane("Invert-Axis: ", (Node)invertAxis);
        CheckBox autoUnit = new CheckBox();
        autoUnit.selectedProperty().bindBidirectional((Property)axis.autoUnitScalingProperty());
        autoUnit.selectedProperty().addListener((ch, old, selected) -> chart.requestLayout());
        pane.addToParameterPane("Auto Unit: ", (Node)autoUnit);
        pane.addToParameterPane(" ", null);
        return pane;
    }

    private Tab getChartTab(XYChart chart) {
        ParameterTab pane = new ParameterTab("Chart");
        CheckBox gridVisibleX = new CheckBox("");
        gridVisibleX.setSelected(true);
        chart.horizontalGridLinesVisibleProperty().bindBidirectional((Property)gridVisibleX.selectedProperty());
        pane.addToParameterPane("Show X-Grid: ", (Node)gridVisibleX);
        CheckBox gridVisibleXMinor = new CheckBox("");
        gridVisibleXMinor.setSelected(true);
        chart.getGridRenderer().getVerticalMinorGrid().visibleProperty().bindBidirectional((Property)gridVisibleXMinor.selectedProperty());
        pane.addToParameterPane("Show Minor X-Grid: ", (Node)gridVisibleXMinor);
        CheckBox gridVisibleY = new CheckBox("");
        gridVisibleY.setSelected(true);
        chart.verticalGridLinesVisibleProperty().bindBidirectional((Property)gridVisibleY.selectedProperty());
        pane.addToParameterPane("Show Y-Grid: ", (Node)gridVisibleY);
        CheckBox gridVisibleYMinor = new CheckBox("");
        gridVisibleYMinor.setSelected(true);
        chart.getGridRenderer().getHorizontalMinorGrid().visibleProperty().bindBidirectional((Property)gridVisibleYMinor.selectedProperty());
        pane.addToParameterPane("Show Minor Y-Grid: ", (Node)gridVisibleYMinor);
        CheckBox gridOnTop = new CheckBox("");
        gridOnTop.setSelected(true);
        chart.getGridRenderer().drawOnTopProperty().bindBidirectional((Property)gridOnTop.selectedProperty());
        pane.addToParameterPane("Grid on top: ", (Node)gridOnTop);
        return pane;
    }

    private HBox getHeaderBar(XYChart chart) {
        Button newDataSet = new Button("new DataSet");
        newDataSet.setOnAction(evt -> Platform.runLater((Runnable)this.getTimerTask(chart)));
        Button startTimer = new Button(START_TIMER);
        startTimer.setOnAction(evt -> {
            if (this.timer == null) {
                startTimer.setText(STOP_TIMER);
                this.timer = new Timer("sample-update-timer", true);
                this.timer.scheduleAtFixedRate(this.getTimerTask(chart), 1000L, 100L);
            } else {
                startTimer.setText(START_TIMER);
                this.timer.cancel();
                this.timer = null;
            }
        });
        ComboBox dataSetTypeSelector = new ComboBox();
        dataSetTypeSelector.getItems().addAll((Object[])DataSetType.values());
        dataSetTypeSelector.setValue((Object)this.dataSetType);
        dataSetTypeSelector.valueProperty().addListener((ch, old, selection) -> {
            this.dataSetType = selection;
            this.generateData(chart);
        });
        Region spacer = new Region();
        spacer.setMinWidth(Double.NEGATIVE_INFINITY);
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        ProfilerInfoBox profilerInfoBox = new ProfilerInfoBox(1000);
        profilerInfoBox.setDebugLevel(ProfilerInfoBox.DebugLevel.VERSION);
        return new HBox(new Node[]{new Label("Function Type: "), dataSetTypeSelector, newDataSet, startTimer, spacer, profilerInfoBox});
    }

    private ParameterTab getRendererTab(XYChart chart, ErrorDataSetRenderer errorRenderer) {
        ParameterTab pane = new ParameterTab("Renderer");
        ComboBox polyLineSelect = new ComboBox();
        polyLineSelect.getItems().addAll((Object[])LineStyle.values());
        polyLineSelect.setValue((Object)LineStyle.NORMAL);
        polyLineSelect.valueProperty().addListener((ch, old, selection) -> {
            errorRenderer.setPolyLineStyle(selection);
            chart.requestLayout();
        });
        pane.addToParameterPane("PolyLine Style: ", (Node)polyLineSelect);
        ComboBox errorStyleSelect = new ComboBox();
        errorStyleSelect.getItems().addAll((Object[])ErrorStyle.values());
        errorStyleSelect.setValue((Object)errorRenderer.getErrorType());
        errorStyleSelect.valueProperty().addListener((ch, old, selection) -> {
            errorRenderer.setErrorType(selection);
            chart.requestLayout();
        });
        pane.addToParameterPane("Error-Bar Style: ", (Node)errorStyleSelect);
        pane.addToParameterPane(" ", null);
        CheckBox drawMarker = new CheckBox();
        drawMarker.setSelected(errorRenderer.isDrawMarker());
        drawMarker.selectedProperty().addListener((ch, old, selected) -> {
            errorRenderer.setDrawMarker(selected.booleanValue());
            chart.requestLayout();
        });
        pane.addToParameterPane("Draw Markers: ", (Node)drawMarker);
        Spinner markerSize = new Spinner(0.0, 100.0, errorRenderer.getMarkerSize(), 0.5);
        markerSize.isEditable();
        markerSize.valueProperty().addListener((ch, old, value) -> {
            errorRenderer.setMarkerSize((double)value.intValue());
            chart.requestLayout();
        });
        pane.addToParameterPane("   Marker Size: ", (Node)markerSize);
        Spinner dashSize = new Spinner(0, 100, errorRenderer.getDashSize(), 1);
        dashSize.isEditable();
        dashSize.valueProperty().addListener((ch, old, value) -> {
            errorRenderer.setDashSize(value.intValue());
            chart.requestLayout();
        });
        pane.addToParameterPane("Cap Dash Size: ", (Node)dashSize);
        pane.addToParameterPane(" ", null);
        CheckBox drawBars = new CheckBox();
        drawBars.setSelected(errorRenderer.isDrawBars());
        drawBars.selectedProperty().addListener((ch, old, selected) -> {
            errorRenderer.setDrawBars(selected.booleanValue());
            chart.requestLayout();
        });
        pane.addToParameterPane("Draw Bars: ", (Node)drawBars);
        CheckBox dynBarWidthEnable = new CheckBox();
        dynBarWidthEnable.setSelected(errorRenderer.isDynamicBarWidth());
        dynBarWidthEnable.selectedProperty().addListener((ch, old, selected) -> {
            errorRenderer.setDynamicBarWidth(selected.booleanValue());
            chart.requestLayout();
        });
        pane.addToParameterPane("   Dyn. Bar Width: ", (Node)dynBarWidthEnable);
        Spinner dynBarWidth = new Spinner(0.0, 100.0, errorRenderer.getBarWidthPercentage(), 10.0);
        dynBarWidth.valueProperty().addListener((ch, old, value) -> {
            errorRenderer.setBarWidthPercentage((double)value.intValue());
            chart.requestLayout();
        });
        pane.addToParameterPane("   Dyn. Bar Width: ", (Node)dynBarWidth);
        Spinner barWidth = new Spinner(0, 100, errorRenderer.getBarWidth());
        barWidth.valueProperty().addListener((ch, old, value) -> {
            errorRenderer.setBarWidth(value.intValue());
            chart.requestLayout();
        });
        pane.addToParameterPane("   Abs. Bar Width: ", (Node)barWidth);
        CheckBox shiftBar = new CheckBox();
        shiftBar.setSelected(errorRenderer.isShiftBar());
        shiftBar.selectedProperty().addListener((ch, old, selected) -> {
            errorRenderer.setShiftBar(selected.booleanValue());
            chart.requestLayout();
        });
        pane.addToParameterPane("   Shift Bar (mult. data sets): ", (Node)shiftBar);
        Spinner shiftBarOffset = new Spinner(0, 100, errorRenderer.getShiftBarOffset());
        shiftBarOffset.valueProperty().addListener((ch, old, value) -> {
            errorRenderer.setshiftBarOffset(value.intValue());
            chart.requestLayout();
        });
        pane.addToParameterPane("   Shift Bar Offset (mult. DS): ", (Node)shiftBarOffset);
        pane.addToParameterPane(" ", null);
        CheckBox pointReduction = new CheckBox();
        pointReduction.selectedProperty().bindBidirectional((Property)errorRenderer.pointReductionProperty());
        pointReduction.selectedProperty().addListener((ch, old, selected) -> chart.requestLayout());
        pane.addToParameterPane("Point Reduction: ", (Node)pointReduction);
        DefaultDataReducer dataReducer = (DefaultDataReducer)errorRenderer.getRendererDataReducer();
        Spinner reductionMinSize = new Spinner(0, 1000, errorRenderer.getMinRequiredReductionSize());
        reductionMinSize.setEditable(true);
        errorRenderer.minRequiredReductionSizeProperty().bind((ObservableValue)reductionMinSize.valueProperty());
        reductionMinSize.valueProperty().addListener((ch, old, value) -> chart.requestLayout());
        pane.addToParameterPane("   Min Req. Samples: ", (Node)reductionMinSize);
        Spinner reductionDashSize = new Spinner(0, 100, dataReducer.getMinPointPixelDistance());
        dataReducer.minPointPixelDistanceProperty().bind((ObservableValue)reductionDashSize.valueProperty());
        reductionDashSize.valueProperty().addListener((ch, old, value) -> chart.requestLayout());
        pane.addToParameterPane("   Red. Min Distance: ", (Node)reductionDashSize);
        pane.addToParameterPane(" ", null);
        CheckBox assumeSorted = new CheckBox();
        assumeSorted.selectedProperty().bindBidirectional((Property)errorRenderer.assumeSortedDataProperty());
        assumeSorted.selectedProperty().addListener((ch, old, selected) -> chart.requestLayout());
        pane.addToParameterPane("Assume sorted data: ", (Node)assumeSorted);
        pane.addToParameterPane(" ", null);
        CheckBox cacheParallel = new CheckBox();
        cacheParallel.selectedProperty().bindBidirectional((Property)errorRenderer.parallelImplementationProperty());
        cacheParallel.selectedProperty().addListener((ch, old, selected) -> chart.requestLayout());
        pane.addToParameterPane("   Point cache parallel: ", (Node)cacheParallel);
        return pane;
    }

    public TimerTask getTimerTask(final XYChart chart) {
        return new TimerTask(){
            private int updateCount;

            @Override
            public void run() {
                ErrorDataSetRendererStylingSample.this.generateData(chart);
                if (this.updateCount % 10 == 0 && LOGGER.isDebugEnabled()) {
                    LOGGER.atDebug().addArgument((Object)this.updateCount).log("update iteration #{}");
                }
                ++this.updateCount;
            }
        };
    }

    public void start(Stage primaryStage) {
        ProcessingProfiler.setVerboseOutputState((boolean)false);
        ProcessingProfiler.setLoggerOutputState((boolean)true);
        ProcessingProfiler.setDebugState((boolean)false);
        BorderPane root = new BorderPane();
        Scene scene = new Scene((Parent)root, 1200.0, 600.0);
        DefaultNumericAxis xAxis = new DefaultNumericAxis();
        xAxis.setUnit("Largeness");
        xAxis.setMouseTransparent(true);
        DefaultNumericAxis yAxis = new DefaultNumericAxis();
        yAxis.setUnit("Coolness");
        XYChart chart = new XYChart(new Axis[]{xAxis, yAxis});
        chart.getXAxis().setName("x axis");
        chart.getYAxis().setName("y axis");
        chart.legendVisibleProperty().set(true);
        chart.setAnimated(false);
        ErrorDataSetRenderer errorRenderer = new ErrorDataSetRenderer();
        chart.getRenderers().set(0, (Object)errorRenderer);
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new Panner());
        chart.getPlugins().add((Object)new EditAxis());
        chart.getPlugins().add((Object)new DataPointTooltip());
        chart.getPlugins().add((Object)new TableViewer());
        HBox headerBar = this.getHeaderBar(chart);
        Label sampleIndicator = new Label();
        sampleIndicator.setText(String.valueOf(this.nSamples));
        Label actualSampleIndicator = new Label();
        Slider nSampleSlider = new Slider(10.0, 10000.0, (double)this.nSamples);
        nSampleSlider.setShowTickMarks(true);
        nSampleSlider.setMajorTickUnit(200.0);
        nSampleSlider.setMinorTickCount(20);
        nSampleSlider.setBlockIncrement(1.0);
        HBox.setHgrow((Node)nSampleSlider, (Priority)Priority.ALWAYS);
        nSampleSlider.valueProperty().addListener((ch, old, n) -> {
            this.nSamples = n.intValue();
            sampleIndicator.setText(String.valueOf(this.nSamples));
            this.generateData(chart);
        });
        HBox hBoxSlider = new HBox(new Node[]{new Label("Number of Samples:"), nSampleSlider, sampleIndicator, actualSampleIndicator});
        root.setTop((Node)new VBox(new Node[]{headerBar, hBoxSlider}));
        Button newDataSet = new Button("new DataSet");
        newDataSet.setOnAction(evt -> Platform.runLater((Runnable)this.getTimerTask(chart)));
        Button startTimer = new Button(START_TIMER);
        startTimer.setOnAction(evt -> {
            if (this.timer == null) {
                startTimer.setText(STOP_TIMER);
                this.timer = new Timer(true);
                this.timer.scheduleAtFixedRate(this.getTimerTask(chart), 1000L, 100L);
            } else {
                startTimer.setText(START_TIMER);
                this.timer.cancel();
                this.timer = null;
            }
        });
        ComboBox dataSetTypeSelector = new ComboBox();
        dataSetTypeSelector.getItems().addAll((Object[])DataSetType.values());
        dataSetTypeSelector.setValue((Object)this.dataSetType);
        dataSetTypeSelector.valueProperty().addListener((ch, old, selection) -> {
            this.dataSetType = selection;
            this.generateData(chart);
        });
        TabPane tabPane = new TabPane();
        tabPane.getTabs().add((Object)this.getRendererTab(chart, errorRenderer));
        tabPane.getTabs().add((Object)this.getAxisTab("x-Axis", chart, xAxis));
        tabPane.getTabs().add((Object)this.getAxisTab("y-Axis", chart, yAxis));
        tabPane.getTabs().add((Object)this.getChartTab(chart));
        root.setLeft((Node)tabPane);
        this.generateData(chart);
        long startTime = ProcessingProfiler.getTimeStamp();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data to chart");
        startTime = ProcessingProfiler.getTimeStamp();
        root.setCenter((Node)chart);
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding chart into StackPane");
        startTime = ProcessingProfiler.getTimeStamp();
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.show();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"for showing");
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private static class ParameterTab
    extends Tab {
        private final GridPane parameterGrid = new GridPane();
        private int rowIndex;

        public ParameterTab(String tabName) {
            super(tabName);
            this.setContent((Node)this.parameterGrid);
        }

        public void addToParameterPane(String label, Node node) {
            this.parameterGrid.add((Node)new Label(label), 0, this.rowIndex);
            if (node != null) {
                this.parameterGrid.add(node, 1, this.rowIndex);
            }
            ++this.rowIndex;
        }
    }

    public static enum DataSetType {
        RANDOM_WALK,
        OUTLIER,
        STEP,
        SINC,
        GAUSS,
        SINE,
        COSINE,
        MIX_TRIGONOMETRIC;

    }
}

