/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.acc.ui.samples;

import de.gsi.acc.ui.samples.AcqButtonTests;
import de.gsi.chart.utils.PeriodicScreenCapture;
import java.nio.file.Path;
import java.nio.file.Paths;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunUiSamples
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunUiSamples.class);
    private static final int DEFAULT_DELAY = 2;
    private static final int DEFAULT_PERIOD = 5;
    private final String userHome = System.getProperty("user.home");
    private final Path path = Paths.get(this.userHome + "/ChartMathSamples", new String[0]);
    Stage stage = new Stage();
    CheckBox makeScreenShot = new CheckBox("make screenshot to home directory");

    public void start(Stage primaryStage) {
        BorderPane root = new BorderPane();
        FlowPane buttons = new FlowPane();
        buttons.setAlignment(Pos.CENTER_LEFT);
        root.setCenter((Node)buttons);
        root.setBottom((Node)this.makeScreenShot);
        buttons.getChildren().add((Object)new MyButton("AcqButtonTests", new AcqButtonTests()));
        Scene scene = new Scene((Parent)root);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> System.exit(0));
        primaryStage.show();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    protected class MyButton
    extends Button {
        public MyButton(String buttonText, Application run) {
            super(buttonText);
            this.setOnAction(e -> {
                block3: {
                    try {
                        run.start(RunUiSamples.this.stage);
                        RunUiSamples.this.stage.getScene().getRoot().layout();
                        RunUiSamples.this.stage.show();
                        if (RunUiSamples.this.makeScreenShot.isSelected()) {
                            new Thread(() -> {
                                block2: {
                                    try {
                                        Thread.sleep(2000L);
                                        Platform.runLater(() -> {
                                            LOGGER.atInfo().log("make screen shot to file of " + run.getClass().getSimpleName());
                                            PeriodicScreenCapture screenCapture = new PeriodicScreenCapture(RunUiSamples.this.path, run.getClass().getSimpleName(), RunUiSamples.this.stage.getScene(), 2.0, 5.0, false);
                                            screenCapture.performScreenCapture();
                                        });
                                    }
                                    catch (InterruptedException e12) {
                                        if (!LOGGER.isErrorEnabled()) break block2;
                                        LOGGER.atError().setCause((Throwable)e12).log("InterruptedException");
                                    }
                                }
                            }).start();
                        }
                    }
                    catch (Exception e1) {
                        if (!LOGGER.isErrorEnabled()) break block3;
                        LOGGER.atError().setCause((Throwable)e1).log("InterruptedException");
                    }
                }
            });
        }
    }
}

