/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.samples;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.AbstractAxisParameter;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.UpdateAxisLabels;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.spi.ContourDataSetRenderer;
import de.gsi.chart.renderer.spi.MetaDataRenderer;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.chart.utils.AxisSynchronizer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.GridDataSet;
import de.gsi.dataset.spi.AbstractGridDataSet;
import de.gsi.dataset.spi.DataSetBuilder;
import de.gsi.dataset.spi.DoubleGridDataSet;
import de.gsi.dataset.spi.MultiDimDoubleDataSet;
import de.gsi.dataset.spi.TransposedDataSet;
import de.gsi.math.samples.utils.AbstractDemoApplication;
import de.gsi.math.spectra.Apodization;
import de.gsi.math.spectra.ShortTimeFourierTransform;
import de.gsi.math.spectra.wavelet.ContinuousWavelet;
import java.util.Random;
import javafx.application.Application;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortTimeFourierTransformSample
extends AbstractDemoApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShortTimeFourierTransformSample.class);
    protected XYChart chart1;
    protected XYChart chart2;
    protected XYChart chart3;
    private final Spinner<Integer> nSamples = new Spinner((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 10000, 4000, 500));
    private final Spinner<Double> sampleRate = new Spinner((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 1000000.0, 1000000.0, 100000.0));
    private final Spinner<Double> toneFreq = new Spinner((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 1000000.0, 50000.0, 1000.0));
    private final Spinner<Double> toneAmplitude = new Spinner((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 10.0, 1.0, 0.5));
    private final Spinner<Double> toneStart = new Spinner((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 100.0, 0.1, 0.1));
    private final Spinner<Double> toneStop = new Spinner((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 100.0, 0.9, 0.1));
    private final Spinner<Integer> nFFT = new Spinner((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 10000, 128, 32));
    private final Spinner<Integer> step = new Spinner((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 10000, 10, 10));
    private final ComboBox<Apodization> apodizationWindow = new ComboBox(FXCollections.observableArrayList((Object[])Apodization.values()));
    private final ComboBox<ShortTimeFourierTransform.Padding> padding = new ComboBox(FXCollections.observableArrayList((Object[])ShortTimeFourierTransform.Padding.values()));
    private final CheckBox dbScale = new CheckBox("dB Scale");
    private final CheckBox truncDCNyq = new CheckBox("truncate DC and Nyquist");
    private final CheckBox complex = new CheckBox("complex FFT");
    private final Spinner<Double> nu = new Spinner((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 200.0, 30.0, 10.0));
    private final Spinner<Double> waveletFMin = new Spinner((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 0.5, 0.0, 0.05));
    private final Spinner<Double> waveletFMax = new Spinner((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 0.5, 0.5, 0.05));
    private final Spinner<Integer> quantx = new Spinner((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 10000, 512, 32));
    private final Spinner<Integer> quanty = new Spinner((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 10000, 128, 32));
    private final MultiDimDoubleDataSet rawData = new MultiDimDoubleDataSet("rawTimeData", 3);
    private final DoubleGridDataSet stftData = (DoubleGridDataSet)new DataSetBuilder("ShortTimeFourierTransform").setDimension(3).setInitalCapacity(new int[]{0}).build(DoubleGridDataSet.class);
    private final DoubleGridDataSet waveletData = (DoubleGridDataSet)new DataSetBuilder("WaveletTransform").setDimension(3).setInitalCapacity(new int[]{0}).build(DoubleGridDataSet.class);

    public ShortTimeFourierTransformSample() {
        super(1200.0, 800.0);
    }

    @Override
    public Node getContent() {
        this.chart3 = new XYChart();
        this.chart3.getXAxis().setAutoUnitScaling(true);
        this.chart3.getPlugins().add((Object)new UpdateAxisLabels());
        this.chart3.getPlugins().add((Object)new Zoomer());
        this.chart3.getPlugins().add((Object)new EditAxis());
        this.chart3.getRenderers().add((Object)new MetaDataRenderer((Chart)this.chart3));
        this.chart3.getDatasets().add((Object)this.rawData);
        this.rawData.addListener(evt -> this.stft((DataSet)this.rawData, this.stftData));
        this.chart1 = new XYChart();
        ContourDataSetRenderer contourChartRenderer1 = new ContourDataSetRenderer();
        this.chart1.getRenderers().set(0, (Object)contourChartRenderer1);
        this.chart1.getRenderers().add((Object)new MetaDataRenderer((Chart)this.chart1));
        DefaultNumericAxis xAxis1 = new DefaultNumericAxis();
        xAxis1.setAutoUnitScaling(true);
        xAxis1.setSide(Side.BOTTOM);
        xAxis1.setDimIndex(0);
        DefaultNumericAxis yAxis1 = new DefaultNumericAxis();
        yAxis1.setSide(Side.LEFT);
        yAxis1.setDimIndex(1);
        contourChartRenderer1.getAxes().addAll((Object[])new Axis[]{xAxis1, yAxis1});
        Axis zAxis1 = contourChartRenderer1.getZAxis();
        zAxis1.setName("Amplitude");
        zAxis1.setUnit("dB");
        ((AbstractAxisParameter)zAxis1).setDimIndex(2);
        this.chart1.getAxes().addAll((Object[])new Axis[]{xAxis1, yAxis1, zAxis1});
        this.chart1.getPlugins().add((Object)new UpdateAxisLabels());
        this.chart1.getPlugins().add((Object)new Zoomer());
        this.chart1.getPlugins().add((Object)new EditAxis());
        this.chart1.getDatasets().add((Object)TransposedDataSet.transpose((DataSet)this.stftData, (boolean)true));
        this.rawData.addListener(evt -> this.wavelet((DataSet)this.rawData, this.waveletData));
        this.chart2 = new XYChart();
        ContourDataSetRenderer contourChartRenderer2 = new ContourDataSetRenderer();
        this.chart2.getRenderers().set(0, (Object)contourChartRenderer2);
        DefaultNumericAxis xAxis2 = new DefaultNumericAxis();
        xAxis2.setAutoUnitScaling(true);
        xAxis2.setSide(Side.BOTTOM);
        xAxis2.setDimIndex(0);
        DefaultNumericAxis yAxis2 = new DefaultNumericAxis();
        yAxis2.setSide(Side.LEFT);
        yAxis2.setDimIndex(1);
        contourChartRenderer2.getAxes().addAll((Object[])new Axis[]{xAxis2, yAxis2});
        Axis zAxis2 = contourChartRenderer2.getZAxis();
        zAxis2.setName("Amplitude");
        zAxis2.setUnit("dB");
        ((AbstractAxisParameter)zAxis2).setDimIndex(2);
        this.chart2.getAxes().addAll((Object[])new Axis[]{xAxis2, yAxis2, zAxis2});
        this.chart2.getRenderers().add((Object)new MetaDataRenderer((Chart)this.chart2));
        this.chart2.getPlugins().add((Object)new UpdateAxisLabels());
        this.chart2.getPlugins().add((Object)new Zoomer());
        this.chart2.getPlugins().add((Object)new EditAxis());
        this.chart2.getDatasets().add((Object)this.waveletData);
        AxisSynchronizer synTime = new AxisSynchronizer();
        synTime.add((Axis)xAxis1);
        synTime.add((Axis)xAxis2);
        synTime.add(this.chart3.getXAxis());
        AxisSynchronizer synFreq = new AxisSynchronizer();
        synFreq.add((Axis)yAxis1);
        synFreq.add((Axis)yAxis2);
        VBox content = new VBox(5.0, new Node[]{this.chart3, new HBox(5.0, new Node[]{this.chart1, this.chart2}), new HBox(20.0, new Node[]{this.rawDataSettingsPane(), this.stftSettingsPane(), this.waveletSettingsPane()})});
        HBox.setHgrow((Node)this.chart1, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.chart2, (Priority)Priority.ALWAYS);
        this.updateRawData(this.rawData);
        this.stft((DataSet)this.rawData, this.stftData);
        this.wavelet((DataSet)this.rawData, this.waveletData);
        return content;
    }

    private Node rawDataSettingsPane() {
        GridPane gridPane = new GridPane();
        gridPane.setVgap(5.0);
        gridPane.setHgap(3.0);
        gridPane.addRow(0, new Node[]{new Label("nSamples"), this.nSamples, new Label("[samples]")});
        this.nSamples.setEditable(true);
        gridPane.addRow(1, new Node[]{new Label("sampleRate"), this.sampleRate, new Label("[samples/s]")});
        this.sampleRate.setEditable(true);
        gridPane.addRow(2, new Node[]{new Label("ToneFreq"), this.toneFreq, new Label("[Hz]")});
        this.toneFreq.setEditable(true);
        gridPane.addRow(3, new Node[]{new Label("ToneAmplitude"), this.toneAmplitude, new Label("[a.u.]")});
        this.toneAmplitude.setEditable(true);
        gridPane.addRow(4, new Node[]{new Label("ToneStart"), this.toneStart, new Label("[s]")});
        this.toneStart.setEditable(true);
        gridPane.addRow(5, new Node[]{new Label("ToneStop"), this.toneStop, new Label("[s]")});
        this.toneStop.setEditable(true);
        ShortTimeFourierTransformSample.installEventHandlers(evt -> this.updateRawData(this.rawData), new ObservableValue[]{this.nSamples.valueProperty(), this.sampleRate.valueProperty(), this.toneFreq.valueProperty(), this.toneAmplitude.valueProperty(), this.toneStart.valueProperty(), this.toneStop.valueProperty()});
        return gridPane;
    }

    private void stft(DataSet inputData, DoubleGridDataSet outputData) {
        try {
            DoubleGridDataSet newData = this.complex.isSelected() ? (DoubleGridDataSet)ShortTimeFourierTransform.complex((DataSet)inputData, (GridDataSet)outputData, (int)((Integer)this.nFFT.getValue()), (int)((Integer)this.step.getValue()), (Apodization)((Apodization)this.apodizationWindow.getValue()), (ShortTimeFourierTransform.Padding)((ShortTimeFourierTransform.Padding)this.padding.getValue()), (boolean)this.dbScale.isSelected(), (boolean)this.truncDCNyq.isSelected()) : (DoubleGridDataSet)ShortTimeFourierTransform.real((DataSet)inputData, (GridDataSet)outputData, (int)((Integer)this.nFFT.getValue()), (int)((Integer)this.step.getValue()), (Apodization)((Apodization)this.apodizationWindow.getValue()), (ShortTimeFourierTransform.Padding)((ShortTimeFourierTransform.Padding)this.padding.getValue()), (boolean)this.dbScale.isSelected(), (boolean)this.truncDCNyq.isSelected());
            if (newData != outputData) {
                outputData.set((DataSet)newData);
                outputData.getAxisDescription(0).set(newData.getAxisDescription(0));
                outputData.getAxisDescription(1).set(newData.getAxisDescription(1));
                outputData.getAxisDescription(2).set(newData.getAxisDescription(2));
            }
        }
        catch (Exception e) {
            LOGGER.atError().setCause((Throwable)e).log("Error during ShortTimeFourierTransform");
            outputData.clearData();
            ((AbstractGridDataSet)outputData.clearMetaInfo()).getErrorList().add(e.getMessage());
        }
        outputData.invokeListener();
    }

    private Node stftSettingsPane() {
        GridPane gridPane = new GridPane();
        gridPane.setVgap(5.0);
        gridPane.setHgap(3.0);
        gridPane.addRow(0, new Node[]{new Label("n_FFT"), this.nFFT, new Label("[samples]")});
        this.nFFT.setEditable(true);
        gridPane.addRow(1, new Node[]{new Label("step"), this.step, new Label("[samples]")});
        this.step.setEditable(true);
        this.apodizationWindow.setValue((Object)Apodization.Hann);
        gridPane.addRow(2, new Node[]{new Label("window function"), this.apodizationWindow, new Label("")});
        this.padding.setValue((Object)ShortTimeFourierTransform.Padding.ZERO);
        gridPane.addRow(3, new Node[]{new Label("Padding"), this.padding, new Label("")});
        this.dbScale.setSelected(true);
        gridPane.add((Node)this.dbScale, 0, 4, 3, 1);
        this.truncDCNyq.setSelected(true);
        gridPane.add((Node)this.truncDCNyq, 0, 5, 3, 1);
        this.complex.setSelected(false);
        gridPane.add((Node)this.complex, 0, 6, 3, 1);
        ShortTimeFourierTransformSample.installEventHandlers(evt -> this.stft((DataSet)this.rawData, this.stftData), new ObservableValue[]{this.nFFT.valueProperty(), this.step.valueProperty(), this.apodizationWindow.valueProperty(), this.padding.valueProperty(), this.dbScale.selectedProperty(), this.truncDCNyq.selectedProperty(), this.complex.selectedProperty()});
        return gridPane;
    }

    private void updateRawData(MultiDimDoubleDataSet dataSetToUpdate) {
        int maxPoints = (Integer)this.nSamples.getValue();
        double rate = (Double)this.sampleRate.getValue();
        double[] yModel = new double[maxPoints];
        double[] imModel = new double[maxPoints];
        Random rnd = new Random();
        for (int i = 0; i < yModel.length; ++i) {
            double x = (double)(i * 1) / rate;
            double offset = 0.0;
            double error = 0.1 * rnd.nextGaussian();
            offset = (double)i > 0.5 * (double)maxPoints ? -20000.0 : 0.0;
            yModel[i] = (double)i > 0.2 * (double)maxPoints && (double)i < 0.9 * (double)maxPoints ? 0.7 * Math.sin(188495.5592153876 * x * (2000.0 * x + offset)) : 0.0;
            int n = i;
            yModel[n] = yModel[n] + ((double)i > (Double)this.toneStart.getValue() * (double)maxPoints && (double)i < (Double)this.toneStop.getValue() * (double)maxPoints ? (Double)this.toneAmplitude.getValue() * Math.sin(Math.PI * 2 * (Double)this.toneFreq.getValue() * x) : 0.0);
            double mod = Math.cos(62831.853071795864 * x);
            int n2 = i;
            yModel[n2] = yModel[n2] + ((double)i > 0.3 * (double)maxPoints && (double)i < 0.9 * (double)maxPoints ? 1.0 * Math.sin(Math.PI * 2 * (0.4 - 5.0E-4 * mod) * 450000.0 * x) : 0.0);
            int n3 = i;
            yModel[n3] = yModel[n3] + 0.5 * Math.sin(Math.PI * 2 * ((0.1 + 5000.0 * x * x) * 1000000.0 * x));
            yModel[i] = yModel[i] + error;
        }
        double[] tValues = new double[yModel.length];
        for (int i = 0; i < tValues.length; ++i) {
            tValues[i] = (double)(i * 1) / rate;
        }
        dataSetToUpdate.set((double[][])new double[][]{tValues, yModel, imModel});
        dataSetToUpdate.getAxisDescription(0).set("time", new String[]{"s"});
        dataSetToUpdate.getAxisDescription(1).set("amplitude", new String[]{"V"});
    }

    private void wavelet(DataSet inputData, DoubleGridDataSet outputData) {
        try {
            outputData.getErrorList().clear();
            ContinuousWavelet wtrafo = new ContinuousWavelet();
            GridDataSet newData = wtrafo.getScalogram(inputData.getValues(1), ((Integer)this.quantx.getValue()).intValue(), ((Integer)this.quanty.getValue()).intValue(), ((Double)this.nu.getValue()).doubleValue(), ((Double)this.waveletFMin.getValue()).doubleValue(), ((Double)this.waveletFMax.getValue()).doubleValue());
            outputData.set((DataSet)newData);
            outputData.getAxisDescription(0).set(inputData.getAxisDescription(0).getName(), new String[]{inputData.getAxisDescription(0).getUnit()});
            outputData.getAxisDescription(1).set("frequency", new String[]{"Hz"});
            outputData.getAxisDescription(2).set("Amplitude", new String[]{inputData.getAxisDescription(1).getUnit()});
            double[] yValues = newData.getGridValues(1);
            double fs = (Double)this.sampleRate.getValue();
            int i = 0;
            while (i < yValues.length) {
                int n = i++;
                yValues[n] = yValues[n] * fs;
            }
            double[] xValues = newData.getGridValues(0);
            double dt = 1.0 / fs;
            int i2 = 0;
            while (i2 < xValues.length) {
                int n = i2++;
                xValues[n] = xValues[n] * dt;
            }
            outputData.recomputeLimits(0);
            outputData.recomputeLimits(1);
            outputData.recomputeLimits(2);
        }
        catch (Exception e) {
            outputData.getErrorList().add(e.getMessage());
        }
        outputData.invokeListener();
    }

    private Node waveletSettingsPane() {
        GridPane gridPane = new GridPane();
        gridPane.setVgap(5.0);
        gridPane.setHgap(3.0);
        gridPane.addRow(0, new Node[]{new Label("nu"), this.nu, new Label("[oscillations]")});
        this.nu.setEditable(true);
        gridPane.addRow(1, new Node[]{new Label("fMin"), this.waveletFMin, new Label("[fs]")});
        this.waveletFMin.setEditable(true);
        gridPane.addRow(2, new Node[]{new Label("fMax"), this.waveletFMax, new Label("[fs]")});
        this.waveletFMax.setEditable(true);
        gridPane.addRow(3, new Node[]{new Label("quantX"), this.quantx, new Label("samples")});
        this.quantx.setEditable(true);
        gridPane.addRow(4, new Node[]{new Label("quantY"), this.quanty, new Label("[samples]")});
        this.quanty.setEditable(true);
        ShortTimeFourierTransformSample.installEventHandlers(evt -> this.wavelet((DataSet)this.rawData, this.waveletData), new ObservableValue[]{this.nu.valueProperty(), this.waveletFMin.valueProperty(), this.waveletFMax.valueProperty(), this.quantx.valueProperty(), this.quanty.valueProperty()});
        return gridPane;
    }

    private static void installEventHandlers(InvalidationListener listener, ObservableValue<?> ... props) {
        for (ObservableValue<?> prop : props) {
            prop.addListener(listener);
        }
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

