/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples.legacy;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Panner;
import de.gsi.chart.plugins.TableViewer;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.samples.legacy.utils.AbstractTestApplication;
import de.gsi.chart.samples.legacy.utils.ChartTestCase;
import de.gsi.chart.samples.legacy.utils.JavaFXTestChart;
import de.gsi.chart.samples.legacy.utils.TestChart;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DoubleDataSet;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartPerformanceBenchmark
extends AbstractTestApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChartPerformanceBenchmark.class);
    private static final int WAIT_PERIOD = 60000;
    private final int[] testSamples25Hz = new int[]{1000, 10, 10, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 200, 300, 400, 500, 600, 700, 800, 900, 1000, 1500, 2000, 2500, 3000, 3500, 4000, 4500, 5000, 5500, 6000, 6500, 7000, 7500, 8000, 8500, 9000, 9500, 10000, 15000, 20000, 25000, 30000, 35000, 40000, 45000, 50000, 55000, 60000, 65000, 70000, 75000, 80000, 85000, 90000, 95000, 100000, 200000, 300000, 400000, 500000, 600000, 700000, 800000, 900000, 1000000, 2000000, 3000000, 4000000, 5000000, 6000000, 7000000, 8000000, 90000000};
    private final int[] testSamples1Hz = new int[]{1000, 100, 100, 100, 500, 1000, 2000, 3000, 4000, 5000, 10000, 20000, 30000, 40000, 50000, 100000, 200000, 300000, 400000, 500000, 600000, 700000, 800000, 900000, 1000000, 2000000, 3000000, 4000000, 5000000, 6000000, 7000000, 8000000, 9000000, 10000000};
    private final BorderPane root = new BorderPane();
    private final int nSamples = 100;
    private final ChartTestCase chartTestCase1 = new JavaFXTestChart();
    private final ChartTestCase chartTestCase2 = new TestChart();
    private final ChartTestCase chartTestCase3 = new TestChart(true);
    private final Node chart1 = this.chartTestCase1.getChart(100);
    private final Node chart2 = this.chartTestCase2.getChart(100);
    private final Node chart3 = this.chartTestCase3.getChart(100);
    private final DoubleDataSet results1 = new DoubleDataSet("JavaFX Chart");
    private final DoubleDataSet results2 = new DoubleDataSet("ChartFx (ErrorDataSetRenderer)");
    private final DoubleDataSet results3 = new DoubleDataSet("ChartFx (ReducingLineRenderer)");
    private final boolean[] compute = new boolean[]{true, true, true};
    private Thread timer;

    public XYChart getResultChart() {
        DefaultNumericAxis xAxis = new DefaultNumericAxis();
        xAxis.setName("number of samples");
        xAxis.setForceZeroInRange(true);
        xAxis.setAutoRangeRounding(true);
        xAxis.setAutoRangePadding(0.05);
        xAxis.setLogAxis(true);
        DefaultNumericAxis yAxis1 = new DefaultNumericAxis();
        yAxis1.setName("CPU load");
        yAxis1.setUnit("%");
        yAxis1.setForceZeroInRange(true);
        yAxis1.setAutoRangeRounding(true);
        yAxis1.setAutoRangeRounding(true);
        yAxis1.setAutoRangePadding(0.05);
        XYChart chart = new XYChart(new Axis[]{xAxis, yAxis1});
        chart.legendVisibleProperty().set(true);
        chart.setAnimated(false);
        chart.setLegendVisible(true);
        xAxis.setAutoRangeRounding(false);
        ErrorDataSetRenderer renderer = (ErrorDataSetRenderer)chart.getRenderers().get(0);
        renderer.getDatasets().addAll((Object[])new DataSet[]{this.results1, this.results2, this.results3});
        chart.setPrefHeight(800.0);
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new Panner());
        chart.getPlugins().add((Object)new EditAxis());
        chart.getPlugins().add((Object)new TableViewer());
        return chart;
    }

    private void init(Stage primaryStage) {
        Stage subStage = new Stage();
        Scene scene = new Scene((Parent)this.root, 1800.0, 400.0);
        test = this.chartTestCase2;
        this.root.setCenter(this.chart2);
        subStage.setScene(scene);
        subStage.setOnCloseRequest(evt -> Platform.exit());
        subStage.show();
        HBox headerBar = this.getHeaderBar(scene);
        headerBar.getChildren().add(2, (Object)new VBox(new Node[]{this.startTestButton("Series@25Hz", this.testSamples25Hz, 40L), this.startTestButton("Series@2Hz", this.testSamples1Hz, 500L)}));
        headerBar.getChildren().add(3, (Object)this.switchToTestCase("A", this.chartTestCase1, this.chart1));
        headerBar.getChildren().add(4, (Object)this.switchToTestCase("B", this.chartTestCase2, this.chart2));
        headerBar.getChildren().add(5, (Object)this.switchToTestCase("C", this.chartTestCase3, this.chart3));
        primaryStage.setScene(new Scene((Parent)new VBox(new Node[]{headerBar, this.getResultChart()}), 800.0, 600.0));
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
    }

    @Override
    protected void initChart() {
    }

    @Override
    public void start(Stage stage) {
        stage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        this.init(stage);
        stage.show();
    }

    private Button startTestButton(String label, final int[] nSamplesTest, final long updatePeriod) {
        Button startTimer = new Button(label);
        startTimer.setTooltip(new Tooltip("start test series iterating through each chart implementation"));
        startTimer.setMaxWidth(Double.MAX_VALUE);
        startTimer.setOnAction(evt -> {
            if (this.timer == null) {
                this.timer = new Thread(){

                    @Override
                    public void run() {
                        block7: {
                            try {
                                for (int i = 0; i < nSamplesTest.length; ++i) {
                                    int samples = nSamplesTest[i];
                                    int wait = i == 0 ? 120000 : 60000;
                                    LOGGER.atInfo().log("start test iteration for: " + samples + " samples");
                                    if (samples > 10000) {
                                        ChartPerformanceBenchmark.this.compute[0] = false;
                                    }
                                    TestThread t1 = new TestThread(1, ChartPerformanceBenchmark.this.compute[0] ? samples : 1000, ChartPerformanceBenchmark.this.chart1, ChartPerformanceBenchmark.this.chartTestCase1, ChartPerformanceBenchmark.this.results1, updatePeriod, wait);
                                    TestThread t2 = new TestThread(2, ChartPerformanceBenchmark.this.compute[1] ? samples : 1000, ChartPerformanceBenchmark.this.chart2, ChartPerformanceBenchmark.this.chartTestCase2, ChartPerformanceBenchmark.this.results2, updatePeriod, wait);
                                    TestThread t3 = new TestThread(3, ChartPerformanceBenchmark.this.compute[2] ? samples : 1000, ChartPerformanceBenchmark.this.chart3, ChartPerformanceBenchmark.this.chartTestCase3, ChartPerformanceBenchmark.this.results3, updatePeriod, wait);
                                    ChartPerformanceBenchmark.this.meter.resetAverages();
                                    if (ChartPerformanceBenchmark.this.compute[0]) {
                                        t1.start();
                                        t1.join();
                                    }
                                    if (ChartPerformanceBenchmark.this.compute[1]) {
                                        t2.start();
                                        t2.join();
                                    }
                                    if (ChartPerformanceBenchmark.this.compute[2]) {
                                        t3.start();
                                        t3.join();
                                    }
                                    if (i > 2) continue;
                                    ChartPerformanceBenchmark.this.compute[0] = true;
                                    ChartPerformanceBenchmark.this.compute[1] = true;
                                    ChartPerformanceBenchmark.this.compute[2] = true;
                                    ChartPerformanceBenchmark.this.results1.clearData();
                                    ChartPerformanceBenchmark.this.results2.clearData();
                                    ChartPerformanceBenchmark.this.results3.clearData();
                                }
                            }
                            catch (InterruptedException e) {
                                if (!LOGGER.isErrorEnabled()) break block7;
                                LOGGER.atError().setCause((Throwable)e).log("InterruptedException");
                            }
                        }
                    }
                };
                this.timer.start();
                LOGGER.atInfo().log("reset FPS averages");
                this.meter.resetAverages();
            } else {
                this.timer.interrupt();
                this.timer = null;
            }
        });
        return startTimer;
    }

    private Button switchToTestCase(String label, ChartTestCase testCase, Node chart) {
        Button button = new Button(label);
        button.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        button.setMaxHeight(Double.MAX_VALUE);
        VBox.setVgrow((Node)button, (Priority)Priority.ALWAYS);
        button.setOnAction(evt -> {
            if (this.timer != null) {
                this.timer.interrupt();
                this.timer = null;
            }
            test = testCase;
            this.root.setCenter(chart);
            test.updateDataSet();
            LOGGER.atInfo().log("reset FPS averages");
            this.meter.resetAverages();
        });
        return button;
    }

    public static void main(String[] args) {
        ChartPerformanceBenchmark.launch((String[])args);
    }

    private class TestThread
    extends Thread {
        private final int caseNr;
        private final int nSamples;
        private final Node chart;
        private final ChartTestCase testCase;
        private final DoubleDataSet result;
        private final long updatePeriod;
        private final long waitPeriod;
        private Timer timer;

        TestThread(int caseNr, int nSamples, Node chart, ChartTestCase testCase, DoubleDataSet result, long updatePeriod, long waitPeriod) {
            this.caseNr = caseNr;
            this.nSamples = nSamples;
            this.chart = chart;
            this.testCase = testCase;
            this.result = result;
            this.updatePeriod = updatePeriod;
            this.waitPeriod = waitPeriod;
        }

        @Override
        public void interrupt() {
            this.timer.cancel();
            super.interrupt();
        }

        @Override
        public void run() {
            block5: {
                Platform.runLater(() -> {
                    this.testCase.setNumberOfSamples(this.nSamples);
                    ChartPerformanceBenchmark.this.root.setCenter(this.chart);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                });
                this.timer = new Timer("sample-update-timer", true);
                TimerTask updateTimerTask = new TimerTask(){

                    @Override
                    public void run() {
                        TestThread.this.testCase.updateDataSet();
                    }
                };
                this.timer.scheduleAtFixedRate(updateTimerTask, 0L, this.updatePeriod);
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        ChartPerformanceBenchmark.this.meter.resetAverages();
                    }
                }, (long)(1.5 * (double)this.waitPeriod));
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        double avgFPS = Math.min(ChartPerformanceBenchmark.this.meter.getAverageFrameRate(), 25.0);
                        double avgCPULoad = ChartPerformanceBenchmark.this.meter.getAverageProcessCpuLoad();
                        LOGGER.atInfo().log("finished test case #" + TestThread.this.caseNr + " and '" + TestThread.this.nSamples + "' samples and cpu load of " + avgCPULoad + " % and average fps = " + avgFPS);
                        if (avgFPS > 800.0 / (double)TestThread.this.updatePeriod) {
                            TestThread.this.result.add((double)TestThread.this.nSamples, Math.min(avgCPULoad, 400.0));
                        } else {
                            ChartPerformanceBenchmark.this.compute[TestThread.this.caseNr - 1] = false;
                        }
                        TestThread.this.timer.cancel();
                        TestThread.this.timer = null;
                        Platform.runLater(() -> TestThread.this.testCase.setNumberOfSamples(1000));
                    }
                }, 2L * this.waitPeriod);
                while (this.timer != null) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        if (!LOGGER.isErrorEnabled()) continue;
                        LOGGER.atError().setCause((Throwable)e).log("InterruptedException");
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    if (!LOGGER.isErrorEnabled()) break block5;
                    LOGGER.atError().setCause((Throwable)e).log("InterruptedException");
                }
            }
        }
    }
}

