/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.plugins.CrosshairIndicator;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.DoubleDataSet;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleChartSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleChartSample.class);
    private static final int N_SAMPLES = 100;

    public void start(Stage primaryStage) {
        DefaultNumericAxis yAxis = new DefaultNumericAxis();
        yAxis.setAutoRanging(true);
        yAxis.setAutoRangePadding(0.5);
        XYChart chart = new XYChart(new Axis[]{new DefaultNumericAxis(), yAxis});
        chart.getPlugins().addAll((Object[])new ChartPlugin[]{new Zoomer(), new CrosshairIndicator(), new EditAxis()});
        DoubleDataSet dataSet1 = new DoubleDataSet("data set #1");
        DoubleDataSet dataSet2 = new DoubleDataSet("data set #2");
        dataSet1.addListener(evt -> LOGGER.atInfo().log("dataSet1 - event: " + evt.toString()));
        dataSet2.addListener(evt -> LOGGER.atInfo().log("dataSet2 - event: " + evt.toString()));
        chart.getDatasets().addAll((Object[])new DataSet[]{dataSet1, dataSet2});
        double[] xValues = new double[100];
        double[] yValues1 = new double[100];
        dataSet2.autoNotification().set(false);
        for (int n = 0; n < 100; ++n) {
            double x = n;
            double y1 = Math.cos(Math.toRadians(10.0 * (double)n));
            double y2 = Math.sin(Math.toRadians(10.0 * (double)n));
            xValues[n] = x;
            yValues1[n] = y1;
            dataSet2.add((double)n, y2);
        }
        dataSet1.set(xValues, yValues1);
        dataSet2.autoNotification().set(true);
        dataSet2.invokeListener((UpdateEvent)new UpdatedDataEvent((EventSource)dataSet2, "manual update event"));
        Scene scene = new Scene((Parent)new StackPane(new Node[]{chart}), 800.0, 600.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

