/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.DataPointTooltip;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DoubleDataSet;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotANumberSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotANumberSample.class);
    private static final int N_SAMPLES = 120;

    public void start(Stage primaryStage) {
        LOGGER.atInfo().addArgument((Object)NotANumberSample.class.getSimpleName()).log("launching sample {}");
        XYChart chart = new XYChart(new Axis[]{new DefaultNumericAxis("x-axis"), new DefaultNumericAxis("y-axis")});
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new EditAxis());
        chart.getPlugins().add((Object)new DataPointTooltip());
        ErrorDataSetRenderer renderer = (ErrorDataSetRenderer)chart.getRenderers().get(0);
        renderer.setMarkerSize(3.0);
        renderer.setAllowNaNs(true);
        DoubleErrorDataSet dataSet1 = new DoubleErrorDataSet("data set #1");
        dataSet1.setStyle("strokeDashPattern= 25, 20, 5, 20;");
        DoubleDataSet dataSet2 = new DoubleDataSet("data set #2");
        dataSet2.setStyle("strokeDashPattern= 5, 5;");
        chart.getDatasets().addAll((Object[])new DataSet[]{dataSet1, dataSet2});
        dataSet1.lock().writeLockGuard(() -> (DoubleErrorDataSet)dataSet1.lock().writeLockGuard(() -> {
            for (int n = 0; n < 120; ++n) {
                double x = 0.1 * (double)n;
                boolean bogusValue1 = (int)x % 5 == 0;
                boolean bogusValue2 = ((int)x + 2) % 5 == 0;
                double y1 = bogusValue1 ? Double.NaN : Math.cos(Math.toRadians(10.0 * (double)n));
                double y2 = bogusValue2 ? Double.NaN : Math.sin(Math.toRadians(10.0 * (double)n));
                dataSet1.add(x, y1, 0.1, 0.1);
                dataSet2.add(x, y2);
            }
        }));
        Scene scene = new Scene((Parent)chart, 800.0, 600.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        LOGGER.atInfo().addArgument((Object)NotANumberSample.class.getSimpleName()).log("launching sample {} - done");
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

