/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.CategoryAxis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.ParameterMeasurements;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.LineStyle;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.renderer.spi.MetaDataRenderer;
import de.gsi.chart.utils.FXUtils;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.AbstractHistogram;
import de.gsi.dataset.spi.Histogram;
import de.gsi.dataset.testdata.spi.RandomDataGenerator;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class HistogramSample
extends Application {
    private static final int UPDATE_DELAY = 1000;
    private static final int UPDATE_PERIOD = 20;
    private static final int N_BINS = 30;
    private final double[] xBins = new double[]{0.0, 0.1, 0.2, 0.3, 1.0, 2.0, 3.0, 4.0, 5.0, 10.0, 15.0, 16.0, 17.0, 18.0, 19.0, 19.7, 19.8, 19.9, 20.0};
    private final Histogram dataSet1 = new Histogram("myHistogram1", 30, 0.0, 20.0, AbstractHistogram.HistogramOuterBounds.BINS_ALIGNED_WITH_BOUNDARY);
    private final Histogram dataSet2 = new Histogram("myHistogram2", 30, 0.0, 20.0, AbstractHistogram.HistogramOuterBounds.BINS_ALIGNED_WITH_BOUNDARY);
    private final Histogram dataSet3 = new Histogram("myHistogram3", this.xBins);
    private int counter;

    private void fillData() {
        ++this.counter;
        this.dataSet1.fill(RandomDataGenerator.nextGaussian() * 2.0 + 8.0);
        this.dataSet2.fill(RandomDataGenerator.nextGaussian() * 3.0 + 12.0);
        if (this.counter % 10 == 0) {
            this.dataSet3.fill(RandomDataGenerator.nextGaussian() * 3.0 + 10.0);
        }
        if (this.counter % 2000 == 0) {
            this.counter = 0;
            this.dataSet1.reset();
            this.dataSet2.reset();
            this.dataSet3.reset();
        }
    }

    private void fillDemoData() {
        double randomData = 0.0;
        for (int n = 0; n < 30; ++n) {
            double x = n;
            this.dataSet1.fill(x, randomData += RandomDataGenerator.random() - 0.5);
            this.dataSet1.addDataLabel(n, "SpecialCategory#" + n);
        }
    }

    public void start(Stage primaryStage) {
        StackPane root = new StackPane();
        CategoryAxis xAxis1 = new CategoryAxis("months");
        xAxis1.setTickLabelRotation(90.0);
        DefaultNumericAxis xAxis2 = new DefaultNumericAxis("x-Axis");
        xAxis2.setAutoRangeRounding(false);
        xAxis2.setAutoRanging(true);
        DefaultNumericAxis yAxis = new DefaultNumericAxis("y-Axis");
        yAxis.setAutoRangeRounding(true);
        yAxis.setAutoRangePadding(0.2);
        yAxis.setForceZeroInRange(true);
        final XYChart chart = new XYChart(new Axis[]{xAxis2, yAxis});
        chart.setAnimated(false);
        ErrorDataSetRenderer renderer1 = new ErrorDataSetRenderer();
        renderer1.getDatasets().addAll((Object[])new DataSet[]{this.dataSet2});
        renderer1.setPolyLineStyle(LineStyle.HISTOGRAM_FILLED);
        chart.getRenderers().set(0, (Object)renderer1);
        ErrorDataSetRenderer renderer2 = new ErrorDataSetRenderer();
        renderer2.getDatasets().addAll((Object[])new DataSet[]{this.dataSet1, this.dataSet3});
        this.dataSet1.setStyle("strokeColor=red; strokeWidth=3");
        renderer2.setPolyLineStyle(LineStyle.HISTOGRAM);
        renderer2.setErrorType(ErrorStyle.ERRORBARS);
        chart.getRenderers().add((Object)renderer2);
        MetaDataRenderer metaRenderer = new MetaDataRenderer((Chart)chart);
        metaRenderer.getDatasets().addAll((Object[])new DataSet[]{this.dataSet2, this.dataSet1});
        chart.getRenderers().add((Object)metaRenderer);
        chart.legendVisibleProperty().set(true);
        chart.getPlugins().add((Object)new ParameterMeasurements());
        chart.getPlugins().add((Object)new EditAxis());
        Zoomer zoomer = new Zoomer();
        zoomer.setSliderVisible(false);
        chart.getPlugins().add((Object)zoomer);
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        DateFormatSymbols dfs = new DateFormatSymbols(Locale.ENGLISH);
        ArrayList<String> categories = new ArrayList<String>(Arrays.asList(Arrays.copyOf(dfs.getShortMonths(), 12)));
        for (int i = categories.size(); i < 30; ++i) {
            categories.add("Month" + (i + 1));
        }
        xAxis1.setCategories(categories);
        root.getChildren().add((Object)chart);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.show();
        Timer timer = new Timer("sample-update-timer", true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                HistogramSample.this.fillData();
                FXUtils.runFX(() -> ((XYChart)chart).requestLayout());
            }
        }, 1000L, 20L);
        primaryStage.setOnCloseRequest(evt -> {
            timer.cancel();
            Platform.exit();
        });
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

