/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.ParameterMeasurements;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.LineStyle;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.HistogramRenderer;
import de.gsi.chart.renderer.spi.MetaDataRenderer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.AbstractHistogram;
import de.gsi.dataset.spi.Histogram;
import de.gsi.dataset.testdata.spi.RandomDataGenerator;
import de.gsi.math.DataSetMath;
import de.gsi.math.MathDataSet;
import java.util.ArrayDeque;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;

public class HistogramRendererSample
extends Application {
    private static final int UPDATE_DELAY = 1000;
    private static final int UPDATE_PERIOD = 40;
    private static final int N_BINS = 20;
    private final double[] xBins = new double[]{0.0, 0.1, 0.2, 0.3, 1.0, 2.0, 3.0, 4.0, 5.0, 10.0, 15.0, 16.0, 17.0, 18.0, 19.0, 19.7, 19.8, 19.9, 20.0};
    private final Histogram dataSet1 = new Histogram("Histo1", 21, 0.0, 20.0, AbstractHistogram.HistogramOuterBounds.BINS_CENTERED_ON_BOUNDARY);
    private final Histogram dataSet2 = new Histogram("Histo2", 21, 0.0, 20.0, AbstractHistogram.HistogramOuterBounds.BINS_CENTERED_ON_BOUNDARY);
    private final Histogram dataSet3 = new Histogram("Histo3", this.xBins);
    private int counter;

    private void fillData() {
        ++this.counter;
        this.dataSet1.fill(RandomDataGenerator.nextGaussian() * 3.0 + 8.0);
        this.dataSet2.fill(RandomDataGenerator.nextGaussian() * 2.0 + 14.0);
        if (this.counter % 10 == 0) {
            this.dataSet3.fill(RandomDataGenerator.nextGaussian() * 3.0 + 10.0);
        }
        if (this.counter % 2000 == 0) {
            this.counter = 0;
            this.dataSet1.reset();
            this.dataSet2.reset();
            this.dataSet3.reset();
        }
    }

    public void start(Stage primaryStage) {
        BorderPane root = new BorderPane();
        XYChart chart1 = new XYChart();
        chart1.setTitle("Basic Histograms");
        Zoomer zoomer = new Zoomer();
        zoomer.setAutoZoomEnabled(true);
        zoomer.setSliderVisible(false);
        chart1.getPlugins().addAll((Object[])new ChartPlugin[]{new ParameterMeasurements(), new EditAxis(), zoomer});
        HistogramRenderer renderer1 = new HistogramRenderer();
        renderer1.getDatasets().addAll((Object[])new DataSet[]{this.dataSet2});
        renderer1.setPolyLineStyle(LineStyle.HISTOGRAM_FILLED);
        chart1.getRenderers().set(0, (Object)renderer1);
        HistogramRenderer renderer2 = new HistogramRenderer();
        renderer2.getDatasets().addAll((Object[])new DataSet[]{this.dataSet1, this.dataSet3});
        this.dataSet1.setStyle("strokeColor=red; strokeWidth=3");
        this.dataSet3.setStyle("strokeColor=green; strokeWidth=3");
        renderer2.setPolyLineStyle(LineStyle.HISTOGRAM);
        chart1.getRenderers().add((Object)renderer2);
        MetaDataRenderer metaRenderer = new MetaDataRenderer((Chart)chart1);
        metaRenderer.getDatasets().addAll((Object[])new DataSet[]{this.dataSet2, this.dataSet1});
        chart1.getRenderers().add((Object)metaRenderer);
        XYChart chart2 = new XYChart();
        chart2.setTitle("Stacked Histograms");
        Zoomer zoomer2 = new Zoomer();
        zoomer2.setAutoZoomEnabled(true);
        zoomer2.setSliderVisible(false);
        chart2.getPlugins().addAll((Object[])new ChartPlugin[]{new ParameterMeasurements(), new EditAxis(), zoomer2});
        chart2.getRenderers().setAll((Object[])new Renderer[]{new HistogramRenderer()});
        SummingDataSet dataSetSum31 = new SummingDataSet("Sum", new DataSet[]{this.dataSet1, this.dataSet3});
        SummingDataSet dataSetSum312 = new SummingDataSet("Sum", new DataSet[]{this.dataSet1, this.dataSet2, this.dataSet3});
        chart2.getDatasets().addAll((Object[])new DataSet[]{dataSetSum312, dataSetSum31, this.dataSet3});
        HBox.setHgrow((Node)chart1, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)chart2, (Priority)Priority.ALWAYS);
        root.setCenter((Node)new HBox(new Node[]{chart1, chart2}));
        Scene scene = new Scene((Parent)root, 1200.0, 400.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.show();
        Timer timer = new Timer("sample-update-timer", true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                HistogramRendererSample.this.fillData();
            }
        }, 1000L, 40L);
        primaryStage.setOnCloseRequest(evt -> {
            timer.cancel();
            Platform.exit();
        });
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    public class SummingDataSet
    extends MathDataSet {
        public SummingDataSet(String name, DataSet ... functions) {
            super(name, (dataSets, returnFunction) -> {
                if (dataSets.isEmpty()) {
                    return;
                }
                ArrayDeque lockQueue = new ArrayDeque(dataSets.size());
                try {
                    dataSets.forEach(ds -> {
                        lockQueue.push(ds);
                        ds.lock().readLock();
                    });
                    returnFunction.clearData();
                    DataSet firstDataSet = (DataSet)dataSets.get(0);
                    returnFunction.add(firstDataSet.get(0, 0), 0.0);
                    returnFunction.add(firstDataSet.get(0, firstDataSet.getDataCount() - 1), 0.0);
                    dataSets.forEach(ds -> returnFunction.set(DataSetMath.addFunction((DataSet)returnFunction, (DataSet)ds), false));
                }
                finally {
                    while (!lockQueue.isEmpty()) {
                        ((DataSet)lockQueue.pop()).lock().readUnLock();
                    }
                }
            }, functions);
        }
    }
}

