/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.LineStyle;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.AbstractHistogram;
import de.gsi.dataset.spi.Histogram;
import de.gsi.math.Math;
import java.util.Arrays;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class HistogramBasicSample
extends Application {
    private Histogram dataSet1 = new Histogram("myHistogram1", 4, 0.0, 4.0, AbstractHistogram.HistogramOuterBounds.BINS_ALIGNED_WITH_BOUNDARY);

    public void start(Stage primaryStage) {
        XYChart chart = new XYChart();
        ErrorDataSetRenderer renderer1 = new ErrorDataSetRenderer();
        renderer1.setPolyLineStyle(LineStyle.HISTOGRAM_FILLED);
        chart.getRenderers().add((Object)renderer1);
        renderer1.getDatasets().addAll((Object[])new DataSet[]{this.dataSet1});
        chart.getPlugins().add((Object)new EditAxis());
        Zoomer zoomer = new Zoomer();
        zoomer.setSliderVisible(false);
        chart.getPlugins().add((Object)zoomer);
        VBox root = new VBox();
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        ToolBar addDataSet = new ToolBar();
        Slider nBinsSlider = new Slider(1.0, 25.0, 4.0);
        nBinsSlider.setMajorTickUnit(1.0);
        nBinsSlider.setSnapToTicks(true);
        nBinsSlider.setShowTickLabels(true);
        nBinsSlider.setShowTickMarks(true);
        Slider minSlider = new Slider(-10.0, 10.0, 0.0);
        minSlider.setShowTickLabels(true);
        minSlider.setShowTickMarks(true);
        Slider maxSlider = new Slider(-10.0, 10.0, 4.0);
        maxSlider.setShowTickLabels(true);
        maxSlider.setShowTickMarks(true);
        ComboBox histoBoundsCombo = new ComboBox(FXCollections.observableList(List.of(AbstractHistogram.HistogramOuterBounds.values())));
        histoBoundsCombo.setValue((Object)AbstractHistogram.HistogramOuterBounds.BINS_ALIGNED_WITH_BOUNDARY);
        Button newHistogramButton = new Button("New Histogram");
        newHistogramButton.setOnAction(e -> {
            this.dataSet1 = new Histogram("myHistogram1", (int)nBinsSlider.getValue(), minSlider.getValue(), maxSlider.getValue(), (AbstractHistogram.HistogramOuterBounds)histoBoundsCombo.getValue());
            for (int i = 0; i < this.dataSet1.getDataCount() + 2; ++i) {
                this.dataSet1.addBinContent(i, (double)this.dataSet1.getDataCount() + 2.0 - Math.abs((double)((double)i - 0.5 * (double)(this.dataSet1.getDataCount() + 2))));
            }
            renderer1.getDatasets().setAll((Object[])new DataSet[]{this.dataSet1});
        });
        addDataSet.getItems().addAll((Object[])new Node[]{new Label("nBins: "), nBinsSlider, new Label("min: "), minSlider, new Label("max: "), maxSlider, histoBoundsCombo, newHistogramButton});
        ToolBar addNeqDataSet = new ToolBar();
        TextField points = new TextField("0.0, 1.0, 2.0, 3.0, 4.0");
        Button newNeqHistogramButton = new Button("New non-equidistant Histogram");
        newNeqHistogramButton.setOnAction(e -> {
            this.dataSet1 = new Histogram("Non equidistant histogram", Arrays.stream(points.getText().split(",")).mapToDouble(v -> Double.parseDouble(v.trim())).toArray());
            for (int i = 0; i < this.dataSet1.getDataCount() + 2; ++i) {
                this.dataSet1.addBinContent(i, (double)this.dataSet1.getDataCount() + 2.0 - Math.abs((double)((double)i - 0.5 * (double)(this.dataSet1.getDataCount() + 2))));
            }
            renderer1.getDatasets().setAll((Object[])new DataSet[]{this.dataSet1});
        });
        addNeqDataSet.getItems().addAll((Object[])new Node[]{new Label("Bin boundaries: "), points, newNeqHistogramButton, new Label("NOTE: because the ErrorDataSetRenderer cannot obtain the widths of the bins, bin boundaries will be off")});
        ToolBar addDataBar = new ToolBar();
        ToggleGroup addDataToggleGroup = new ToggleGroup();
        RadioButton addDataValueRadio = new RadioButton("Add data to value: ");
        addDataValueRadio.setToggleGroup(addDataToggleGroup);
        addDataValueRadio.setSelected(true);
        Spinner valueToAddTo = new Spinner((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0, 0.1));
        valueToAddTo.setEditable(true);
        valueToAddTo.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)addDataValueRadio.selectedProperty()));
        RadioButton addDataBinRadio = new RadioButton("Add data to bin: ");
        addDataBinRadio.setToggleGroup(addDataToggleGroup);
        Spinner binToAddTo = new Spinner(0, Integer.MAX_VALUE, 2);
        binToAddTo.setEditable(true);
        binToAddTo.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)addDataBinRadio.selectedProperty()));
        Spinner valueToAdd = new Spinner((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0, 0.1));
        valueToAdd.setEditable(true);
        Button addDataBtn = new Button("add");
        addDataBtn.setOnAction(e -> {
            if (addDataValueRadio.isSelected()) {
                this.dataSet1.addBinContent(this.dataSet1.findBin(0, ((Double)valueToAddTo.getValue()).doubleValue()), ((Double)valueToAdd.getValue()).doubleValue());
            } else {
                this.dataSet1.addBinContent(((Integer)binToAddTo.getValue()).intValue(), ((Double)valueToAdd.getValue()).doubleValue());
            }
        });
        addDataBar.getItems().addAll((Object[])new Node[]{addDataValueRadio, valueToAddTo, addDataBinRadio, binToAddTo, new Label("Weight: "), valueToAdd, addDataBtn});
        root.getChildren().addAll((Object[])new Node[]{addDataSet, addNeqDataSet, addDataBar, chart});
        VBox.setVgrow((Node)chart, (Priority)Priority.ALWAYS);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

