/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.dataset.spi.FragmentedDataSet;
import de.gsi.dataset.testdata.spi.CosineFunction;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class CustomFragmentedRendererSample
extends Application {
    private static final int N_SAMPLES = 500;
    private static final int N_DATA_SETS_MAX = 3;

    public void start(Stage primaryStage) {
        XYChart chart = new XYChart(new Axis[]{new DefaultNumericAxis("x-Axis"), new DefaultNumericAxis("y-Axis")});
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new EditAxis());
        VBox.setVgrow((Node)chart, (Priority)Priority.ALWAYS);
        ErrorDataSetRenderer renderer = new ErrorDataSetRenderer(){

            public List<DataSet> render(GraphicsContext gc, Chart renderChart, int dataSetOffset, ObservableList<DataSet> datasets) {
                ObservableList filteredDataSets = FXCollections.observableArrayList();
                int dsIndex = 0;
                for (DataSet ds : datasets) {
                    if (ds instanceof FragmentedDataSet) {
                        FragmentedDataSet fragDataSet = (FragmentedDataSet)ds;
                        for (DataSet innerDataSet : fragDataSet.getDatasets()) {
                            innerDataSet.setStyle("dsIndex=" + dsIndex);
                            filteredDataSets.add((Object)innerDataSet);
                        }
                    } else {
                        ds.setStyle("dsIndex=" + dsIndex);
                        filteredDataSets.add((Object)ds);
                    }
                    ++dsIndex;
                }
                super.render(gc, renderChart, dataSetOffset, filteredDataSets);
                return filteredDataSets;
            }
        };
        chart.getRenderers().clear();
        chart.getRenderers().add((Object)renderer);
        FragmentedDataSet fragmentedDataSet = new FragmentedDataSet("FragmentedDataSet");
        for (int i = 0; i < 3; ++i) {
            DoubleErrorDataSet dataSet = new DoubleErrorDataSet("Set#" + i);
            for (int n = 0; n < 500; ++n) {
                dataSet.add((double)(n + i * 500), 0.5 * (double)i + Math.cos(Math.toRadians(1.0 * (double)n)), 0.15, 0.15);
            }
            fragmentedDataSet.add((DataSet)dataSet);
        }
        chart.getDatasets().addAll((Object[])new DataSet[]{fragmentedDataSet, new CosineFunction("Cosine", 1500)});
        Scene scene = new Scene((Parent)chart, 800.0, 600.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

