/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.ColormapSelector;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.ContourType;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.ContourDataSetRenderer;
import de.gsi.chart.renderer.spi.utils.ColorGradient;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DataSetBuilder;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContourChartSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContourChartSample.class);

    private static DataSet createData() {
        double[] x;
        double[] y = x = new double[]{-12.0, -9.0, -8.0, -7.0, -6.0, -5.0, -4.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 12.0};
        double[][] z = new double[x.length][y.length];
        for (int yIndex = 0; yIndex < y.length; ++yIndex) {
            for (int xIndex = 0; xIndex < x.length; ++xIndex) {
                z[xIndex][yIndex] = Math.sin(y[yIndex] * x[xIndex]);
            }
        }
        return new DataSetBuilder("demoDataSet").setValues(0, x).setValues(1, y).setValues(2, z).build();
    }

    private static DataSet createTestData() {
        int nPoints = 1000;
        double f = 0.1;
        double[] x = new double[1000];
        double[] y = new double[1000];
        for (int i = 0; i < x.length; ++i) {
            double val;
            x[i] = val = ((double)i / (double)x.length - 0.5) * 10.0;
            y[i] = val;
        }
        double[][] z = new double[x.length][y.length];
        for (int yIndex = 0; yIndex < y.length; ++yIndex) {
            for (int xIndex = 0; xIndex < x.length; ++xIndex) {
                z[xIndex][yIndex] = Math.sin(0.6283185307179586 * x[xIndex]) * Math.cos(0.6283185307179586 * y[yIndex]);
            }
        }
        return new DataSetBuilder("demoDataSet").setValues(0, x).setValues(1, y).setValues(2, z).build();
    }

    private XYChart getChartPane(Slider slider1, Slider slider2, Slider slider3, ContourType colorMap) {
        DefaultNumericAxis xAxis = new DefaultNumericAxis();
        xAxis.setAnimated(false);
        xAxis.setAutoRangeRounding(false);
        xAxis.setName("X Position");
        xAxis.setAutoRanging(true);
        DefaultNumericAxis yAxis = new DefaultNumericAxis();
        yAxis.setAnimated(false);
        yAxis.setAutoRangeRounding(false);
        yAxis.setName("Y Position");
        yAxis.setAutoRanging(true);
        DefaultNumericAxis zAxis = new DefaultNumericAxis();
        zAxis.setAnimated(false);
        zAxis.setAutoRangeRounding(false);
        zAxis.setName("z Amplitude");
        zAxis.setAutoRanging(true);
        zAxis.setSide(Side.RIGHT);
        zAxis.getProperties().put((Object)"OmitAxisZoom", (Object)true);
        XYChart chart = new XYChart(new Axis[]{xAxis, yAxis});
        chart.getAxes().add((Object)zAxis);
        chart.setTitle("Test data");
        chart.setAnimated(false);
        chart.getRenderers().clear();
        chart.setLegendVisible(false);
        ContourDataSetRenderer contourRenderer = new ContourDataSetRenderer();
        contourRenderer.getAxes().addAll((Object[])new Axis[]{xAxis, yAxis, zAxis});
        chart.getRenderers().setAll((Object[])new Renderer[]{contourRenderer});
        contourRenderer.setContourType(colorMap);
        contourRenderer.getDatasets().add((Object)this.readImage());
        slider1.valueProperty().bindBidirectional((Property)contourRenderer.quantisationLevelsProperty());
        slider1.valueProperty().addListener((ch, o, n) -> chart.requestLayout());
        slider2.valueProperty().bindBidirectional((Property)contourRenderer.maxContourSegmentsProperty());
        slider2.valueProperty().addListener((ch, o, n) -> chart.requestLayout());
        slider3.valueProperty().bindBidirectional((Property)contourRenderer.minHexTileSizeProperty());
        slider3.valueProperty().addListener((ch, o, n) -> chart.requestLayout());
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new EditAxis());
        HBox.setHgrow((Node)chart, (Priority)Priority.ALWAYS);
        return chart;
    }

    public DataSet readImage() {
        DataSet dataSet;
        BufferedReader reader = new BufferedReader(new InputStreamReader(ContourChartSample.class.getResourceAsStream("./testdata/image.txt")));
        try {
            String skipLine = reader.readLine();
            if (skipLine == null) {
                throw new IllegalStateException("expected non-null line");
            }
            String[] x = reader.readLine().split(" ");
            skipLine = reader.readLine();
            if (skipLine == null) {
                throw new IllegalStateException("expected non-null line");
            }
            String[] y = reader.readLine().split(" ");
            skipLine = reader.readLine();
            if (skipLine == null) {
                throw new IllegalStateException("expected non-null line");
            }
            String[] z = reader.readLine().split(" ");
            double[] xValues = Arrays.stream(x).mapToDouble(Double::valueOf).toArray();
            double[] yValues = Arrays.stream(y).mapToDouble(Double::valueOf).toArray();
            double[] zValues = Arrays.stream(z).mapToDouble(Double::valueOf).toArray();
            dataSet = new DataSetBuilder("contour data").setValues(0, xValues).setValues(1, yValues).setValues(2, zValues).build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.atError().setCause((Throwable)e).log("data read error");
                }
                return null;
            }
        }
        reader.close();
        return dataSet;
    }

    public void start(Stage primaryStage) {
        primaryStage.setTitle("ContourChart Sample");
        Slider nCountourLevelSlider = new Slider(0.0, 100.0, 20.0);
        Slider nSegmentSlider = new Slider(0.0, 10000.0, 500.0);
        Slider minHexSizeSlider = new Slider(1.0, 100.0, 5.0);
        XYChart chartPane1 = this.getChartPane(nCountourLevelSlider, nSegmentSlider, minHexSizeSlider, ContourType.CONTOUR);
        XYChart chartPane2 = this.getChartPane(nCountourLevelSlider, nSegmentSlider, minHexSizeSlider, ContourType.HEATMAP);
        HBox hBox = new HBox(new Node[]{chartPane1, chartPane2});
        VBox.setVgrow((Node)hBox, (Priority)Priority.ALWAYS);
        ContourDataSetRenderer renderer1 = (ContourDataSetRenderer)chartPane1.getRenderers().get(0);
        ContourDataSetRenderer renderer2 = (ContourDataSetRenderer)chartPane2.getRenderers().get(0);
        nCountourLevelSlider.setShowTickLabels(true);
        nCountourLevelSlider.setShowTickMarks(true);
        nCountourLevelSlider.setMajorTickUnit(10.0);
        nCountourLevelSlider.setMinorTickCount(5);
        nCountourLevelSlider.setBlockIncrement(1.0);
        HBox.setHgrow((Node)nCountourLevelSlider, (Priority)Priority.ALWAYS);
        HBox hBoxSlider1 = new HBox(new Node[]{new Label("n countours:"), nCountourLevelSlider});
        nSegmentSlider.setShowTickLabels(true);
        nSegmentSlider.setShowTickMarks(true);
        nSegmentSlider.setMajorTickUnit(200.0);
        nSegmentSlider.setMinorTickCount(50);
        nSegmentSlider.setBlockIncrement(10.0);
        HBox.setHgrow((Node)nSegmentSlider, (Priority)Priority.ALWAYS);
        HBox hBoxSlider2 = new HBox(new Node[]{new Label("n segments :"), nSegmentSlider});
        minHexSizeSlider.setShowTickLabels(true);
        minHexSizeSlider.setShowTickMarks(true);
        minHexSizeSlider.setMajorTickUnit(10.0);
        minHexSizeSlider.setMinorTickCount(10);
        minHexSizeSlider.setBlockIncrement(1.0);
        HBox.setHgrow((Node)minHexSizeSlider, (Priority)Priority.ALWAYS);
        HBox hBoxSlider3 = new HBox(new Node[]{new Label("minHexSizeSize :"), minHexSizeSlider});
        ContourChartSample.bindAxis(chartPane1, chartPane2);
        ComboBox cb1 = new ComboBox();
        cb1.getItems().addAll((Object[])ContourType.values());
        cb1.setValue((Object)renderer1.getContourType());
        cb1.valueProperty().bindBidirectional((Property)renderer1.contourTypeProperty());
        cb1.valueProperty().addListener((ch, old, selection) -> chartPane1.requestLayout());
        ColormapSelector.ColormapComboBox colorGradient1 = new ColormapSelector.ColormapComboBox();
        colorGradient1.getItems().addAll((Collection)ColorGradient.colorGradients());
        colorGradient1.setValue((Object)renderer1.getColorGradient());
        colorGradient1.valueProperty().bindBidirectional((Property)renderer1.colorGradientProperty());
        colorGradient1.valueProperty().addListener((ch, old, selection) -> chartPane1.requestLayout());
        ComboBox cb2 = new ComboBox();
        cb2.getItems().addAll((Object[])ContourType.values());
        cb2.setValue((Object)renderer2.getContourType());
        cb2.valueProperty().bindBidirectional((Property)renderer2.contourTypeProperty());
        cb1.valueProperty().addListener((ch, old, selection) -> chartPane2.requestLayout());
        ColormapSelector.ColormapComboBox colorGradient2 = new ColormapSelector.ColormapComboBox();
        colorGradient2.setValue((Object)renderer2.getColorGradient());
        colorGradient2.valueProperty().bindBidirectional((Property)renderer2.colorGradientProperty());
        colorGradient2.valueProperty().addListener((ch, old, selection) -> chartPane2.requestLayout());
        HBox parameter = new HBox(new Node[]{new Label("Countour1: "), cb1, colorGradient1, new Label(" Countour2: "), cb2, colorGradient2});
        VBox vBox = new VBox(new Node[]{hBox, hBoxSlider1, hBoxSlider2, hBoxSlider3, parameter});
        Scene scene = new Scene((Parent)vBox, 1600.0, 600.0);
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
    }

    private static void bindAxis(XYChart chartPane1, XYChart chartPane2) {
        DefaultNumericAxis xAxis1 = (DefaultNumericAxis)chartPane1.getXAxis();
        DefaultNumericAxis yAxis1 = (DefaultNumericAxis)chartPane1.getYAxis();
        DefaultNumericAxis xAxis2 = (DefaultNumericAxis)chartPane2.getXAxis();
        DefaultNumericAxis yAxis2 = (DefaultNumericAxis)chartPane2.getYAxis();
        DefaultNumericAxis zAxis1 = (DefaultNumericAxis)((ContourDataSetRenderer)chartPane1.getRenderers().get(0)).getZAxis();
        DefaultNumericAxis zAxis2 = (DefaultNumericAxis)((ContourDataSetRenderer)chartPane2.getRenderers().get(0)).getZAxis();
        xAxis1.autoRangingProperty().bindBidirectional((Property)xAxis2.autoRangingProperty());
        yAxis1.autoRangingProperty().bindBidirectional((Property)yAxis2.autoRangingProperty());
        xAxis1.maxProperty().bindBidirectional((Property)xAxis2.maxProperty());
        yAxis1.maxProperty().bindBidirectional((Property)yAxis2.maxProperty());
        xAxis1.minProperty().bindBidirectional((Property)xAxis2.minProperty());
        yAxis1.minProperty().bindBidirectional((Property)yAxis2.minProperty());
        zAxis1.autoRangingProperty().bindBidirectional((Property)zAxis2.autoRangingProperty());
        zAxis1.autoGrowRangingProperty().bindBidirectional((Property)zAxis2.autoGrowRangingProperty());
        zAxis1.invertAxisProperty().bindBidirectional((Property)zAxis2.invertAxisProperty());
        zAxis1.maxProperty().bindBidirectional((Property)zAxis2.maxProperty());
        zAxis1.minProperty().bindBidirectional((Property)zAxis2.minProperty());
    }

    public static void main(String[] args) {
        ProcessingProfiler.setVerboseOutputState((boolean)true);
        Application.launch((String[])args);
    }
}

