/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.axes.spi.format.DefaultTimeFormatter;
import de.gsi.chart.plugins.DataPointTooltip;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Panner;
import de.gsi.chart.plugins.ParameterMeasurements;
import de.gsi.chart.plugins.XRangeIndicator;
import de.gsi.chart.plugins.XValueIndicator;
import de.gsi.chart.plugins.YRangeIndicator;
import de.gsi.chart.plugins.YValueIndicator;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.datareduction.DefaultDataReducer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.ui.ProfilerInfoBox;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.spi.FifoDoubleErrorDataSet;
import de.gsi.dataset.testdata.spi.RandomDataGenerator;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.time.ZoneOffset;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartIndicatorSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChartIndicatorSample.class);
    private static final int MIN_PIXEL_DISTANCE = 0;
    private static final int N_SAMPLES = 3000;
    private static final int UPDATE_DELAY = 1000;
    private static final int UPDATE_PERIOD = 40;
    private static final int BUFFER_CAPACITY = 750;
    private static final double MAX_DISTANCE = 27.0;
    public final FifoDoubleErrorDataSet rollingBufferDipoleCurrent = new FifoDoubleErrorDataSet("dipole current [A]", 750, 27.0);
    public final FifoDoubleErrorDataSet rollingBufferBeamIntensity = new FifoDoubleErrorDataSet("beam intensity [ppp]", 750, 27.0);
    private final FifoDoubleErrorDataSet rollingSine = new FifoDoubleErrorDataSet("sine [A]", 750, 27.0);
    private final ErrorDataSetRenderer beamIntensityRenderer = new ErrorDataSetRenderer();
    private final ErrorDataSetRenderer dipoleCurrentRenderer = new ErrorDataSetRenderer();
    private Timer timer;
    private long startTime;

    private void generateData() {
        this.startTime = ProcessingProfiler.getTimeStamp();
        double now = (double)System.currentTimeMillis() / 1000.0 + 1.0;
        if (this.rollingBufferDipoleCurrent.getDataCount() == 0) {
            this.rollingBufferBeamIntensity.autoNotification().set(false);
            this.rollingBufferDipoleCurrent.autoNotification().set(false);
            this.rollingSine.autoNotification().set(false);
            for (int n = 3000; n > 0; --n) {
                double t = now - (double)(n * 40) / 1000.0;
                double y = 25.0 * ChartIndicatorSample.rampFunctionDipoleCurrent(t);
                double y2 = 100.0 * ChartIndicatorSample.rampFunctionBeamIntensity(t);
                double ey = 1.0;
                this.rollingBufferDipoleCurrent.add(t, y, 1.0, 1.0);
                this.rollingBufferBeamIntensity.add(t + 0.04 * RandomDataGenerator.random(), y2, 1.0, 1.0);
                this.rollingSine.add(t + 1.0 + 0.04 * RandomDataGenerator.random(), y * 0.8, 1.0, 1.0);
            }
            this.rollingBufferBeamIntensity.autoNotification().set(true);
            this.rollingBufferDipoleCurrent.autoNotification().set(true);
            this.rollingSine.autoNotification().set(true);
        } else {
            this.rollingBufferDipoleCurrent.autoNotification().set(false);
            double y = 25.0 * ChartIndicatorSample.rampFunctionDipoleCurrent(now);
            double y2 = 100.0 * ChartIndicatorSample.rampFunctionBeamIntensity(now);
            double ey = 1.0;
            this.rollingBufferDipoleCurrent.add(now, y, 1.0, 1.0);
            this.rollingBufferBeamIntensity.add(now, y2, 1.0, 1.0);
            double val = 1500.0 + 1000.0 * Math.sin(0.6283185307179586 * now);
            this.rollingSine.add(now + 1.0, val, 1.0, 1.0);
            this.rollingBufferDipoleCurrent.autoNotification().set(true);
        }
        ProcessingProfiler.getTimeDiff((long)this.startTime, (String)"adding data into DataSet");
    }

    private HBox getHeaderBar(TimerTask task) {
        Button newDataSet = new Button("new DataSet");
        newDataSet.setOnAction(evt -> Platform.runLater((Runnable)task));
        Button startTimer = new Button("timer");
        startTimer.setOnAction(evt -> {
            this.rollingBufferBeamIntensity.reset();
            this.rollingBufferDipoleCurrent.reset();
            if (this.timer == null) {
                this.timer = new Timer("sample-update-timer", true);
                this.timer.scheduleAtFixedRate(task, 1000L, 40L);
            } else {
                this.timer.cancel();
                this.timer = null;
            }
        });
        Region spacer = new Region();
        spacer.setMinWidth(Double.NEGATIVE_INFINITY);
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        ProfilerInfoBox profiler = new ProfilerInfoBox();
        profiler.setDebugLevel(ProfilerInfoBox.DebugLevel.VERSION);
        return new HBox(new Node[]{newDataSet, startTimer, spacer, profiler});
    }

    public BorderPane initComponents() {
        BorderPane root = new BorderPane();
        this.generateData();
        this.initErrorDataSetRenderer(this.beamIntensityRenderer);
        this.initErrorDataSetRenderer(this.dipoleCurrentRenderer);
        DefaultNumericAxis xAxis1 = new DefaultNumericAxis();
        DefaultNumericAxis xAxis2 = new DefaultNumericAxis();
        xAxis2.setAnimated(false);
        DefaultNumericAxis yAxis1 = new DefaultNumericAxis("beam intensity", "ppp");
        DefaultNumericAxis yAxis2 = new DefaultNumericAxis("dipole current", "A");
        yAxis2.setSide(Side.RIGHT);
        yAxis2.setAutoUnitScaling(true);
        yAxis2.setAutoRanging(true);
        yAxis2.setAnimated(false);
        DefaultNumericAxis yAxis3 = new DefaultNumericAxis("test", 0.0, 1.0, 0.1);
        yAxis3.setSide(Side.RIGHT);
        DefaultNumericAxis xAxis3 = new DefaultNumericAxis("test", 0.0, 1.0, 0.1);
        xAxis3.setSide(Side.TOP);
        this.dipoleCurrentRenderer.getAxes().addAll((Object[])new Axis[]{yAxis2});
        XYChart chart = new XYChart(new Axis[]{xAxis1, yAxis1});
        chart.legendVisibleProperty().set(true);
        chart.setAnimated(false);
        chart.getXAxis().setName("time 1");
        chart.getXAxis().setAutoRanging(true);
        chart.getYAxis().setName("beam intensity");
        chart.getYAxis().setAutoRanging(true);
        chart.getYAxis().setSide(Side.LEFT);
        chart.getRenderers().set(0, (Object)this.beamIntensityRenderer);
        chart.getRenderers().add((Object)this.dipoleCurrentRenderer);
        chart.getPlugins().add((Object)new ParameterMeasurements());
        chart.getPlugins().add((Object)new EditAxis());
        chart.getPlugins().add((Object)new DataPointTooltip());
        chart.getPlugins().add((Object)new Panner());
        Zoomer zoom = new Zoomer();
        zoom.setSliderVisible(false);
        chart.getPlugins().add((Object)zoom);
        double minX = this.rollingBufferDipoleCurrent.getAxisDescription(0).getMin();
        double maxX = this.rollingBufferDipoleCurrent.getAxisDescription(0).getMax();
        double minY1 = this.rollingBufferBeamIntensity.getAxisDescription(1).getMin();
        double maxY1 = this.rollingBufferBeamIntensity.getAxisDescription(1).getMax();
        double minY2 = this.rollingBufferDipoleCurrent.getAxisDescription(1).getMin();
        double maxY2 = this.rollingBufferDipoleCurrent.getAxisDescription(1).getMax();
        double rangeX = maxX - minX;
        double rangeY1 = maxY1 - minY1;
        double rangeY2 = maxY2 - minY2;
        XRangeIndicator xRange = new XRangeIndicator((Axis)xAxis1, minX + 0.1 * rangeX, minX + 0.2 * rangeX, "range-X");
        chart.getPlugins().add((Object)xRange);
        xRange.upperBoundProperty().bind((ObservableValue)xAxis1.maxProperty().subtract(0.1));
        xRange.lowerBoundProperty().bind((ObservableValue)xAxis1.maxProperty().subtract(1.0));
        YRangeIndicator yRange1 = new YRangeIndicator((Axis)yAxis1, minY1 + 0.1 * rangeY1, minY1 + 0.2 * rangeY1, "range-Y1");
        chart.getPlugins().add((Object)yRange1);
        YRangeIndicator yRange2 = new YRangeIndicator((Axis)yAxis2, 2100.0, 2200.0, "range-Y2 (2100-2200 A)");
        chart.getPlugins().add((Object)yRange2);
        XValueIndicator xValueIndicator = new XValueIndicator((Axis)xAxis1, minX + 0.5 * rangeX, "mid-range label -X");
        chart.getPlugins().add((Object)xValueIndicator);
        YValueIndicator yValueIndicator1 = new YValueIndicator((Axis)yAxis1, minY1 + 0.5 * rangeY1, "mid-range label -Y1");
        chart.getPlugins().add((Object)yValueIndicator1);
        YValueIndicator yValueIndicator2 = new YValueIndicator((Axis)yAxis2, minY2 + 0.2 * rangeY2, "mid-range label -Y2");
        chart.getPlugins().add((Object)yValueIndicator2);
        this.beamIntensityRenderer.getDatasets().add((Object)this.rollingBufferBeamIntensity);
        this.dipoleCurrentRenderer.getDatasets().add((Object)this.rollingBufferDipoleCurrent);
        this.dipoleCurrentRenderer.getDatasets().add((Object)this.rollingSine);
        xAxis1.setAutoRangeRounding(false);
        xAxis2.setAutoRangeRounding(false);
        xAxis1.setTickLabelRotation(45.0);
        xAxis2.setTickLabelRotation(45.0);
        xAxis1.invertAxis(false);
        xAxis2.invertAxis(false);
        xAxis1.setTimeAxis(true);
        xAxis2.setTimeAxis(true);
        if (xAxis1.isTimeAxis() && xAxis1.getAxisLabelFormatter() instanceof DefaultTimeFormatter) {
            DefaultTimeFormatter axisFormatter = (DefaultTimeFormatter)xAxis1.getAxisLabelFormatter();
            axisFormatter.setTimeZoneOffset(ZoneOffset.UTC);
            axisFormatter.setTimeZoneOffset(ZoneOffset.ofHoursMinutes(5, 0));
        }
        yAxis1.setForceZeroInRange(true);
        yAxis2.setForceZeroInRange(true);
        yAxis1.setAutoRangeRounding(true);
        yAxis2.setAutoRangeRounding(true);
        chart.getAxes().addAll((Object[])new Axis[]{yAxis3, xAxis3});
        chart.getPlugins().add((Object)new YValueIndicator((Axis)yAxis3, 0.4));
        chart.getPlugins().add((Object)new XValueIndicator((Axis)xAxis3, 0.3));
        TimerTask task = new TimerTask(){
            int updateCount = 0;

            @Override
            public void run() {
                Platform.runLater(() -> {
                    ChartIndicatorSample.this.generateData();
                    if (this.updateCount % 20 == 0) {
                        LOGGER.atInfo().log("update iteration #" + this.updateCount);
                    }
                    ++this.updateCount;
                });
            }
        };
        root.setTop((Node)this.getHeaderBar(task));
        this.startTime = ProcessingProfiler.getTimeStamp();
        ProcessingProfiler.getTimeDiff((long)this.startTime, (String)"adding data to chart");
        this.startTime = ProcessingProfiler.getTimeStamp();
        root.setCenter((Node)chart);
        ProcessingProfiler.getTimeDiff((long)this.startTime, (String)"adding chart into StackPane");
        return root;
    }

    protected void initErrorDataSetRenderer(ErrorDataSetRenderer eRenderer) {
        eRenderer.setErrorType(ErrorStyle.ERRORSURFACE);
        eRenderer.setDashSize(0);
        eRenderer.setDrawMarker(false);
        DefaultDataReducer reductionAlgorithm = (DefaultDataReducer)eRenderer.getRendererDataReducer();
        reductionAlgorithm.setMinPointPixelDistance(0);
    }

    public void start(Stage primaryStage) {
        ProcessingProfiler.setDebugState((boolean)false);
        BorderPane root = new BorderPane();
        Scene scene = new Scene((Parent)root, 1800.0, 400.0);
        root.setCenter((Node)this.initComponents());
        this.startTime = ProcessingProfiler.getTimeStamp();
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.show();
        ProcessingProfiler.getTimeDiff((long)this.startTime, (String)"for showing");
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private static double rampFunctionBeamIntensity(double t) {
        int second = (int)Math.floor(t);
        double subSecond = t - (double)second;
        double offset = 0.3;
        double y = (1.0 - 0.1 * subSecond) * 1.0E9;
        double gate = ChartIndicatorSample.square(2.0, subSecond - offset) * ChartIndicatorSample.square(1.0, subSecond - offset);
        if (second % 5 == 0) {
            offset = 0.1;
            gate = Math.pow(ChartIndicatorSample.square(3.0, subSecond - offset), 2.0);
        }
        if (gate <= 0.0 || subSecond < offset) {
            gate = 0.0;
        }
        return gate * y;
    }

    private static double rampFunctionDipoleCurrent(double t) {
        int second = (int)Math.floor(t);
        double subSecond = t - (double)second;
        double offset = 0.3;
        double y = 100.0 * ChartIndicatorSample.sine(1.0, subSecond - offset);
        if (second % 5 == 0) {
            offset = 0.1;
            y = 100.0 * Math.pow(ChartIndicatorSample.sine(1.5, subSecond - offset), 2.0);
        }
        if (y <= 0.0 || subSecond < offset) {
            y = 0.0;
        }
        return y + 10.0;
    }

    private static double sine(double frequency, double t) {
        return Math.sin(Math.PI * 2 * frequency * t);
    }

    private static double square(double frequency, double t) {
        double sine = 100.0 * Math.sin(Math.PI * 2 * frequency * t);
        double squarePoint = Math.signum(sine);
        return squarePoint >= 0.0 ? squarePoint : 0.0;
    }
}

