/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.Chart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.samples.WriteDataSetToFileSample;
import de.gsi.chart.ui.geometry.Corner;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.DataSet;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.collections.ListChangeListener;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartAnatomySample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteDataSetToFileSample.class);

    public void start(Stage primaryStage) {
        VBox root = new VBox();
        root.setAlignment(Pos.CENTER);
        DefaultNumericAxis xAxis1 = new DefaultNumericAxis("x-Axis1", 0.0, 100.0, 1.0);
        DefaultNumericAxis xAxis2 = new DefaultNumericAxis("x-Axis2", 0.0, 100.0, 1.0);
        DefaultNumericAxis xAxis3 = new DefaultNumericAxis("x-Axis3", -50.0, 50.0, 10.0);
        DefaultNumericAxis yAxis1 = new DefaultNumericAxis("y-Axis1", 0.0, 100.0, 1.0);
        DefaultNumericAxis yAxis2 = new DefaultNumericAxis("y-Axis2", 0.0, 100.0, 1.0);
        DefaultNumericAxis yAxis3 = new DefaultNumericAxis("y-Axis3", 0.0, 100.0, 1.0);
        DefaultNumericAxis yAxis4 = new DefaultNumericAxis("y-Axis4", -50.0, 50.0, 10.0);
        xAxis1.setSide(Side.BOTTOM);
        xAxis2.setSide(Side.TOP);
        xAxis3.setSide(Side.CENTER_HOR);
        xAxis3.setMinorTickCount(2);
        xAxis3.setAxisLabelTextAlignment(TextAlignment.RIGHT);
        yAxis1.setSide(Side.LEFT);
        yAxis2.setSide(Side.RIGHT);
        yAxis3.setSide(Side.RIGHT);
        yAxis4.setSide(Side.CENTER_VER);
        yAxis4.setMinorTickCount(2);
        yAxis4.setAxisLabelTextAlignment(TextAlignment.RIGHT);
        Chart chart = new Chart(new Axis[0]){

            protected void axesChanged(ListChangeListener.Change<? extends Axis> change) {
            }

            protected void redrawCanvas() {
            }

            public void updateAxisRange() {
            }

            protected void updateLegend(List<DataSet> dataSets, List<Renderer> renderers) {
            }
        };
        VBox.setVgrow((Node)chart, (Priority)Priority.ALWAYS);
        chart.getAxes().addAll((Object[])new Axis[]{xAxis1, yAxis1});
        chart.setTitle("<Title> Hello World Chart </Title>");
        chart.getToolBar().getChildren().add((Object)new Label("ToolBar Menu: "));
        for (Side side : Side.values()) {
            Button toolBarButton = new Button("ToolBar to " + side);
            toolBarButton.setOnMouseClicked(mevt -> chart.setToolBarSide(side));
            chart.getToolBar().getChildren().add((Object)toolBarButton);
        }
        chart.getAxesPane(Side.BOTTOM).getChildren().add((Object)xAxis1);
        chart.getAxesPane(Side.TOP).getChildren().add((Object)xAxis2);
        chart.getAxesPane(Side.CENTER_HOR).getChildren().add((Object)xAxis3);
        chart.getAxesPane(Side.LEFT).getChildren().add((Object)yAxis1);
        chart.getAxesPane(Side.RIGHT).getChildren().add((Object)yAxis2);
        chart.getAxesPane(Side.RIGHT).getChildren().add((Object)yAxis3);
        chart.getAxesPane(Side.CENTER_VER).getChildren().add((Object)yAxis4);
        chart.getTitleLegendPane(Side.LEFT).getChildren().add((Object)new MyLabel("Title/Legend - left", true));
        chart.getTitleLegendPane(Side.RIGHT).getChildren().add((Object)new MyLabel("Title/Legend - right", true));
        chart.getTitleLegendPane(Side.TOP).getChildren().add((Object)new MyLabel("Title/Legend - top"));
        chart.getTitleLegendPane(Side.BOTTOM).getChildren().add((Object)new MyLabel("Title/Legend - bottom"));
        chart.getAxesCornerPane(Corner.BOTTOM_LEFT).getChildren().add((Object)new MyLabel("(BL)"));
        chart.getAxesCornerPane(Corner.BOTTOM_RIGHT).getChildren().add((Object)new MyLabel("(BR)"));
        chart.getAxesCornerPane(Corner.TOP_LEFT).getChildren().add((Object)new MyLabel("(TL)"));
        chart.getAxesCornerPane(Corner.TOP_RIGHT).getChildren().add((Object)new MyLabel("(TR)"));
        for (Side side : Corner.values()) {
            chart.getAxesCornerPane((Corner)side).setStyle("-fx-background-color: rgba(125, 125, 125, 0.5);");
            chart.getTitleLegendCornerPane((Corner)side).setStyle("-fx-background-color: rgba(175, 175, 175, 0.5);");
        }
        for (Side side : Side.values()) {
            chart.getMeasurementBar(side).getChildren().add((Object)new MyLabel("ParBox - " + side));
            chart.getMeasurementBar(side).setStyle("-fx-background-color: rgba(125, 125, 125, 0.5);");
        }
        chart.getCanvas().setMouseTransparent(false);
        chart.getCanvas().setOnMouseClicked(mevt -> LOGGER.atInfo().log("clicked on canvas"));
        ((Node)chart.getAxes().get(0)).setOnMouseClicked(mevt -> LOGGER.atInfo().log("clicked on xAxis"));
        chart.getCanvas().addEventHandler(MouseEvent.MOUSE_CLICKED, mevt -> LOGGER.atInfo().log("clicked on canvas - alt implementation"));
        root.getChildren().add((Object)chart);
        Scene scene = new Scene((Parent)root, 1000.0, 600.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.show();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private class MyLabel
    extends Label {
        public MyLabel(String label) {
            super(label);
            VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
            this.setPrefSize(-1.0, -1.0);
        }

        public MyLabel(String label, boolean rotate) {
            this(label);
            if (rotate) {
                this.setRotate(90.0);
            }
        }
    }
}

