/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.acc.remote;

import de.gsi.dataset.remote.MimeType;
import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipboardReceiverSample {
    public static final String ENDPOINT_STATUS_SSE = "http://localhost:8080/clipboard/status";
    public static final String ENDPOINT_STATUS_IMG = "http://localhost:8080/clipboard/status.png";
    private static final Logger LOGGER = LoggerFactory.getLogger(CipboardReceiverSample.class);
    private static final OkHttpClient okClient = new OkHttpClient();
    private static final EventSource.Factory factory = EventSources.createFactory((OkHttpClient)okClient);
    private static final EventSourceListener EVENT_SOURCE_LISTENER = new EventSourceListener(){

        public void onOpen(EventSource eventSource, Response response) {
            LOGGER.atInfo().addArgument((Object)eventSource).addArgument((Object)response).log("[ES] onOpen - event from '{}' and response '{}'");
        }

        public void onEvent(EventSource eventSource, String id, String type, String data) {
            LOGGER.atInfo().addArgument((Object)eventSource).addArgument((Object)id).addArgument((Object)type).addArgument((Object)data).log("[ES] onEvent - event from '{}' id = {} type = {} data = {}");
        }

        public void onFailure(EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
            LOGGER.atInfo().addArgument((Object)eventSource).addArgument((Object)response).addArgument((Object)(response == null ? " null" : response.body())).log("[ES] onFailure - event onFailure from '{}' response = {} - body = '{}'");
        }
    };

    public static byte[] getByteArrayOkHTTP(String path, MimeType mimeType, boolean useGSON) {
        byte[] byArray;
        block10: {
            Request request = new Request.Builder().url(path).get().addHeader("Accept", mimeType.toString()).build();
            Response response = okClient.newCall(request).execute();
            try {
                switch (mimeType) {
                    default: 
                }
                byte[] byArray2 = byArray = response.body() != null ? response.body().bytes() : new byte[]{};
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.atError().setCause((Throwable)e);
                    e.printStackTrace();
                    return new byte[0];
                }
            }
            response.close();
        }
        return byArray;
    }

    public static EventSource newEventSource(String path) {
        Request request = new Request.Builder().url(path).addHeader("Accept", MimeType.EVENT_STREAM.toString()).build();
        LOGGER.atInfo().addArgument((Object)path).addArgument((Object)request).log("init sse to '{}' request = {}");
        return factory.newEventSource(request, EVENT_SOURCE_LISTENER);
    }

    public static void main(String[] args) throws InterruptedException {
        EventSource sseSource = CipboardReceiverSample.newEventSource(ENDPOINT_STATUS_IMG);
        assert (sseSource != null);
        while (!Thread.currentThread().isInterrupted()) {
            Thread.sleep(5000L);
            LOGGER.atInfo().log("waiting for events");
            byte[] data = CipboardReceiverSample.getByteArrayOkHTTP(ENDPOINT_STATUS_IMG, MimeType.JSON, false);
            if (data == null) continue;
            LOGGER.atInfo().addArgument((Object)data.length).log("polled {} bytes");
        }
    }
}

