/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.samples;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.TableViewer;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.LineStyle;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.DoubleDataSet;
import de.gsi.dataset.spi.utils.DoublePoint;
import de.gsi.math.ArrayMath;
import de.gsi.math.DataSetMath;
import de.gsi.math.MathDataSet;
import de.gsi.math.spectra.TSpectrum;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSpectrumSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(TSpectrumSample.class);
    private static final String SOURCE1 = "./BBQSpectra.dat";
    private static final String SOURCE2 = "./rawDataCPS2.dat";
    private static final String SOURCE3 = "./rawDataLHCInj.dat";
    private final DoubleDataSet demoDataSet = TSpectrumSample.readDemoData("./BBQSpectra.dat");
    private ErrorDataSetRenderer backgroundRenderer;
    private ErrorDataSetRenderer peakRenderer;
    private final Spinner<Integer> nIterations = new Spinner(1, 100, 10);
    private final ComboBox<TSpectrum.Direction> cbxDirection = new ComboBox(FXCollections.observableArrayList((Object[])TSpectrum.Direction.values()));
    private final ComboBox<TSpectrum.FilterOrder> cbxFilterOrder = new ComboBox(FXCollections.observableArrayList((Object[])TSpectrum.FilterOrder.values()));
    private final ComboBox<TSpectrum.SmoothWindow> cbxSmoothWindow = new ComboBox(FXCollections.observableArrayList((Object[])TSpectrum.SmoothWindow.values()));
    private final CheckBox cbCompton = new CheckBox();
    private final CheckBox cbMarkov = new CheckBox();
    private final CheckBox cbBackground = new CheckBox();
    private final Spinner<Integer> spAverageMarkov = new Spinner(1, 100, 7);
    private final Spinner<Integer> spAverageSearch = new Spinner(1, 100, 7);
    private final Spinner<Double> spSigma = new Spinner(0.1, 100.0, 3.0, 0.1);
    private final Spinner<Double> spThreshold = new Spinner(0.001, 99.0, 10.0, 0.1);

    private VBox getBottomControls() {
        VBox root = new VBox();
        ToolBar toolBarBackground = new ToolBar();
        this.nIterations.valueProperty().addListener((ch, o, n) -> this.triggerDataSetUpdate());
        this.nIterations.setPrefWidth(70.0);
        this.cbxDirection.getSelectionModel().select((Object)TSpectrum.Direction.DECREASING);
        this.cbxDirection.setOnAction(evt -> this.triggerDataSetUpdate());
        this.cbxFilterOrder.getSelectionModel().select((Object)TSpectrum.FilterOrder.ORDER_6);
        this.cbxFilterOrder.setOnAction(evt -> this.triggerDataSetUpdate());
        this.cbxSmoothWindow.getSelectionModel().select((Object)TSpectrum.SmoothWindow.SMOOTHING_WIDTH15);
        this.cbxSmoothWindow.setOnAction(evt -> this.triggerDataSetUpdate());
        this.cbCompton.setOnAction(evt -> this.triggerDataSetUpdate());
        toolBarBackground.getItems().addAll((Object[])new Node[]{new Label("background:"), new Label("nIterations: "), this.nIterations, this.cbxDirection, this.cbxFilterOrder, this.cbxSmoothWindow, new Label("Compton:"), this.cbCompton});
        ToolBar toolBarMarkov = new ToolBar();
        this.spAverageMarkov.valueProperty().addListener((ch, o, n) -> this.triggerDataSetUpdate());
        this.spAverageMarkov.setPrefWidth(70.0);
        toolBarMarkov.getItems().addAll((Object[])new Node[]{new Label("Markov background:"), new Label("avg-width [bins: "), this.spAverageMarkov});
        ToolBar toolBarSearch = new ToolBar();
        this.spSigma.valueProperty().addListener((ch, o, n) -> this.triggerDataSetUpdate());
        this.spSigma.setPrefWidth(70.0);
        this.spSigma.setEditable(true);
        this.spThreshold.valueProperty().addListener((ch, o, n) -> this.triggerDataSetUpdate());
        this.spThreshold.setPrefWidth(100.0);
        this.spThreshold.setEditable(true);
        this.cbMarkov.setOnAction(evt -> this.triggerDataSetUpdate());
        this.cbBackground.setOnAction(evt -> this.triggerDataSetUpdate());
        this.spAverageSearch.valueProperty().addListener((ch, o, n) -> this.triggerDataSetUpdate());
        this.spAverageSearch.setPrefWidth(70.0);
        toolBarSearch.getItems().addAll((Object[])new Node[]{new Label("peak search: "), new Label("sigma [bins]: "), this.spSigma, new Label("threshold [%]: "), this.spThreshold, new Label("Markov?:"), this.cbMarkov, new Label("subtract bg: "), this.cbBackground, new Label("avg [bins]:"), this.spAverageSearch});
        root.getChildren().addAll((Object[])new Node[]{toolBarBackground, toolBarMarkov, toolBarSearch});
        return root;
    }

    private Chart getChart() {
        DefaultNumericAxis xAxis = new DefaultNumericAxis("frequency", "frev");
        DefaultNumericAxis yAxis = new DefaultNumericAxis("magnitude", "dB");
        yAxis.setForceZeroInRange(true);
        XYChart chart = new XYChart((Axis)xAxis, (Axis)yAxis);
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new EditAxis());
        chart.getPlugins().add((Object)new TableViewer());
        ((Renderer)chart.getRenderers().get(0)).getDatasets().add((Object)this.demoDataSet);
        this.backgroundRenderer = new ErrorDataSetRenderer();
        this.peakRenderer = new ErrorDataSetRenderer();
        this.peakRenderer.setPolyLineStyle(LineStyle.NONE);
        this.peakRenderer.setMarkerSize(5.0);
        this.peakRenderer.setAssumeSortedData(false);
        chart.getRenderers().addAll((Object[])new Renderer[]{this.backgroundRenderer, this.peakRenderer});
        return chart;
    }

    private ToolBar getTopToolBar() {
        ToolBar toolBar = new ToolBar();
        ToggleGroup radioGroup = new ToggleGroup();
        RadioButton bbqButton1 = new RadioButton("LHC BBQ spectrum");
        bbqButton1.setSelected(true);
        bbqButton1.setToggleGroup(radioGroup);
        toolBar.getItems().add((Object)bbqButton1);
        bbqButton1.selectedProperty().addListener((ch, o, n) -> {
            if (Boolean.FALSE.equals(n)) {
                return;
            }
            this.demoDataSet.set((DataSet)TSpectrumSample.readDemoData(SOURCE1));
        });
        RadioButton bbqButton2 = new RadioButton("CPS BBQ spectrum");
        bbqButton2.setToggleGroup(radioGroup);
        toolBar.getItems().add((Object)bbqButton2);
        bbqButton2.selectedProperty().addListener((ch, o, n) -> {
            if (Boolean.FALSE.equals(n)) {
                return;
            }
            this.demoDataSet.set((DataSet)new MathDataSet(null, DataSetMath::magnitudeSpectrumDecibel, (DataSet)TSpectrumSample.readDemoData(SOURCE2)));
        });
        RadioButton bbqButton3 = new RadioButton("LHC injection BBQ spectrum");
        bbqButton3.setToggleGroup(radioGroup);
        toolBar.getItems().add((Object)bbqButton3);
        bbqButton3.selectedProperty().addListener((ch, o, n) -> {
            if (Boolean.FALSE.equals(n)) {
                return;
            }
            this.demoDataSet.set((DataSet)new MathDataSet(null, DataSetMath::magnitudeSpectrumDecibel, (DataSet)TSpectrumSample.readDemoData(SOURCE3)));
        });
        RadioButton synthButton = new RadioButton("synthetic spectrum");
        Slider slider = new Slider(10.0, 8192.0, 512.0);
        slider.setBlockIncrement(10.0);
        slider.valueProperty().addListener((ch, o, n) -> {
            if (synthButton.isSelected()) {
                this.demoDataSet.set((DataSet)TSpectrumSample.generateDemoSineWaveData(n.intValue()));
            }
        });
        synthButton.setToggleGroup(radioGroup);
        toolBar.getItems().add((Object)synthButton);
        synthButton.selectedProperty().addListener((ch, o, n) -> {
            if (Boolean.FALSE.equals(n)) {
                return;
            }
            this.demoDataSet.set((DataSet)TSpectrumSample.generateDemoSineWaveData((int)slider.getValue()));
        });
        toolBar.getItems().add((Object)slider);
        return toolBar;
    }

    public void start(Stage primaryStage) {
        Chart chart = this.getChart();
        BorderPane root = new BorderPane((Node)chart);
        root.setTop((Node)this.getTopToolBar());
        root.setBottom((Node)this.getBottomControls());
        MathDataSet dsBackground = new MathDataSet("background", (input, output, length) -> {
            LOGGER.atInfo().log("trigger background update");
            int nIter = (Integer)this.nIterations.getValue();
            TSpectrum.Direction direction = (TSpectrum.Direction)this.cbxDirection.getSelectionModel().getSelectedItem();
            TSpectrum.FilterOrder filterOrder = (TSpectrum.FilterOrder)this.cbxFilterOrder.getSelectionModel().getSelectedItem();
            TSpectrum.SmoothWindow smoothing = (TSpectrum.SmoothWindow)this.cbxSmoothWindow.getSelectionModel().getSelectedItem();
            boolean compton = this.cbCompton.isSelected();
            TSpectrum.background((double[])input, (double[])output, (int)length, (int)nIter, (TSpectrum.Direction)direction, (TSpectrum.FilterOrder)filterOrder, (TSpectrum.SmoothWindow)smoothing, (boolean)compton);
        }, (DataSet)this.demoDataSet);
        this.backgroundRenderer.getDatasets().addAll((Object[])new DataSet[]{dsBackground});
        MathDataSet dsMarkov = new MathDataSet("bgMarkov", (input, output, length) -> {
            int nAverage = (Integer)this.spAverageMarkov.getValue();
            ArrayMath.decibelInPlace((double[])TSpectrum.smoothMarkov((double[])ArrayMath.inverseDecibel((double[])input), (double[])output, (int)length, (int)nAverage));
        }, (DataSet)this.demoDataSet);
        this.backgroundRenderer.getDatasets().addAll((Object[])new DataSet[]{dsMarkov});
        DoubleDataSet dsBgSearch = new DoubleDataSet("peak search background");
        MathDataSet foundPeaks = new MathDataSet("peak", dataSet -> {
            if (!(dataSet instanceof DataSet2D)) {
                return new DoubleDataSet("no peaks(processing error)");
            }
            double[] freq = ((DataSet2D)dataSet).getXValues();
            double[] rawData = ((DataSet2D)dataSet).getYValues();
            double[] destVector = new double[dataSet.getDataCount()];
            double sigma = (Double)this.spSigma.getValue();
            double threshold = (Double)this.spThreshold.getValue();
            int nIter = (Integer)this.nIterations.getValue();
            int nAverage = (Integer)this.spAverageSearch.getValue();
            boolean markov = this.cbMarkov.isSelected();
            boolean backgroundRemove = this.cbBackground.isSelected();
            List peaks = TSpectrum.search((double[])freq, (double[])ArrayMath.inverseDecibel((double[])rawData), (double[])destVector, (int)dataSet.getDataCount(), (int)100, (double)sigma, (double)threshold, (boolean)backgroundRemove, (int)nIter, (boolean)markov, (int)nAverage);
            dsBgSearch.set(freq, ArrayMath.decibel((double[])destVector), dataSet.getDataCount(), true);
            DoubleDataSet retVal = new DoubleDataSet("peaks", 10);
            LOGGER.atInfo().addArgument((Object)peaks.size()).addArgument((Object)dataSet.getDataCount()).log("found {} peaks in spectrum of length {}");
            for (DoublePoint point : peaks) {
                retVal.add(point.getX().doubleValue(), 20.0 * Math.log10(point.getY()));
                LOGGER.atInfo().addArgument((Object)point.getX()).addArgument((Object)point.getY()).log("found peak at ({},{})");
            }
            return retVal;
        }, (DataSet)this.demoDataSet);
        this.peakRenderer.getDatasets().addAll((Object[])new DataSet[]{foundPeaks});
        this.backgroundRenderer.getDatasets().addAll((Object[])new DataSet[]{dsBgSearch});
        Scene scene = new Scene((Parent)root, 1600.0, 600.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
    }

    private void triggerDataSetUpdate() {
        this.demoDataSet.invokeListener((UpdateEvent)new UpdatedDataEvent((EventSource)this.demoDataSet, "GUI related update"));
    }

    protected static DoubleDataSet generateDemoSineWaveData(int nData) {
        DoubleDataSet function = new DoubleDataSet("composite sine", nData);
        for (int i = 0; i < nData; ++i) {
            double t = i;
            double y = 0.0;
            double centreFrequency = 0.25;
            double diffFrequency = 0.05;
            for (int j = 0; j < 8; ++j) {
                double a = 0.1 * Math.pow(10.0, -j);
                double diff = j == 0 ? 0.0 : ((double)(j % 2) - 0.5) * (double)j * 0.05;
                y += a * Math.sin(Math.PI * 2 * (0.25 + diff) * t);
            }
            function.add(t, y);
        }
        return new DoubleDataSet(DataSetMath.magnitudeSpectrumDecibel((DataSet)function));
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    protected static DoubleDataSet readDemoData(String fileName) {
        DoubleDataSet doubleDataSet;
        BufferedReader reader = new BufferedReader(new InputStreamReader(TSpectrumSample.class.getResourceAsStream(fileName)));
        try {
            String line = reader.readLine();
            int nDim = line == null ? 0 : Integer.parseInt(line);
            DoubleDataSet spectrum = new DoubleDataSet("BBQ spectrum", nDim);
            for (int i = 0; i < nDim && (line = reader.readLine()) != null; ++i) {
                String[] x = line.split("\t");
                spectrum.add(Double.parseDouble(x[0]), Double.parseDouble(x[1]));
            }
            doubleDataSet = spectrum;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.atError().setCause((Throwable)e).addArgument((Object)fileName).log("read error for file '{}'");
                }
                return new DoubleDataSet("empty dataset <ERROR>");
            }
        }
        reader.close();
        return doubleDataSet;
    }
}

