/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.samples;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DoubleDataSet;
import de.gsi.math.DataSetMath;
import de.gsi.math.filter.iir.Butterworth;
import de.gsi.math.samples.utils.AbstractDemoApplication;
import de.gsi.math.samples.utils.DemoChart;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipInputStream;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IIRFilterSample
extends AbstractDemoApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(IIRFilterSample.class);
    private static final int ORDER = 32;
    private final double sampling = 1.0E8;
    private final double center = 2.8E7;
    private final double width = 500000.0;
    private final int decimationFactor = 100;
    private DataSet fraw;
    private DataSet fraw1;
    private DataSet fraw2;
    private DataSet fspectra;
    private DataSet fspectra1;
    private DataSet fspectra2;

    @Override
    public Node getContent() {
        this.initData();
        DemoChart chart1 = new DemoChart();
        chart1.getXAxis().setName("time");
        chart1.getXAxis().setUnit("s");
        chart1.getYAxis().setName("magnitude");
        chart1.getYAxis().setUnit("a.u.");
        chart1.getDatasets().addAll((Object[])new DataSet[]{this.fraw1, this.fraw2});
        DemoChart chart2 = new DemoChart();
        chart2.getXAxis().setName("frequency [fs]");
        chart2.getXAxis().setUnit("fs");
        chart2.getYAxis().setName("magnitude");
        chart2.getYAxis().setUnit("a.u.");
        chart2.getDatasets().addAll((Object[])new DataSet[]{this.fspectra, this.fspectra1, this.fspectra2});
        return new VBox(new Node[]{chart1, chart2});
    }

    private void initData() {
        double fs = 1.0E8;
        int nBins = 32768;
        this.fraw = this.readDemoData(27500, 32768);
        if (this.fraw == null) {
            throw new IllegalStateException("fraw is null");
        }
        this.fraw1 = this.readDemoData(77500, 32768);
        if (this.fraw1 == null) {
            throw new IllegalStateException("fraw1 is null");
        }
        this.fraw2 = this.readDemoData(177500, 32768);
        if (this.fraw2 == null) {
            throw new IllegalStateException("fraw2 is null");
        }
        LOGGER.atInfo().log("length 0 = " + this.fraw.getDataCount(0));
        LOGGER.atInfo().log("length 1 = " + this.fraw1.getDataCount(0));
        LOGGER.atInfo().log("length 2 = " + this.fraw2.getDataCount(0));
        this.fspectra = DataSetMath.magnitudeSpectrumDecibel((DataSet)this.fraw);
        this.fspectra1 = DataSetMath.magnitudeSpectrumDecibel((DataSet)this.fraw1);
        this.fspectra2 = DataSetMath.magnitudeSpectrumDecibel((DataSet)this.fraw2);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private DataSet readDemoData(int offset, int nSamples) {
        block20: {
            Butterworth bandPass = new Butterworth();
            bandPass.bandPass(32, 1.0E8, 2.8E7, 500000.0);
            Butterworth lowPass = new Butterworth();
            lowPass.lowPass(32, 1.0E8, 500000.0);
            DoubleDataSet ret = new DoubleDataSet("raw data@" + offset);
            InputStream inputStream = IIRFilterSample.class.getResourceAsStream("./20190319_Schottky_SumX.csv.zip");
            try {
                ZipInputStream zipStream = new ZipInputStream(inputStream);
                while (true) {
                    DoubleDataSet doubleDataSet;
                    if (zipStream.getNextEntry() == null) break block20;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(zipStream));
                    try {
                        for (int i = 0; i < 2; ++i) {
                            reader.readLine();
                        }
                        int count = 0;
                        int n = 0;
                        LOGGER.atInfo().log("start reading from " + offset);
                        String line = reader.readLine();
                        while (line != null) {
                            String[] str = line.split(",");
                            double s = Math.sin(6.251769380643688E8 * (double)count);
                            double y = lowPass.filter(s * bandPass.filter(Double.parseDouble(str[1])));
                            if (count >= offset && n < nSamples && count % 100 == 0) {
                                ret.add((double)n / 1.0E8, y);
                                ++n;
                            }
                            ++count;
                            line = reader.readLine();
                        }
                        LOGGER.atInfo().log("finished reading nSamples(total) = " + count);
                        doubleDataSet = ret;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            if (LOGGER.isErrorEnabled()) {
                                LOGGER.atError().setCause((Throwable)e).log("read error");
                            }
                            zipStream.closeEntry();
                            continue;
                        }
                    }
                    reader.close();
                    return doubleDataSet;
                }
                finally {
                    zipStream.close();
                }
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block20;
                LOGGER.atError().setCause((Throwable)e).log("read error");
            }
        }
        return null;
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

