/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.utils.SimplePerformanceMeter;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;

public class ProfilerInfoBox
extends HBox {
    public static final int DEFAULT_DEBUG_UPDATE_RATE = 500;
    public static final String FONT_MONO_SPACE = "Monospaced";

    public ProfilerInfoBox(Scene scene) {
        this(scene, 500);
    }

    public ProfilerInfoBox(Scene scene, int updateRateMillis) {
        SimplePerformanceMeter meter = new SimplePerformanceMeter(scene, (long)updateRateMillis);
        Label javaVersion = new Label();
        javaVersion.setFont(Font.font((String)FONT_MONO_SPACE, (double)12.0));
        javaVersion.setText("JVM: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.version") + " ");
        Label javafxVersion = new Label();
        javafxVersion.setFont(Font.font((String)FONT_MONO_SPACE, (double)12.0));
        javafxVersion.setText("JavaFX: " + System.getProperty("javafx.runtime.version") + " ");
        Label fxFPS = new Label();
        fxFPS.setFont(Font.font((String)FONT_MONO_SPACE, (double)12.0));
        Label chartFPS = new Label();
        chartFPS.setFont(Font.font((String)FONT_MONO_SPACE, (double)12.0));
        Label cpuLoadProcess = new Label();
        cpuLoadProcess.setFont(Font.font((String)FONT_MONO_SPACE, (double)12.0));
        Label cpuLoadSystem = new Label();
        cpuLoadSystem.setFont(Font.font((String)FONT_MONO_SPACE, (double)12.0));
        meter.fxFrameRateProperty().addListener((ch, o, n) -> {
            String fxRate = String.format("%4.1f", meter.getFxFrameRate());
            String actualRate = String.format("%4.1f", meter.getActualFrameRate());
            String cpuProcess = String.format("%5.1f", meter.getProcessCpuLoad());
            String cpuSystem = String.format("%5.1f", meter.getSystemCpuLoad());
            fxFPS.setText(String.format("%-6s: %4s %s", "JavaFX", fxRate, "FPS, "));
            chartFPS.setText(String.format("%-6s: %4s %s", "Actual", actualRate, "FPS, "));
            cpuLoadProcess.setText(String.format("%-11s: %4s %s", "Process-CPU", cpuProcess, "%"));
            cpuLoadSystem.setText(String.format("%-11s: %4s %s", "System -CPU", cpuSystem, "%"));
        });
        this.getChildren().addAll((Object[])new Node[]{new VBox(new Node[]{javaVersion, javafxVersion}), new VBox(new Node[]{fxFPS, chartFPS}), new VBox(new Node[]{cpuLoadProcess, cpuLoadSystem})});
    }
}

