/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.renderer.spi.LabelledMarkerRenderer;
import de.gsi.dataset.spi.DoubleDataSet;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class LabelledMarkerSample
extends Application {
    private static final int N_SAMPLES = 10;

    public void start(Stage primaryStage) {
        XYChart chart = new XYChart((Axis)new DefaultNumericAxis(), (Axis)new DefaultNumericAxis());
        chart.getRenderers().set(0, (Object)new LabelledMarkerRenderer());
        chart.legendVisibleProperty().set(true);
        DoubleDataSet dataSet = new DoubleDataSet("myData");
        for (int n = 0; n < 10; ++n) {
            if (n != 4) {
                dataSet.add((double)n, (double)n, "DataLabel#" + n);
            } else {
                dataSet.add((double)n, (double)n);
            }
            if (n == 3) {
                dataSet.addDataStyle(n, "strokeColor=red");
            }
            if (n == 5) {
                dataSet.addDataStyle(n, "strokeColor=blue; fillColor= blue; strokeDashPattern=3,5,8,5");
            }
            if (n == 6) {
                dataSet.addDataStyle(n, "strokeColor=0xEE00EE; strokeDashPattern=5,8,5,16; fillColor=0xEE00EE");
            }
            if (n == 7) {
                dataSet.addDataStyle(n, "strokeWidth=3;font=\"Serif\";fontSize=20;fontPosture=italic;fontWeight=black;");
            }
            if (n != 8) continue;
            dataSet.addDataStyle(n, "strokeWidth=3;font=\"monospace\";fontPosture=italic;");
        }
        chart.getDatasets().add((Object)dataSet);
        Scene scene = new Scene((Parent)chart, 600.0, 400.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.show();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

