/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.ParameterMeasurements;
import de.gsi.chart.plugins.TableViewer;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.chart.utils.GlyphFactory;
import de.gsi.chart.viewer.DataView;
import de.gsi.chart.viewer.DataViewWindow;
import de.gsi.chart.viewer.DataViewer;
import de.gsi.chart.viewer.event.WindowClosedEvent;
import de.gsi.chart.viewer.event.WindowUpdateEvent;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.spi.DoubleDataSet;
import de.gsi.dataset.testdata.TestDataSet;
import de.gsi.dataset.testdata.spi.RandomStepFunction;
import de.gsi.dataset.testdata.spi.RandomWalkFunction;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javafx.animation.RotateTransition;
import javafx.application.Application;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import javafx.util.Duration;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultProperty(value="views")
public class DataViewerSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataViewerSample.class);
    private static final String TITLE = DataViewerSample.class.getSimpleName();
    protected static final String FONT_AWESOME = "FontAwesome";
    protected static final int FONT_SIZE = 20;
    private static final int NUMBER_OF_POINTS = 10000;
    private static final int UPDATE_PERIOD = 1000;
    private static final int NUM_OF_POINTS = 20;
    private final EventListener dataWindowEventListener = evt -> {
        if (evt instanceof WindowUpdateEvent) {
            WindowUpdateEvent wEvt = (WindowUpdateEvent)evt;
            LOGGER.atInfo().addArgument((Object)wEvt).addArgument((Object)wEvt.getType()).log("received window update event {} of type {}");
        } else {
            LOGGER.atInfo().addArgument((Object)evt).addArgument((Object)evt.getMessage()).log("received generic window update event {} with message {}");
        }
        if (evt instanceof WindowClosedEvent) {
            LOGGER.atInfo().addArgument(((WindowClosedEvent)evt).getSource()).log("window {} closed");
        }
    };

    public void start(Stage primaryStage) {
        ProcessingProfiler.setVerboseOutputState((boolean)false);
        primaryStage.setTitle(TITLE);
        Glyph chartIcon = new Glyph(FONT_AWESOME, (Object)FontAwesome.Glyph.LINE_CHART).size(20.0);
        DataView view1 = new DataView("ChartViews", (Node)chartIcon);
        Glyph customViewIcon = new Glyph(FONT_AWESOME, (Object)FontAwesome.Glyph.USERS).size(20.0);
        DataView view2 = new DataView("Custom View", (Node)customViewIcon, DataViewerSample.getDemoPane());
        DataViewer viewer = new DataViewer();
        viewer.getViews().addAll((Object[])new DataView[]{view1, view2});
        viewer.setExplorerVisible(true);
        TestChart energyChart = new TestChart();
        energyChart.getYAxis().setName("Energy");
        energyChart.getDatasets().addAll(DataViewerSample.createSeries());
        TestChart currentChart = new TestChart();
        currentChart.getRenderers().clear();
        ErrorDataSetRenderer errorDataSetRenderer = new ErrorDataSetRenderer();
        errorDataSetRenderer.setErrorType(ErrorStyle.NONE);
        currentChart.getRenderers().add((Object)errorDataSetRenderer);
        ((Region)currentChart.getYAxis()).lookup(".axis-label").setStyle("-fx-text-fill: green;");
        currentChart.getYAxis().setName("Current");
        currentChart.getYAxis().setSide(Side.RIGHT);
        currentChart.getDatasets().addAll(DataViewerSample.createSeries());
        DataViewWindow currentView = new DataViewWindow("Current", (Node)currentChart);
        currentView.addListener(this.dataWindowEventListener);
        DataViewerSample.logStatePropertyChanges(currentView.getName(), currentView);
        XYChart jDataViewerChart = this.createChart();
        DataViewWindow jDataViewerPane = new DataViewWindow("Chart", (Node)jDataViewerChart);
        jDataViewerPane.addListener(this.dataWindowEventListener);
        DataViewerSample.logStatePropertyChanges(jDataViewerPane.getName(), jDataViewerPane);
        DataViewWindow energyView = new DataViewWindow("Energy", (Node)energyChart);
        energyView.setGraphic((Node)GlyphFactory.create((FontAwesome.Glyph)FontAwesome.Glyph.ADJUST));
        energyView.addListener(this.dataWindowEventListener);
        DataViewerSample.logStatePropertyChanges(energyView.getName(), energyView);
        view1.getVisibleChildren().addAll((Object[])new DataViewWindow[]{energyView, currentView, jDataViewerPane});
        ComboBox initialWindowState = new ComboBox();
        initialWindowState.getItems().setAll((Object[])InitialWindowState.values());
        initialWindowState.setValue((Object)InitialWindowState.VISIBLE);
        CheckBox listView = new CheckBox();
        listView.setGraphic((Node)new Glyph(FONT_AWESOME, '\uf022').size(20.0));
        listView.setTooltip(new Tooltip("click to switch between button and list-style DataView selection"));
        listView.setSelected(viewer.showListStyleDataViewProperty().get());
        listView.selectedProperty().bindBidirectional((Property)viewer.showListStyleDataViewProperty());
        ComboBox windowDecoration = new ComboBox(FXCollections.observableArrayList((Object[])DataViewWindow.WindowDecoration.values()));
        windowDecoration.getSelectionModel().select((Object)viewer.getWindowDecoration());
        windowDecoration.setOnAction(evt -> viewer.setWindowDecoration((DataViewWindow.WindowDecoration)windowDecoration.getSelectionModel().getSelectedItem()));
        CheckBox detachable = new CheckBox();
        Label detachableBox = new Label("allow windows to detach: ", (Node)detachable);
        detachableBox.setContentDisplay(ContentDisplay.RIGHT);
        detachable.setAlignment(Pos.CENTER_RIGHT);
        detachable.setTooltip(new Tooltip("enable/disable windows to detach"));
        detachable.setSelected(viewer.isDetachableWindow());
        detachable.selectedProperty().bindBidirectional((Property)viewer.detachableWindowProperty());
        Button newView = new Button(null, (Node)new HBox(new Node[]{new Glyph(FONT_AWESOME, (Object)FontAwesome.Glyph.PLUS).size(20.0), new Glyph(FONT_AWESOME, (Object)FontAwesome.Glyph.LINE_CHART).size(20.0)}));
        newView.setTooltip(new Tooltip("add new view"));
        newView.setOnAction(evt -> {
            int count = view1.getVisibleChildren().size() + view1.getMinimisedChildren().size();
            XYChart jChart = this.createChart();
            DataViewWindow newDataViewerPane = new DataViewWindow("Chart" + count, (Node)jChart, (DataViewWindow.WindowDecoration)windowDecoration.getValue());
            switch ((InitialWindowState)((Object)((Object)initialWindowState.getValue()))) {
                case DETACHED: {
                    view1.getUndockedChildren().add((Object)newDataViewerPane);
                    break;
                }
                case MINIMISED: {
                    view1.getMinimisedChildren().add((Object)newDataViewerPane);
                    break;
                }
                default: {
                    view1.getVisibleChildren().add((Object)newDataViewerPane);
                }
            }
            newDataViewerPane.addListener(this.dataWindowEventListener);
            newDataViewerPane.addListener(windowEvent -> LOGGER.atInfo().addArgument((Object)newDataViewerPane.getName()).addArgument((Object)newDataViewerPane.getWindowState()).log("explicit '{}' window state is {}"));
            newDataViewerPane.closedProperty().addListener((ch, o, n) -> LOGGER.atInfo().log("newDataViewerPane Window '" + newDataViewerPane.getName() + "' has been closed - performing clean-up actions"));
            ChangeListener changeListener = (ch, o, n) -> LOGGER.atInfo().addArgument((Object)newDataViewerPane.isMinimised()).addArgument((Object)newDataViewerPane.isMaximised()).addArgument((Object)newDataViewerPane.isRestored()).addArgument((Object)newDataViewerPane.isDetached()).addArgument((Object)newDataViewerPane.isClosed()).log("minimised: {}, maximised {}, restored {}, detached {}, closed {}");
            newDataViewerPane.minimisedProperty().addListener(changeListener);
            newDataViewerPane.maximisedProperty().addListener(changeListener);
            newDataViewerPane.restoredProperty().addListener(changeListener);
            newDataViewerPane.detachedProperty().addListener(changeListener);
            newDataViewerPane.closedProperty().addListener(changeListener);
        });
        Label focusedOwner = new Label();
        viewer.getUserToolBarItems().addAll((Object[])new Node[]{newView, initialWindowState, new Label("Win-Decor:"), windowDecoration, detachableBox, listView});
        Scene scene = new Scene((Parent)new VBox(new Node[]{viewer.getToolBar(), viewer, new HBox(new Node[]{new Label("focus on: "), focusedOwner})}), 800.0, 600.0);
        scene.focusOwnerProperty().addListener((ch, o, n) -> {
            if (n == null) {
                focusedOwner.setText(null);
                return;
            }
            focusedOwner.setText(n.toString());
        });
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(evt -> System.exit(0));
    }

    private XYChart createChart() {
        TestChart chart = new TestChart();
        chart.getXAxis().set("time", new String[]{"s"});
        chart.getYAxis().set("y-axis", new String[]{"A"});
        RandomWalkFunction dataset1 = new RandomWalkFunction("Test1", 10000);
        RandomWalkFunction dataset2 = new RandomWalkFunction("Test2", 10000);
        RandomStepFunction dataset3 = new RandomStepFunction("Test3", 10000);
        chart.getRenderers().clear();
        chart.getRenderers().add((Object)new ErrorDataSetRenderer());
        chart.getDatasets().addAll(Arrays.asList(dataset1, dataset2, dataset3));
        UpdateTask updateTask = new UpdateTask(new TestDataSet[]{dataset1, dataset3});
        Timer timer = new Timer("sample-update-timer", true);
        timer.schedule((TimerTask)updateTask, 2000L, 1000L);
        return chart;
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private static DoubleDataSet createData(String name) {
        DoubleDataSet dataSet = new DoubleDataSet(name, 20);
        Random rnd = new Random();
        for (int i = 0; i < 20; ++i) {
            dataSet.set(i, (double)i, (double)(i * i) * rnd.nextDouble());
        }
        return dataSet;
    }

    private static List<DataSet> createSeries() {
        ArrayList<DataSet> series = new ArrayList<DataSet>();
        for (int i = 0; i < 2; ++i) {
            series.add((DataSet)DataViewerSample.createData("Series " + i));
        }
        return series;
    }

    private static Pane getDemoPane() {
        Rectangle rect = new Rectangle(-130.0, -40.0, 80.0, 80.0);
        rect.setFill((Paint)Color.BLUE);
        Circle circle = new Circle(0.0, 0.0, 40.0);
        circle.setFill((Paint)Color.GREEN);
        Polygon triangle = new Polygon(new double[]{60.0, -40.0, 120.0, 0.0, 50.0, 40.0});
        triangle.setFill((Paint)Color.RED);
        Group group = new Group(new Node[]{rect, circle, triangle});
        group.setTranslateX(300.0);
        group.setTranslateY(200.0);
        RotateTransition rotateTransition = new RotateTransition(Duration.millis((double)4000.0), (Node)group);
        rotateTransition.setByAngle(1080.0);
        rotateTransition.setCycleCount(-1);
        rotateTransition.setAutoReverse(true);
        rotateTransition.play();
        RotateTransition rotateTransition1 = new RotateTransition(Duration.millis((double)1000.0), (Node)rect);
        rotateTransition1.setByAngle(360.0);
        rotateTransition1.setCycleCount(-1);
        rotateTransition1.setAutoReverse(false);
        rotateTransition1.play();
        RotateTransition rotateTransition2 = new RotateTransition(Duration.millis((double)1000.0), (Node)triangle);
        rotateTransition2.setByAngle(360.0);
        rotateTransition2.setCycleCount(-1);
        rotateTransition2.setAutoReverse(false);
        rotateTransition2.play();
        group.setManaged(true);
        HBox.setHgrow((Node)group, (Priority)Priority.ALWAYS);
        HBox box = new HBox(new Node[]{group});
        VBox.setVgrow((Node)box, (Priority)Priority.ALWAYS);
        box.setId("demoPane");
        return box;
    }

    private static void logPropertyChange(BooleanProperty property, String name) {
        property.addListener((ch, o, n) -> LOGGER.atInfo().log("Property '{}' changed to '{}'", (Object)name, n));
    }

    private static void logStatePropertyChanges(String windowName, DataViewWindow currentView) {
        DataViewerSample.logPropertyChange(currentView.minimisedProperty(), windowName + " minimized");
        DataViewerSample.logPropertyChange(currentView.detachedProperty(), windowName + " detached");
        DataViewerSample.logPropertyChange(currentView.closedProperty(), windowName + " closed");
        DataViewerSample.logPropertyChange(currentView.restoredProperty(), windowName + " restored");
        DataViewerSample.logPropertyChange(currentView.maximisedProperty(), windowName + " maximized");
    }

    private class UpdateTask
    extends TimerTask {
        private final TestDataSet<?>[] dataSets;
        private int count;

        private UpdateTask(TestDataSet<?> ... dataSet) {
            this.dataSets = (TestDataSet[])dataSet.clone();
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            for (TestDataSet<?> dataSet : this.dataSets) {
                dataSet.update();
            }
            if (this.count % 10 == 0) {
                long diff = System.currentTimeMillis() - start;
                LOGGER.atDebug().log(String.format("update #%d took %d ms", this.count, diff));
            }
            this.count = (this.count + 1) % 1000;
        }
    }

    private class TestChart
    extends XYChart {
        private TestChart() {
            this.getPlugins().add((Object)new ParameterMeasurements());
            this.getPlugins().add((Object)new Zoomer());
            this.getPlugins().add((Object)new TableViewer());
            this.getPlugins().add((Object)new EditAxis());
        }
    }

    private static enum InitialWindowState {
        VISIBLE,
        MINIMISED,
        DETACHED;

    }
}

