/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.TableViewer;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DoubleDataSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartPerformanceGraph
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChartPerformanceGraph.class);
    private static final String FILE1 = "./testdata/ChartPerformanceBenchmark25Hz_V8.1.1_JDK8u112.csv";
    private static final String FILE2 = "./testdata/ChartPerformanceBenchmark25Hz_V11.1.1_JDK11_JFX13.csv";
    private static final String FILE3 = "./testdata/ChartPerformanceBenchmark25Hz_V11.1.2_JDK11_JFX13.csv";

    public void start(Stage primaryStage) {
        DataSet dataSet1 = ChartPerformanceGraph.loadData(FILE1);
        DataSet dataSet2 = ChartPerformanceGraph.loadData(FILE2);
        DataSet dataSet3 = ChartPerformanceGraph.loadData(FILE3);
        DefaultNumericAxis xAxis = new DefaultNumericAxis("number of samples", "");
        xAxis.setLogAxis(true);
        DefaultNumericAxis yAxis = new DefaultNumericAxis("CPU load", "%");
        yAxis.setForceZeroInRange(true);
        XYChart chart = new XYChart((Axis)xAxis, (Axis)yAxis);
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new TableViewer());
        chart.getPlugins().add((Object)new EditAxis());
        chart.getDatasets().addAll((Object[])new DataSet[]{dataSet1, dataSet2, dataSet3});
        Scene scene = new Scene((Parent)new StackPane(new Node[]{chart}), 800.0, 600.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private static DataSet loadData(String fileName) {
        String pathToCsv = ChartPerformanceGraph.class.getResource(fileName).toExternalForm();
        InputStream inputStream = ChartPerformanceGraph.class.getResourceAsStream(fileName);
        DoubleDataSet dataSet = new DoubleDataSet(fileName.replace(".csv", ""));
        try (BufferedReader csvReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
            String row;
            int lineCount = 0;
            while ((row = csvReader.readLine()) != null) {
                if (++lineCount <= 1) continue;
                String[] data = row.split(",");
                if (data[3] == null) break;
                if (data[4] == null) {
                    break;
                }
                double x = Double.parseDouble(data[3]);
                double y = Double.parseDouble(data[4]);
                dataSet.add(x, y);
            }
        }
        catch (IOException | NumberFormatException e) {
            LOGGER.atError().setCause((Throwable)e).addArgument((Object)fileName).addArgument((Object)pathToCsv).log("failed to open '{}' -> '{}'");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.atInfo().addArgument((Object)dataSet.getDataCount()).addArgument((Object)fileName).log("read {} data points from file '{}'");
        }
        return dataSet;
    }
}

