/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.silly.samples.plugins;

import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.Node;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;

public class SnowFlake
extends Path {
    private final DoubleProperty centerX = new SimpleDoubleProperty((Object)this, "centerX", 0.0){

        public void invalidated() {
            NodeHelper.markDirty((Node)SnowFlake.this, (DirtyBits)DirtyBits.NODE_GEOMETRY);
            NodeHelper.geomChanged((Node)SnowFlake.this);
            SnowFlake.this.setTranslateX(this.get() - SnowFlake.this.radius.get());
        }
    };
    private final DoubleProperty centerY = new SimpleDoubleProperty((Object)this, "centerY", 0.0){

        public void invalidated() {
            NodeHelper.markDirty((Node)SnowFlake.this, (DirtyBits)DirtyBits.NODE_GEOMETRY);
            NodeHelper.geomChanged((Node)SnowFlake.this);
            SnowFlake.this.setTranslateX(this.get() - SnowFlake.this.radius.get());
        }
    };
    private final DoubleProperty radius = new SimpleDoubleProperty((Object)this, "radius", 5.0){

        public void invalidated() {
            NodeHelper.markDirty((Node)SnowFlake.this, (DirtyBits)DirtyBits.NODE_GEOMETRY);
            NodeHelper.geomChanged((Node)SnowFlake.this);
            SnowFlake.this.updatePath();
        }
    };
    private final IntegerProperty nIterations = new SimpleIntegerProperty((Object)this, "nIterations", 3){

        public void invalidated() {
            NodeHelper.markDirty((Node)SnowFlake.this, (DirtyBits)DirtyBits.NODE_GEOMETRY);
            NodeHelper.geomChanged((Node)SnowFlake.this);
            SnowFlake.this.updatePath();
        }
    };
    private double xState;
    private double yState;
    private double angleState;

    public SnowFlake(double centerX, double centerY, double radius, int recursion, Paint fill) {
        this.setCenterX(centerX);
        this.setCenterY(centerY);
        this.setRadius(radius);
        this.setFill(fill);
        this.setRecursion(recursion);
        this.updatePath();
    }

    public SnowFlake(double radius, Paint fill) {
        this(0.0, 0.0, radius, 3, fill);
    }

    public final DoubleProperty centerXProperty() {
        return this.centerX;
    }

    public final DoubleProperty centerYProperty() {
        return this.centerY;
    }

    public final double getCenterX() {
        return this.centerX.get();
    }

    public final double getCenterY() {
        return this.centerY.get();
    }

    public final double getRadius() {
        return this.radius.get();
    }

    public final int getRecursion() {
        return this.nIterations.get();
    }

    public final DoubleProperty radiusProperty() {
        return this.radius;
    }

    public final IntegerProperty recursionProperty() {
        return this.nIterations;
    }

    public final void setCenterX(double value) {
        if (value != 0.0) {
            this.centerXProperty().set(value);
        }
    }

    public final void setCenterY(double value) {
        if (value != 0.0) {
            this.centerYProperty().set(value);
        }
    }

    public final void setRadius(double value) {
        this.radius.set(value);
    }

    public final void setRecursion(int value) {
        this.nIterations.set(value);
    }

    private void koch(int n, double size) {
        if (n == 0) {
            this.xState += size * Math.cos(Math.toRadians(this.angleState));
            this.yState += size * Math.sin(Math.toRadians(this.angleState));
            this.getElements().add((Object)new LineTo(this.xState, this.yState));
        } else {
            this.koch(n - 1, size);
            this.angleState += 60.0;
            this.koch(n - 1, size);
            this.angleState -= 120.0;
            this.koch(n - 1, size);
            this.angleState += 60.0;
            this.koch(n - 1, size);
        }
    }

    protected void updatePath() {
        this.getElements().clear();
        int n = Math.max(this.getRecursion(), 1);
        double flakeRadius = this.getRadius();
        double side = Math.abs(flakeRadius * Math.sqrt(3.0) / Math.pow(3.0, n));
        this.xState = 0.0;
        this.yState = 0.0;
        this.angleState = 0.0;
        this.getElements().add((Object)new MoveTo(flakeRadius, 0.0));
        for (int i = 0; i < 3; ++i) {
            this.koch(n, side);
            this.angleState -= 120.0;
        }
        this.getElements().add((Object)new LineTo(flakeRadius, 0.0));
        this.setTranslateX(this.getCenterX() - flakeRadius);
        this.setTranslateY(this.getCenterY() - flakeRadius);
    }
}

