/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.samples;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.math.TMath;
import de.gsi.math.TRandom;
import de.gsi.math.samples.utils.AbstractDemoApplication;
import de.gsi.math.samples.utils.DemoChart;
import de.gsi.math.spectra.SpectrumTools;
import de.gsi.math.spectra.dtft.DiscreteTimeFourierTransform;
import de.gsi.math.spectra.lomb.LombPeriodogram;
import java.util.Arrays;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import org.jtransforms.fft.DoubleFFT_1D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FourierSample
extends AbstractDemoApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(FourierSample.class);
    private static final int MAX_POINTS = 512;
    private DataSet fraw;
    private DataSet fspectra1;
    private DataSet fspectra2;
    private DataSet fspectra3;
    private DataSet fspectra4;
    private final TRandom rnd = new TRandom(0L);

    private double computeSignal(double t) {
        double val = 0.0;
        double error = this.rnd.Gaus(0.0, 0.2);
        val += TMath.Sin((double)(TMath.TwoPi() * 0.22 * t));
        val += Math.sin(TMath.TwoPi() * 3.0E-4 * t * t);
        val += Math.sin(TMath.TwoPi() * 0.05 * t);
        val += 0.8 * Math.sin(TMath.TwoPi() * (0.3 + 0.001 * TMath.Sin((double)(TMath.TwoPi() * 0.01 * t))) * t);
        return val += error;
    }

    @Override
    public Node getContent() {
        this.initData();
        DemoChart chart1 = new DemoChart();
        chart1.getXAxis().setName("time");
        chart1.getXAxis().setUnit("s");
        chart1.getYAxis().setName("magnitude");
        chart1.getYAxis().setUnit("a.u.");
        chart1.getDatasets().add((Object)this.fraw);
        DemoChart chart2 = new DemoChart();
        chart2.getXAxis().setName("frequency [fs]");
        chart2.getXAxis().setUnit("fs");
        chart2.getYAxis().setName("magnitude");
        chart2.getYAxis().setUnit("a.u.");
        chart2.getDatasets().addAll((Object[])new DataSet[]{this.fspectra1, this.fspectra2, this.fspectra3, this.fspectra4});
        return new VBox(new Node[]{chart1, chart2});
    }

    private void initData() {
        double[] xValues = new double[512];
        double[] yValues = new double[512];
        for (int i = 0; i < xValues.length; ++i) {
            xValues[i] = i;
            yValues[i] = this.computeSignal(xValues[i]);
        }
        this.fraw = new DefaultDataSet("raw data", xValues, yValues, xValues.length, true);
        double[] frequency1 = new double[yValues.length / 2];
        double scaling1 = 0.5 / (double)frequency1.length;
        for (int i = 0; i < frequency1.length; ++i) {
            frequency1[i] = (double)i * scaling1;
        }
        int nOverSampling = 4;
        double[] frequency2 = new double[4 * yValues.length / 2];
        double scaling2 = 0.5 / (double)frequency2.length;
        for (int i = 0; i < frequency2.length; ++i) {
            frequency2[i] = (double)i * scaling2;
        }
        int nOverSampling2 = 20;
        double[] frequency3 = new double[20 * yValues.length / 2];
        double scaling3 = 0.5 / (double)frequency3.length;
        for (int i = 0; i < frequency3.length; ++i) {
            frequency3[i] = (double)i * scaling3;
        }
        LombPeriodogram lombTrafo = new LombPeriodogram();
        DiscreteTimeFourierTransform trafoDTFT = new DiscreteTimeFourierTransform();
        DoubleFFT_1D fastFourierTrafo = new DoubleFFT_1D((long)yValues.length);
        LOGGER.atInfo().log("compute spectrum for %d test frequencies\n", (Object)frequency1.length);
        double[] lomb = lombTrafo.computePeridodogram(xValues, yValues, frequency2);
        double[] dtft1 = trafoDTFT.computeMagnitudeSpectrum(xValues, yValues, frequency1);
        double[] dtft2 = trafoDTFT.computeMagnitudeSpectrum(xValues, yValues, frequency2);
        double[] fftSpectra = Arrays.copyOf(yValues, yValues.length);
        fastFourierTrafo.realForward(fftSpectra);
        fftSpectra = SpectrumTools.interpolateSpectrum((double[])fftSpectra, (int)20);
        double[] mag = SpectrumTools.computeMagnitudeSpectrum((double[])fftSpectra, (boolean)true);
        this.fspectra1 = new DefaultDataSet("Lomb-spectra equidistant sampling", frequency2, lomb, frequency2.length, true);
        this.fspectra1.setStyle("strokeWidth=0.5");
        this.fspectra2 = new DefaultDataSet("DT-FourierTransform spectra", frequency1, dtft1, frequency1.length, true);
        this.fspectra3 = new DefaultDataSet("int. DT-FourierTransform spectra", frequency2, dtft2, frequency2.length, true);
        LOGGER.atInfo().log("dim %d vs %d\n", (Object)frequency2.length, (Object)mag.length);
        this.fspectra4 = new DefaultDataSet("interpolated FFT", frequency3, mag, frequency3.length, true);
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

