/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.samples;

import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.math.DataSetMath;
import de.gsi.math.functions.GaussianFunction;
import de.gsi.math.samples.utils.AbstractDemoApplication;
import de.gsi.math.samples.utils.DemoChart;
import javafx.application.Application;
import javafx.scene.Node;

public class DataSetIntegrationWithLimitsSample
extends AbstractDemoApplication {
    private static final int N_SAMPLES = 41;

    @Override
    public Node getContent() {
        DemoChart chart = new DemoChart();
        chart.getRenderer(0).setDrawMarker(true);
        chart.getRenderer(0).setErrorType(ErrorStyle.ERRORSURFACE);
        GaussianFunction gaussFunction = new GaussianFunction("gauss"){

            public double getValue(double x) {
                return super.getValue(x) + 0.0 * RANDOM.nextGaussian();
            }
        };
        gaussFunction.setParameterValue(0, 0.0);
        gaussFunction.setParameterValue(1, 0.8);
        gaussFunction.setParameterValue(2, 1.0);
        DataSet dataSet = gaussFunction.getDataSetEstimate(-10.0, 10.0, 41);
        dataSet.setStyle("strokeColor=darkblue;fillColor=darkblue;strokeWidth=0.5");
        if (dataSet instanceof DoubleErrorDataSet) {
            DoubleErrorDataSet ds = (DoubleErrorDataSet)dataSet;
            for (int i = 0; i < ds.getDataCount(); ++i) {
                double x = ds.getX(i);
                double y = ds.getY(i);
                ds.set(i, x, y, 0.05, 0.05);
            }
        }
        chart.getRenderer(0).getDatasets().add((Object)dataSet);
        DataSet integral = DataSetMath.integrateFunction((DataSet)dataSet);
        integral.setStyle("strokeColor=red;fillColor=red;strokeWidth=1");
        chart.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{integral});
        DataSet derivative = DataSetMath.integrateFunction((DataSet)dataSet, (double)0.0, (double)15.0);
        derivative.setStyle("strokeColor=darkgreen;fillColor=darkgreen;strokeWidth=1");
        chart.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{derivative});
        DataSet control = DataSetMath.integrateFunction((DataSet)dataSet, (double)-15.0, (double)0.0);
        control.setStyle("strokeColor=cyan;fillColor=cyan;strokeWidth=1");
        chart.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{control});
        return chart;
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

