/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples.utils;

import de.gsi.chart.samples.utils.MidiWaveformSynthesizer;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.spi.AbstractDataSet3D;
import de.gsi.dataset.utils.DoubleCircularBuffer;
import de.gsi.math.ArrayUtils;
import de.gsi.math.spectra.Apodization;
import de.gsi.math.spectra.SpectrumTools;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import java.io.IOException;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import org.jtransforms.fft.FloatFFT_1D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataSetSource
extends AbstractDataSet3D<TestDataSetSource> {
    private static final long serialVersionUID = 5374805363297317245L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TestDataSetSource.class);
    private static final String DATA_SOURCE_FILE = "../testdata/alla-turca.mid";
    private static final int AUDIO_SAMPLING_RATE = 11000;
    private static final int N_SYNTHESISER_BITS = 16;
    private static final int INITIAL_FRAME_SIZE = 1024;
    private static final int INITIAL_FRAME_COUNT = 1000;
    private static final int CIRCULAR_BUFFER_SIZE = 16384;
    protected transient MidiWaveformSynthesizer synth = new MidiWaveformSynthesizer("../testdata/alla-turca.mid", 16384);
    protected transient TargetDataLine line;
    protected transient DoubleCircularBuffer lineBuffer = new DoubleCircularBuffer(16384);
    protected FloatArrayList[] history = new FloatArrayList[]{new FloatArrayList(1024), new FloatArrayList(1000), new FloatArrayList(1024000)};
    protected transient FloatArrayList frame = new FloatArrayList(1024);
    protected int circIndex = 0;
    protected int samplingRate = 11000;
    protected int frameSize = 1024;
    protected int frameCount = 1000;
    protected int updatePeriod = 40;
    private DataInput inputSource = DataInput.BOTH;
    protected volatile boolean running;
    protected volatile boolean paused;
    protected transient Timer updateTimer;
    protected transient Timer audioTimer;
    protected transient TimerTask traskAudioIO;
    protected transient TimerTask traskDataUpdate;

    public TestDataSetSource() {
        super(TestDataSetSource.class.getSimpleName());
        this.reinitializeData();
        this.fillTestData();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().addArgument((Object)TestDataSetSource.class.getSimpleName()).log("initialised '{}'");
        }
    }

    protected void openLineIn() {
        AudioFormat format = new AudioFormat(this.samplingRate, 16, 1, true, true);
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
        if (!AudioSystem.isLineSupported(info)) {
            LOGGER.atError().addArgument((Object)info).addArgument((Object)format).log("Line not supported '{}' format was '{}'");
            throw new IllegalArgumentException("Line not supported");
        }
        try {
            this.line = (TargetDataLine)AudioSystem.getLine(info);
            this.line.open(format);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.atInfo().log("opened audio line-in, format = " + format);
            }
        }
        catch (LineUnavailableException e) {
            LOGGER.atError().setCause((Throwable)e).addArgument((Object)DATA_SOURCE_FILE).log("'{}' does not seem to be recognised as a Midi file");
        }
    }

    public void fillTestData() {
        this.lock().writeLockGuard(() -> this.synth.decode(this.history[2].elements(), this.frameSize, this.updatePeriod, this.samplingRate, 16));
    }

    public double get(int dimIndex, int index) {
        if (dimIndex <= 1) {
            return this.history[dimIndex].elements()[index];
        }
        return this.history[dimIndex].elements()[(index + this.circIndex) % (this.frameSize * this.frameCount)];
    }

    public int getDataCount(int dimIndex) {
        return this.history[dimIndex].size();
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public DataInput getInputSource() {
        return this.inputSource;
    }

    public int getSamplingRate() {
        return this.samplingRate;
    }

    public int getUpdatePeriod() {
        return this.updatePeriod;
    }

    public double getValue(int dimIndex, double x) {
        return 0.0;
    }

    public double getZ(int xIndex, int yIndex) {
        int index = yIndex * this.frameSize + xIndex;
        return this.history[2].elements()[(index + this.circIndex) % (this.frameSize * this.frameCount)];
    }

    public boolean isOutputMuted() {
        return this.synth.isOutputMuted();
    }

    public void pause() {
        this.paused = true;
        this.line.stop();
        this.synth.pause();
    }

    public void reset() {
        this.synth.reset();
    }

    public void setFrameCount(int frameCount) {
        if (this.frameCount == frameCount || frameCount < 2) {
            return;
        }
        this.frameCount = frameCount;
        this.reinitializeData();
    }

    public void setFrameSize(int frameSize) {
        if (this.frameSize == frameSize || frameSize < 4) {
            return;
        }
        this.frameSize = frameSize;
        this.reinitializeData();
    }

    public void setInputSource(DataInput inputSource) {
        this.inputSource = inputSource;
    }

    public void setOutputMuted(boolean state) {
        this.synth.setOutputMuted(state);
    }

    public void setSamplingRate(int samplingRate) {
        this.samplingRate = samplingRate;
    }

    public void setUpdatePeriod(int updatePeriod) {
        if (this.updatePeriod == updatePeriod || updatePeriod <= 0) {
            return;
        }
        this.updatePeriod = updatePeriod;
        this.reinitializeData();
    }

    public void start() {
        this.paused = false;
        this.synth.start();
        if (this.audioTimer != null) {
            this.audioTimer.cancel();
            this.traskAudioIO.cancel();
            this.audioTimer = null;
        }
        if (this.updateTimer != null) {
            this.updateTimer.cancel();
            this.updateTimer = null;
        }
        this.audioTimer = new Timer(TestDataSetSource.class.getSimpleName() + "-Audio", true);
        this.traskAudioIO = this.getAudioTimerTask();
        this.audioTimer.schedule(this.traskAudioIO, 0L);
        this.updateTimer = new Timer(TestDataSetSource.class.getSimpleName() + "-Data", true);
        this.traskDataUpdate = this.getDataUpdateTask();
        this.updateTimer.scheduleAtFixedRate(this.traskDataUpdate, this.updatePeriod, (long)this.updatePeriod);
    }

    public void step() {
        TimerTask step = this.getDataUpdateTask();
        if (step == null) {
            step = this.getDataUpdateTask();
        }
        step.run();
    }

    public void stop() {
        if (this.audioTimer != null) {
            this.audioTimer.cancel();
        }
        if (this.updateTimer != null) {
            this.updateTimer.cancel();
        }
        this.audioTimer = null;
        this.updateTimer = null;
        this.running = false;
        this.paused = false;
        this.synth.stop();
    }

    protected TimerTask getAudioTimerTask() {
        return new TimerTask(){

            @Override
            public void run() {
                if (TestDataSetSource.this.line == null || !TestDataSetSource.this.line.isOpen()) {
                    TestDataSetSource.this.openLineIn();
                }
                TestDataSetSource.this.line.start();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.atInfo().log("started audio line-in");
                }
                TestDataSetSource.this.running = true;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.atDebug().log("Start recording...");
                }
                int nAudioSamples = 1100;
                byte[] buffer = new byte[2200];
                try (AudioInputStream ais = new AudioInputStream(TestDataSetSource.this.line);){
                    int ret;
                    while ((ret = ais.read(buffer)) != 0 && TestDataSetSource.this.running) {
                        for (int i = 0; i < 1100; ++i) {
                            TestDataSetSource.this.synth.update(TestDataSetSource.this.samplingRate, 16);
                            int value = buffer[2 * i] << 8 | buffer[2 * i + 1] & 0xFF;
                            TestDataSetSource.this.lineBuffer.put((double)value);
                        }
                    }
                    TestDataSetSource.this.line.stop();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.atInfo().log("closed audio line-in");
                    }
                }
                catch (IOException e) {
                    LOGGER.atError().setCause((Throwable)e).log("issue in audio IO loop");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.atDebug().log("stop recording...");
                }
            }
        };
    }

    protected TimerTask getDataUpdateTask() {
        final float[] waveform = new float[2 * this.frameSize];
        final FloatFFT_1D fft = new FloatFFT_1D((long)waveform.length);
        final float[] apodisation = new float[2 * this.frameSize];
        for (int i = 0; i < apodisation.length; ++i) {
            apodisation[i] = (float)Apodization.Hann.getIndex(i, 2 * this.frameSize);
        }
        return new TimerTask(){

            @Override
            public void run() {
                switch (TestDataSetSource.this.getInputSource()) {
                    case MIDI: {
                        int i;
                        for (i = 0; i < waveform.length; ++i) {
                            waveform[i] = apodisation[i] * (float)TestDataSetSource.this.synth.getBuffer().get(i);
                        }
                        break;
                    }
                    case LINE: {
                        int i;
                        for (i = 0; i < waveform.length; ++i) {
                            waveform[i] = apodisation[i] * (float)TestDataSetSource.this.lineBuffer.get(i);
                        }
                        break;
                    }
                    default: {
                        int i;
                        for (i = 0; i < waveform.length; ++i) {
                            waveform[i] = apodisation[i] * (float)(TestDataSetSource.this.lineBuffer.get(i) + TestDataSetSource.this.synth.getBuffer().get(i));
                        }
                    }
                }
                fft.realForward(waveform);
                float[] mag = SpectrumTools.computeMagnitudeSpectrum_dB((float[])waveform, (boolean)true);
                TestDataSetSource.this.lock().writeLockGuard(() -> {
                    System.arraycopy(mag, 0, TestDataSetSource.this.frame.elements(), 0, TestDataSetSource.this.frameSize);
                    System.arraycopy(mag, 0, TestDataSetSource.this.history[2].elements(), TestDataSetSource.this.circIndex, TestDataSetSource.this.frameSize);
                    TestDataSetSource.this.circIndex = (TestDataSetSource.this.circIndex + TestDataSetSource.this.frameSize) % (TestDataSetSource.this.frameSize * TestDataSetSource.this.frameCount);
                });
                TestDataSetSource.this.fireInvalidated((UpdateEvent)new AddedDataEvent((EventSource)TestDataSetSource.this, "new frame"));
            }
        };
    }

    protected void reinitializeData() {
        int i;
        this.frame.size(this.frameSize);
        this.history[0].size(this.frameSize);
        this.history[1].size(this.frameCount);
        this.history[2].size(this.frameSize * this.frameCount);
        this.circIndex = 100 * this.frameSize;
        for (i = 0; i < this.frameSize; ++i) {
            this.history[0].elements()[i] = 0.5f * (float)i / (float)this.frameSize * (float)this.samplingRate;
        }
        for (i = 0; i < this.frameCount; ++i) {
            this.history[1].elements()[i] = -0.001f * (float)this.updatePeriod * (float)(this.frameCount - 1 - i);
        }
        Arrays.fill(this.frame.elements(), 0.0f);
        ArrayUtils.fillArray((float[])this.history[2].elements(), (float)0.0f);
        this.synth.setBufferLength(2 * this.frameSize);
        this.lineBuffer = new DoubleCircularBuffer(2 * this.frameSize);
        if (this.traskDataUpdate != null) {
            this.start();
        }
    }

    public static void main(String[] args) throws InterruptedException {
        TestDataSetSource dataSource = new TestDataSetSource();
        dataSource.start();
        Thread.sleep(5000L);
        dataSource.stop();
        Thread.sleep(5000L);
        dataSource.start();
    }

    public static enum DataInput {
        BOTH,
        MIDI,
        LINE;

    }
}

