/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples.legacy.utils;

import de.gsi.chart.samples.legacy.RollingBufferLegacySample;
import de.gsi.chart.samples.legacy.utils.AbstractTestApplication;
import de.gsi.chart.samples.legacy.utils.ChartTestCase;
import de.gsi.dataset.testdata.spi.SineFunction;
import java.util.ArrayList;
import java.util.Collection;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;

public class JavaFXTestChart
extends AbstractTestApplication
implements ChartTestCase {
    protected int nSamples = 100000;
    protected SineFunction testFunction = new SineFunction("test", this.nSamples, true);
    NumberAxis xAxis = new NumberAxis();
    NumberAxis yAxis = new NumberAxis("irrelevant y-axis - JavaFX Chart", -1.1, 1.1, 0.2);
    protected final LineChart<Number, Number> lineChart;
    protected XYChart.Series<Number, Number> series1 = new XYChart.Series();

    public JavaFXTestChart() {
        this.xAxis.setLabel("x-axis (JavaFX Chart)");
        this.xAxis.setAutoRanging(false);
        this.yAxis.setAutoRanging(false);
        this.yAxis.setLowerBound(-1.1);
        this.yAxis.setUpperBound(1.1);
        this.lineChart = new LineChart<Number, Number>((Axis)this.xAxis, (Axis)this.yAxis){

            protected void dataItemAdded(XYChart.Series<Number, Number> series, int itemIndex, XYChart.Data<Number, Number> item) {
            }
        };
        this.lineChart.setAnimated(false);
        this.lineChart.setHorizontalGridLinesVisible(true);
        this.lineChart.setVerticalGridLinesVisible(true);
        this.lineChart.setCreateSymbols(false);
        this.lineChart.getXAxis().setAnimated(false);
        this.lineChart.getYAxis().setAnimated(false);
        this.lineChart.setHorizontalZeroLineVisible(false);
        this.lineChart.getStylesheets().add((Object)RollingBufferLegacySample.class.getResource("RollingBufferLegacy.css").toExternalForm());
        this.series1.setName("test data [a.u.]");
        this.lineChart.getData().add(this.series1);
        this.lineChart.setLegendVisible(false);
        this.setNumberOfSamples(1000);
        this.updateDataSet();
    }

    @Override
    public Node getChart(int nSamples) {
        return this.lineChart;
    }

    @Override
    public void initChart() {
        test = new JavaFXTestChart();
    }

    @Override
    public void setNumberOfSamples(int nSamples) {
        this.nSamples = nSamples;
        this.testFunction = new SineFunction("test", nSamples, true);
        this.xAxis.setUpperBound((double)nSamples - 1.0);
        this.xAxis.setLowerBound(0.0);
        this.xAxis.setTickUnit((double)nSamples / 20.0);
        this.updateDataSet();
    }

    @Override
    public void updateDataSet() {
        double[] x = this.testFunction.generateX(this.nSamples);
        double[] y = this.testFunction.generateY(this.nSamples);
        ArrayList<XYChart.Data> newData = new ArrayList<XYChart.Data>();
        for (int i = 0; i < this.nSamples; ++i) {
            newData.add(new XYChart.Data((Object)x[i], (Object)y[i]));
        }
        Platform.runLater(() -> this.series1.getData().setAll((Collection)newData));
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

