/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.AxisMode;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.dataset.testdata.spi.RandomDataGenerator;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.layout.FlowPane;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoomerSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZoomerSample.class);
    private static final int PREF_WIDTH = 600;
    private static final int PREF_HEIGHT = 300;
    private static final int N_SAMPLES = 1000000;

    public void start(Stage primaryStage) {
        FlowPane root = new FlowPane();
        root.setAlignment(Pos.CENTER);
        DataSet testDataSet = ZoomerSample.generateData();
        Label label = new Label("left-click-hold-drag for zooming. middle-button for panning.\nTip: drag horizontally/vertically/diagonally for testing; try to select the outlier");
        label.setFont(Font.font((double)20.0));
        label.setAlignment(Pos.CENTER);
        label.setContentDisplay(ContentDisplay.CENTER);
        label.setPrefWidth(1200.0);
        Chart chart1 = ZoomerSample.getTestChart("default zoom", testDataSet);
        Zoomer zoomer1 = new Zoomer();
        ZoomerSample.registerZoomerChangeListener(zoomer1, chart1.getTitle());
        chart1.getPlugins().add((Object)zoomer1);
        Chart chart2 = ZoomerSample.getTestChart("auto xy zoom", testDataSet);
        Zoomer zoomer2 = new Zoomer();
        zoomer2.setAutoZoomEnabled(true);
        ZoomerSample.registerZoomerChangeListener(zoomer2, chart2.getTitle());
        chart2.getPlugins().add((Object)zoomer2);
        Chart chart3 = ZoomerSample.getTestChart("x-only zoom", testDataSet);
        Zoomer zoomer3 = new Zoomer(AxisMode.X);
        ZoomerSample.registerZoomerChangeListener(zoomer3, chart3.getTitle());
        chart3.getPlugins().add((Object)zoomer3);
        Chart chart4 = ZoomerSample.getTestChart("y-only zoom", testDataSet);
        Zoomer zoomer4 = new Zoomer(AxisMode.Y);
        ZoomerSample.registerZoomerChangeListener(zoomer4, chart4.getTitle());
        chart4.getPlugins().add((Object)zoomer4);
        root.getChildren().addAll((Object[])new Node[]{chart1, chart2, chart3, chart4, label});
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(new Scene((Parent)root));
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.show();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private static DataSet generateData() {
        DoubleErrorDataSet dataSet = new DoubleErrorDataSet("test data");
        dataSet.lock().writeLockGuard(() -> {
            dataSet.clearData();
            double oldY = 0.0;
            for (int n = 0; n < 1000000; ++n) {
                double x = n;
                double y = (oldY += RandomDataGenerator.random() - 0.5) + (n == 500000 ? 500.0 : 0.0);
                double ex = 0.1;
                double ey = 10.0;
                dataSet.add(x, y, 0.1, 10.0);
                if (n != 500000) continue;
                dataSet.getDataLabelMap().put((Object)n, (Object)"special outlier");
            }
            dataSet.autoNotification().set(true);
        });
        dataSet.fireInvalidated((UpdateEvent)new AddedDataEvent((EventSource)dataSet));
        return dataSet;
    }

    private static Chart getTestChart(String title, DataSet testDataSet) {
        XYChart chart = new XYChart();
        chart.setTitle(title);
        chart.setLegendVisible(false);
        chart.getDatasets().add((Object)testDataSet);
        chart.setPrefSize(600.0, 300.0);
        return chart;
    }

    private static void registerZoomerChangeListener(Zoomer zoomer, String chart) {
        zoomer.zoomStackDeque().addListener(change -> {
            while (change.next()) {
                List removed;
                List added = change.getAddedSubList();
                if (added != null) {
                    added.forEach(ch -> ch.forEach((a, s) -> LOGGER.atInfo().addArgument((Object)chart).addArgument((Object)a.getSide()).addArgument(s).log("chart '{}' - axis {} -> new zoomState = {}")));
                }
                if ((removed = change.getRemoved()) == null) continue;
                removed.forEach(ch -> ch.forEach((a, s) -> LOGGER.atInfo().addArgument((Object)chart).addArgument((Object)a.getSide()).addArgument(s).log("chart '{}' - axis {} -> removed zoomState = {}")));
            }
        });
    }
}

