/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisLabelOverlapPolicy;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.DataPointTooltip;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.dataset.spi.DefaultErrorDataSet;
import de.gsi.dataset.utils.ProcessingProfiler;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;

public class TimeAxisSample
extends Application {
    private static final int N_SAMPLES = 10000;

    private void generateData(DefaultErrorDataSet dataSet) {
        long startTime = ProcessingProfiler.getTimeStamp();
        dataSet.autoNotification().set(false);
        dataSet.clearData();
        double now = (double)System.currentTimeMillis() / 1000.0 + 1.0;
        for (int n = 0; n < 10000; ++n) {
            double t = now + (double)(n * 10);
            double y = 100.0 * Math.cos(Math.PI * (t *= 1.0) * 5.0E-4) + 0.0 * (t - now) + 0.0;
            double ex = 0.1;
            double ey = 10.0;
            dataSet.add(t, y, 0.1, 10.0);
        }
        dataSet.autoNotification().set(true);
        Platform.runLater(() -> dataSet.fireInvalidated(null));
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data into DataSet");
    }

    public void start(Stage primaryStage) {
        ProcessingProfiler.setVerboseOutputState((boolean)true);
        ProcessingProfiler.setLoggerOutputState((boolean)true);
        ProcessingProfiler.setDebugState((boolean)false);
        BorderPane root = new BorderPane();
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        DefaultNumericAxis xAxis1 = new DefaultNumericAxis("time", "iso");
        xAxis1.setOverlapPolicy(AxisLabelOverlapPolicy.SKIP_ALT);
        DefaultNumericAxis yAxis1 = new DefaultNumericAxis("y-axis", "a.u.");
        XYChart chart = new XYChart((Axis)xAxis1, (Axis)yAxis1);
        chart.legendVisibleProperty().set(true);
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new EditAxis());
        chart.getPlugins().add((Object)new DataPointTooltip());
        chart.setAnimated(false);
        xAxis1.setAutoRangeRounding(false);
        xAxis1.setTimeAxis(true);
        yAxis1.setAutoRangeRounding(true);
        DefaultErrorDataSet dataSet = new DefaultErrorDataSet("TestData");
        this.generateData(dataSet);
        long startTime = ProcessingProfiler.getTimeStamp();
        chart.getDatasets().add((Object)dataSet);
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data to chart");
        startTime = ProcessingProfiler.getTimeStamp();
        root.setCenter((Node)chart);
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding chart into StackPane");
        startTime = ProcessingProfiler.getTimeStamp();
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.show();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"for showing");
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

