/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.Chart;
import de.gsi.chart.axes.AxisLabelOverlapPolicy;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.axes.spi.format.DefaultTimeTickUnitSupplier;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class TimeAxisRangeSample
extends Application {
    private static final String CHART_CSS = Chart.class.getResource("chart.css").toExternalForm();

    public void start(Stage primaryStage) {
        double[] ranges;
        final double now = (double)System.currentTimeMillis() / 1000.0;
        VBox root = new VBox();
        root.setAlignment(Pos.CENTER);
        TimeAxis xAxis1 = new TimeAxis("standard time axis", now - 3600.0, now, 360.0);
        root.getChildren().add((Object)xAxis1);
        TimeAxis xAxis2 = new TimeAxis("inverted time axis", now - 3600.0, now, 360.0);
        xAxis2.invertAxis(true);
        root.getChildren().add((Object)xAxis2);
        for (double range : ranges = new double[]{0.1, 1.0, 10.0, 30.0, 3600.0, 86400.0, 8035200.0, 1.60704E8}) {
            TimeAxis axis = new TimeAxis("time axis - range = " + range + " s", now - range, now, range / 10.0);
            root.getChildren().add((Object)axis);
        }
        final TimeAxis xAxisDyn = new TimeAxis("dynamic time axis", now - 0.001, now, 1.0);
        xAxisDyn.setMinorTickCount(10);
        xAxisDyn.setAutoRangeRounding(false);
        root.getChildren().add((Object)xAxisDyn);
        final Label xAxis9Text = new Label();
        root.getChildren().add((Object)xAxis9Text);
        Timer timer = new Timer("sample-update-timer", true);
        TimerTask task = new TimerTask(){
            private int counter;
            private boolean directionUpwards = true;

            @Override
            public void run() {
                this.counter = this.directionUpwards ? ++this.counter : --this.counter;
                Platform.runLater(() -> {
                    double range = DefaultTimeTickUnitSupplier.TICK_UNIT_DEFAULTS[this.counter];
                    xAxisDyn.minProperty().set(now - range);
                    String text = "actual range [s]: " + String.format("%#.3f", range) + " (" + String.format("%#.1f", range / 3600.0 / 24.0) + " days)";
                    xAxisDyn.setTickUnit(range / 10.0);
                    xAxisDyn.forceRedraw();
                    xAxis9Text.setText(text);
                });
                if (this.counter >= DefaultTimeTickUnitSupplier.TICK_UNIT_DEFAULTS.length - 1 || this.counter <= 0) {
                    this.directionUpwards = !this.directionUpwards;
                }
            }
        };
        timer.scheduleAtFixedRate(task, 0L, TimeUnit.SECONDS.toMillis(2L));
        Scene scene = new Scene((Parent)root, 800.0, 900.0);
        scene.getStylesheets().setAll((Object[])new String[]{CHART_CSS});
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.show();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    protected class TimeAxis
    extends DefaultNumericAxis {
        public TimeAxis(String label, double min, double max, double tick) {
            super(label, min, max, tick);
            this.setAutoRangeRounding(true);
            this.setTimeAxis(true);
            this.setOverlapPolicy(AxisLabelOverlapPolicy.SHIFT_ALT);
            VBox.setMargin((Node)this, (Insets)new Insets(5.0, 50.0, 30.0, 50.0));
            VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
        }
    }
}

