/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.axes.spi.format.DefaultTimeFormatter;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.datareduction.DefaultDataReducer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.samples.ProfilerInfoBox;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.spi.CircularDoubleErrorDataSet;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.time.ZoneOffset;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingBufferSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(RollingBufferSample.class);
    public static final int DEBUG_UPDATE_RATE = 500;
    protected static final int MIN_PIXEL_DISTANCE = 0;
    public static int N_SAMPLES = 3000;
    public static int UPDATE_PERIOD = 40;
    public static int BUFFER_CAPACITY = 750;
    public final CircularDoubleErrorDataSet rollingBufferDipoleCurrent = new CircularDoubleErrorDataSet("dipole current [A]", BUFFER_CAPACITY);
    public final CircularDoubleErrorDataSet rollingBufferBeamIntensity = new CircularDoubleErrorDataSet("beam intensity [ppp]", BUFFER_CAPACITY);
    private final ErrorDataSetRenderer beamIntensityRenderer = new ErrorDataSetRenderer();
    private final ErrorDataSetRenderer dipoleCurrentRenderer = new ErrorDataSetRenderer();
    private final DefaultNumericAxis yAxis1 = new DefaultNumericAxis("beam intensity", "ppp");
    private final DefaultNumericAxis yAxis2 = new DefaultNumericAxis("dipole current", "A");
    protected Timer[] timer;

    private void generateBeamIntensityData() {
        long startTime = ProcessingProfiler.getTimeStamp();
        double now = (double)System.currentTimeMillis() / 1000.0 + 1.0;
        if (this.rollingBufferBeamIntensity.getDataCount() == 0) {
            boolean oldState = this.rollingBufferBeamIntensity.autoNotification().getAndSet(false);
            for (int n = N_SAMPLES; n >= 0; --n) {
                double t = now - (double)(n * UPDATE_PERIOD) / 1000.0;
                double y = 100.0 * RollingBufferSample.rampFunctionBeamIntensity(t);
                double ey = 1.0;
                this.rollingBufferBeamIntensity.add(t, y, 1.0, 1.0);
            }
            this.rollingBufferBeamIntensity.autoNotification().set(oldState);
            this.rollingBufferBeamIntensity.fireInvalidated((UpdateEvent)new AddedDataEvent((EventSource)this.rollingBufferBeamIntensity));
        } else {
            double t = now;
            double y2 = 100.0 * RollingBufferSample.rampFunctionBeamIntensity(t);
            double ey = 1.0;
            this.rollingBufferBeamIntensity.add(t, y2, 1.0, 1.0);
        }
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data into DataSet");
    }

    private void generateDipoleCurrentData() {
        long startTime = ProcessingProfiler.getTimeStamp();
        double now = (double)System.currentTimeMillis() / 1000.0 + 1.0;
        if (this.rollingBufferDipoleCurrent.getDataCount() == 0) {
            boolean oldState = this.rollingBufferDipoleCurrent.autoNotification().getAndSet(false);
            for (int n = N_SAMPLES; n >= 0; --n) {
                double t = now - (double)(n * UPDATE_PERIOD) / 1000.0;
                double y = 25.0 * RollingBufferSample.rampFunctionDipoleCurrent(t);
                double ey = 1.0;
                this.rollingBufferDipoleCurrent.add(t, y, 1.0, 1.0);
            }
            this.rollingBufferDipoleCurrent.autoNotification().set(oldState);
            this.rollingBufferDipoleCurrent.fireInvalidated((UpdateEvent)new AddedDataEvent((EventSource)this.rollingBufferDipoleCurrent));
        } else {
            double t = now;
            double y = 25.0 * RollingBufferSample.rampFunctionDipoleCurrent(t);
            double ey = 1.0;
            this.rollingBufferDipoleCurrent.add(t, y, 1.0, 1.0);
        }
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data into DataSet");
    }

    private HBox getHeaderBar(Scene scene) {
        Button newDataSet = new Button("new DataSet");
        newDataSet.setOnAction(evt -> {
            this.getTask(0).run();
            this.getTask(1).run();
        });
        Button startTimer = new Button("timer");
        startTimer.setOnAction(evt -> {
            if (this.timer == null) {
                this.timer = new Timer[2];
                this.timer[0] = new Timer("sample-update-timer", true);
                this.rollingBufferBeamIntensity.reset();
                this.timer[0].scheduleAtFixedRate(this.getTask(0), 0L, (long)UPDATE_PERIOD);
                this.timer[1] = new Timer("sample-update-timer", true);
                this.rollingBufferDipoleCurrent.reset();
                this.timer[1].scheduleAtFixedRate(this.getTask(1), 0L, (long)UPDATE_PERIOD);
            } else {
                this.timer[0].cancel();
                this.timer[1].cancel();
                this.timer = null;
            }
        });
        Region spacer = new Region();
        spacer.setMinWidth(Double.NEGATIVE_INFINITY);
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        return new HBox(new Node[]{newDataSet, startTimer, spacer, new ProfilerInfoBox(scene, 500)});
    }

    protected TimerTask getTask(final int updateItem) {
        return new TimerTask(){
            private int updateCount;

            @Override
            public void run() {
                if (updateItem == 0) {
                    RollingBufferSample.this.generateBeamIntensityData();
                } else {
                    RollingBufferSample.this.generateDipoleCurrentData();
                }
                if (this.updateCount % 20 == 0 && LOGGER.isDebugEnabled()) {
                    LOGGER.atDebug().addArgument((Object)this.updateCount).log("update iteration #{}");
                }
                ++this.updateCount;
            }
        };
    }

    public BorderPane initComponents(Scene scene) {
        BorderPane root = new BorderPane();
        this.generateBeamIntensityData();
        this.generateDipoleCurrentData();
        this.initErrorDataSetRenderer(this.beamIntensityRenderer);
        this.initErrorDataSetRenderer(this.dipoleCurrentRenderer);
        DefaultNumericAxis xAxis1 = new DefaultNumericAxis("time");
        xAxis1.setAutoRangeRounding(false);
        xAxis1.setTickLabelRotation(45.0);
        xAxis1.setMinorTickCount(30);
        xAxis1.invertAxis(false);
        xAxis1.setTimeAxis(true);
        this.yAxis2.setSide(Side.RIGHT);
        this.yAxis2.setAnimated(false);
        this.dipoleCurrentRenderer.getAxes().add((Object)this.yAxis2);
        XYChart chart = new XYChart((Axis)xAxis1, (Axis)this.yAxis1);
        chart.legendVisibleProperty().set(true);
        chart.setAnimated(false);
        chart.getRenderers().set(0, (Object)this.beamIntensityRenderer);
        chart.getRenderers().add((Object)this.dipoleCurrentRenderer);
        chart.getPlugins().add((Object)new EditAxis());
        this.beamIntensityRenderer.getDatasets().add((Object)this.rollingBufferBeamIntensity);
        this.dipoleCurrentRenderer.getDatasets().add((Object)this.rollingBufferDipoleCurrent);
        if (xAxis1.isTimeAxis() && xAxis1.getAxisLabelFormatter() instanceof DefaultTimeFormatter) {
            DefaultTimeFormatter axisFormatter = (DefaultTimeFormatter)xAxis1.getAxisLabelFormatter();
            axisFormatter.setTimeZoneOffset(ZoneOffset.UTC);
            axisFormatter.setTimeZoneOffset(ZoneOffset.ofHoursMinutes(5, 0));
        }
        this.yAxis1.setForceZeroInRange(true);
        this.yAxis2.setForceZeroInRange(true);
        this.yAxis1.setAutoRangeRounding(true);
        this.yAxis2.setAutoRangeRounding(true);
        root.setTop((Node)this.getHeaderBar(scene));
        long startTime = ProcessingProfiler.getTimeStamp();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data to chart");
        startTime = ProcessingProfiler.getTimeStamp();
        root.setCenter((Node)chart);
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding chart into StackPane");
        return root;
    }

    protected void initErrorDataSetRenderer(ErrorDataSetRenderer eRenderer) {
        eRenderer.setErrorType(ErrorStyle.ERRORSURFACE);
        eRenderer.setErrorType(ErrorStyle.NONE);
        eRenderer.setDashSize(0);
        eRenderer.setPointReduction(true);
        eRenderer.setDrawMarker(false);
        DefaultDataReducer reductionAlgorithm = (DefaultDataReducer)eRenderer.getRendererDataReducer();
        reductionAlgorithm.setMinPointPixelDistance(0);
    }

    public void start(Stage primaryStage) {
        ProcessingProfiler.setVerboseOutputState((boolean)true);
        ProcessingProfiler.setLoggerOutputState((boolean)true);
        ProcessingProfiler.setDebugState((boolean)false);
        BorderPane root = new BorderPane();
        Scene scene = new Scene((Parent)root, 1800.0, 400.0);
        root.setCenter((Node)this.initComponents(scene));
        long startTime = ProcessingProfiler.getTimeStamp();
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.show();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"for showing");
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    public static double rampFunctionBeamIntensity(double t) {
        int second = (int)Math.floor(t);
        double subSecond = t - (double)second;
        double offset = 0.3;
        double y = (1.0 - 0.1 * subSecond) * 1.0E9;
        double gate = RollingBufferSample.square(2.0, subSecond - offset) * RollingBufferSample.square(1.0, subSecond - offset);
        if (second % 5 == 0) {
            offset = 0.1;
            gate = Math.pow(RollingBufferSample.square(3.0, subSecond - offset), 2.0);
        }
        if (gate <= 0.0 || subSecond < offset) {
            gate = 0.0;
        }
        return gate * y;
    }

    public static double rampFunctionDipoleCurrent(double t) {
        int second = (int)Math.floor(t);
        double subSecond = t - (double)second;
        double offset = 0.3;
        double y = 100.0 * RollingBufferSample.sine(1.0, subSecond - offset);
        if (second % 5 == 0) {
            offset = 0.1;
            y = 100.0 * Math.pow(RollingBufferSample.sine(1.5, subSecond - offset), 2.0);
        }
        if (y <= 0.0 || subSecond < offset) {
            y = 0.0;
        }
        return y + 10.0;
    }

    private static double sine(double frequency, double t) {
        return Math.sin(Math.PI * 2 * frequency * t);
    }

    private static double square(double frequency, double t) {
        double sine = 100.0 * Math.sin(Math.PI * 2 * frequency * t);
        double squarePoint = Math.signum(sine);
        return squarePoint >= 0.0 ? squarePoint : 0.0;
    }
}

