/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.TickUnitSupplier;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.axes.spi.OscilloscopeAxis;
import de.gsi.chart.axes.spi.format.DefaultTickUnitSupplier;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.renderer.datareduction.DefaultDataReducer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.samples.RollingBufferSample;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.chart.utils.FXUtils;
import de.gsi.chart.utils.SimplePerformanceMeter;
import de.gsi.dataset.spi.LimitedIndexedTreeDataSet;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OscilloscopeAxisSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(OscilloscopeAxisSample.class);
    private static final String MONOSPACED = "Monospaced";
    private static final int MIN_PIXEL_DISTANCE = 1;
    private static final double AXIS_CENTRE_VALUE = 0.0;
    private static final double AXIS_CENTRE_POSITION = 0.2;
    public final LimitedIndexedTreeDataSet rollingBufferDipoleCurrent = new LimitedIndexedTreeDataSet("dipole current", RollingBufferSample.BUFFER_CAPACITY);
    public final LimitedIndexedTreeDataSet rollingBufferBeamIntensity = new LimitedIndexedTreeDataSet("beam intensity", RollingBufferSample.BUFFER_CAPACITY);
    public final XYChart chartOscilloscopeAxis = this.getChart(false);
    public final XYChart chartDefaultAxis = this.getChart(true);
    private Timer timer;

    private void generateData() {
        long startTime = ProcessingProfiler.getTimeStamp();
        double now = (double)System.currentTimeMillis() / 1000.0 + 1.0;
        if (this.rollingBufferDipoleCurrent.getDataCount() == 0) {
            this.rollingBufferBeamIntensity.autoNotification().set(false);
            this.rollingBufferDipoleCurrent.autoNotification().set(false);
            for (int n = RollingBufferSample.N_SAMPLES; n > 0; --n) {
                double t = now - (double)(n * RollingBufferSample.UPDATE_PERIOD) / 1000.0;
                double y = 25.0 * RollingBufferSample.rampFunctionDipoleCurrent(t);
                double y2 = 0.0 + 100.0 * Math.cos(0.06283185307179587 * t) * RollingBufferSample.rampFunctionBeamIntensity(t);
                double ey = 1.0;
                this.rollingBufferDipoleCurrent.add(t, y, 1.0, 1.0, new String[0]);
                this.rollingBufferBeamIntensity.add(t, y2, 1.0, 1.0, new String[0]);
            }
            this.rollingBufferBeamIntensity.autoNotification().set(true);
            this.rollingBufferDipoleCurrent.autoNotification().set(true);
        } else {
            this.rollingBufferDipoleCurrent.autoNotification().set(false);
            double t = now;
            double y = 25.0 * RollingBufferSample.rampFunctionDipoleCurrent(t);
            double y2 = 0.0 + 100.0 * Math.cos(0.06283185307179587 * t) * RollingBufferSample.rampFunctionBeamIntensity(t);
            double ey = 1.0;
            this.rollingBufferDipoleCurrent.add(t, y, 1.0, 1.0, new String[0]);
            this.rollingBufferBeamIntensity.add(t, y2, 1.0, 1.0, new String[0]);
            this.rollingBufferDipoleCurrent.autoNotification().set(true);
        }
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data into DataSet");
    }

    public void start(Stage primaryStage) {
        BorderPane root = new BorderPane();
        Scene scene = new Scene((Parent)root, 1800.0, 800.0);
        root.setTop((Node)this.getHeaderBar(scene));
        this.generateData();
        root.setCenter((Node)new VBox(new Node[]{this.chartOscilloscopeAxis, this.chartDefaultAxis}));
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
    }

    private ToolBar getHeaderBar(Scene scene) {
        Button startTimer = new Button("Start Timer");
        startTimer.setOnAction(evt -> {
            if (this.timer == null) {
                FXUtils.runFX(() -> startTimer.setText("Stop Timer"));
                this.timer = new Timer("sample-update-timer", true);
                this.rollingBufferBeamIntensity.reset();
                this.rollingBufferDipoleCurrent.reset();
                this.timer.scheduleAtFixedRate(this.getTask(), 0L, (long)RollingBufferSample.UPDATE_PERIOD);
            } else {
                FXUtils.runFX(() -> startTimer.setText("Start Timer"));
                this.timer.cancel();
                this.timer = null;
            }
        });
        ToggleGroup radioGroup = new ToggleGroup();
        RadioButton tickRange1 = new RadioButton("<1,2,5>");
        tickRange1.setSelected(true);
        tickRange1.setToggleGroup(radioGroup);
        tickRange1.setOnAction(evt -> {
            for (Axis axis : this.chartOscilloscopeAxis.getAxes()) {
                if (!(axis instanceof OscilloscopeAxis)) continue;
                ((OscilloscopeAxis)axis).setTickUnitSupplier((TickUnitSupplier)new DefaultTickUnitSupplier(OscilloscopeAxis.DEFAULT_MULTIPLIERS1));
                axis.requestAxisLayout();
            }
        });
        RadioButton tickRange2 = new RadioButton("<1, 1.5, 2, ..., 9.5>");
        tickRange2.setToggleGroup(radioGroup);
        tickRange2.setOnAction(evt -> {
            for (Axis axis : this.chartOscilloscopeAxis.getAxes()) {
                if (!(axis instanceof OscilloscopeAxis)) continue;
                ((OscilloscopeAxis)axis).setTickUnitSupplier((TickUnitSupplier)new DefaultTickUnitSupplier(OscilloscopeAxis.DEFAULT_MULTIPLIERS2));
                axis.requestAxisLayout();
            }
        });
        Slider centreSlider = new Slider(0.0, 1.0, 0.2);
        centreSlider.setMajorTickUnit(0.1);
        centreSlider.setMinorTickCount(1);
        centreSlider.setShowTickMarks(true);
        centreSlider.setShowTickLabels(true);
        centreSlider.setBlockIncrement(0.1);
        centreSlider.valueProperty().addListener((ch, o, n) -> {
            double zeroPosition = n.doubleValue();
            for (Axis axis : this.chartOscilloscopeAxis.getAxes()) {
                if (!(axis instanceof OscilloscopeAxis)) continue;
                ((OscilloscopeAxis)axis).setAxisZeroPosition(zeroPosition);
                this.chartOscilloscopeAxis.requestLayout();
            }
        });
        CheckBox forceMinRange = new CheckBox("force min. range");
        forceMinRange.selectedProperty().addListener((ch, o, n) -> {
            for (Axis axis : this.chartOscilloscopeAxis.getAxes()) {
                if (!(axis instanceof OscilloscopeAxis)) continue;
                if (Boolean.TRUE.equals(n)) {
                    ((OscilloscopeAxis)axis).getMinRange().set(-4000.0, 0.0);
                } else {
                    ((OscilloscopeAxis)axis).getMinRange().clear();
                }
                axis.forceRedraw();
                this.chartOscilloscopeAxis.requestLayout();
            }
        });
        CheckBox forceMaxRange = new CheckBox("force max. range");
        forceMaxRange.selectedProperty().addListener((ch, o, n) -> {
            for (Axis axis : this.chartOscilloscopeAxis.getAxes()) {
                if (!(axis instanceof OscilloscopeAxis)) continue;
                if (Boolean.TRUE.equals(n)) {
                    ((OscilloscopeAxis)axis).getMaxRange().set(0.0, 1000.0);
                } else {
                    ((OscilloscopeAxis)axis).getMaxRange().clear();
                }
                axis.forceRedraw();
                this.chartOscilloscopeAxis.requestLayout();
            }
        });
        Region spacer = new Region();
        spacer.setMinWidth(Double.NEGATIVE_INFINITY);
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        SimplePerformanceMeter meter = new SimplePerformanceMeter(scene, 500L);
        Label fxFPS = new Label();
        fxFPS.setFont(Font.font((String)MONOSPACED, (double)12.0));
        Label chartFPS = new Label();
        chartFPS.setFont(Font.font((String)MONOSPACED, (double)12.0));
        Label cpuLoadProcess = new Label();
        cpuLoadProcess.setFont(Font.font((String)MONOSPACED, (double)12.0));
        Label cpuLoadSystem = new Label();
        cpuLoadSystem.setFont(Font.font((String)MONOSPACED, (double)12.0));
        meter.fxFrameRateProperty().addListener((ch, o, n) -> {
            String fxRate = String.format("%4.1f", meter.getFxFrameRate());
            String actualRate = String.format("%4.1f", meter.getActualFrameRate());
            String cpuProcess = String.format("%5.1f", meter.getProcessCpuLoad());
            String cpuSystem = String.format("%5.1f", meter.getSystemCpuLoad());
            fxFPS.setText(String.format("%-6s: %4s %s", "JavaFX", fxRate, "FPS, "));
            chartFPS.setText(String.format("%-6s: %4s %s", "Actual", actualRate, "FPS, "));
            cpuLoadProcess.setText(String.format("%-11s: %4s %s", "Process-CPU", cpuProcess, "%"));
            cpuLoadSystem.setText(String.format("%-11s: %4s %s", "System -CPU", cpuSystem, "%"));
        });
        return new ToolBar(new Node[]{startTimer, new Label(" tick multipliers: "), tickRange1, tickRange2, new Label(" zero axis position: "), centreSlider, forceMinRange, forceMaxRange, spacer, new VBox(new Node[]{fxFPS, chartFPS}), new VBox(new Node[]{cpuLoadProcess, cpuLoadSystem})});
    }

    private TimerTask getTask() {
        return new TimerTask(){
            private int updateCount;

            @Override
            public void run() {
                Platform.runLater(() -> {
                    OscilloscopeAxisSample.this.generateData();
                    if (this.updateCount % 80 == 0) {
                        LOGGER.atInfo().log("update iteration #" + this.updateCount);
                    }
                    ++this.updateCount;
                });
            }
        };
    }

    private XYChart getChart(boolean defaultAxis) {
        DefaultNumericAxis yAxis2;
        DefaultNumericAxis yAxis1;
        DefaultNumericAxis xAxis = new DefaultNumericAxis("", "");
        xAxis.setAutoRangeRounding(false);
        xAxis.invertAxis(false);
        xAxis.setTimeAxis(true);
        if (defaultAxis) {
            yAxis1 = new DefaultNumericAxis("beam intensity", "ppp");
            yAxis2 = new DefaultNumericAxis("dipole current", "A");
            yAxis1.setForceZeroInRange(true);
            yAxis2.setForceZeroInRange(true);
        } else {
            yAxis1 = new OscilloscopeAxis("beam intensity", "ppp");
            ((OscilloscopeAxis)yAxis1).setAxisZeroValue(0.0);
            ((OscilloscopeAxis)yAxis1).setAxisZeroPosition(0.2);
            yAxis2 = new OscilloscopeAxis("dipole current", "A");
            ((OscilloscopeAxis)yAxis2).setAxisZeroPosition(0.2);
        }
        yAxis2.setSide(Side.RIGHT);
        yAxis1.setAutoRangeRounding(true);
        yAxis2.setAutoRangeRounding(true);
        XYChart chart = new XYChart((Axis)xAxis, (Axis)yAxis1);
        chart.setTitle(defaultAxis ? "Chart with DefaultNumericAxis" : "Chart with OscilloscopeAxis");
        chart.legendVisibleProperty().set(false);
        chart.getYAxis().setName(this.rollingBufferBeamIntensity.getName());
        ErrorDataSetRenderer beamIntensityRenderer = (ErrorDataSetRenderer)chart.getRenderers().get(0);
        ((DefaultDataReducer)beamIntensityRenderer.getRendererDataReducer()).setMinPointPixelDistance(1);
        beamIntensityRenderer.setDrawMarker(false);
        beamIntensityRenderer.getDatasets().add((Object)this.rollingBufferBeamIntensity);
        ErrorDataSetRenderer dipoleCurrentRenderer = new ErrorDataSetRenderer();
        ((DefaultDataReducer)dipoleCurrentRenderer.getRendererDataReducer()).setMinPointPixelDistance(1);
        dipoleCurrentRenderer.setDrawMarker(false);
        dipoleCurrentRenderer.getAxes().add((Object)yAxis2);
        dipoleCurrentRenderer.getDatasets().add((Object)this.rollingBufferDipoleCurrent);
        chart.getRenderers().add((Object)dipoleCurrentRenderer);
        chart.getPlugins().add((Object)new EditAxis());
        return chart;
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

