/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.DataPointTooltip;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.EditDataSet;
import de.gsi.chart.plugins.UpdateAxisLabels;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.dataset.EditConstraints;
import de.gsi.dataset.spi.DoubleDataSet;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class EditDataSetSample
extends Application {
    private static final int N_SAMPLES = 100;

    public void start(Stage primaryStage) {
        StackPane root = new StackPane();
        XYChart chart = new XYChart((Axis)new DefaultNumericAxis(), (Axis)new DefaultNumericAxis());
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new EditAxis());
        chart.getPlugins().add((Object)new EditDataSet());
        chart.getPlugins().add((Object)new DataPointTooltip());
        chart.getPlugins().add((Object)new UpdateAxisLabels());
        root.getChildren().add((Object)chart);
        DoubleDataSet dataSet1 = new DoubleDataSet("data set #1 (full change)");
        dataSet1.getAxisDescription(0).set("time", new String[]{"s"});
        dataSet1.getAxisDescription(1).set("Voltage", new String[]{"V"});
        final DoubleDataSet dataSet2 = new DoubleDataSet("data set #2 (modify y-only)");
        dataSet2.getAxisDescription(0).set("time", new String[]{"s"});
        dataSet2.getAxisDescription(1).set("Current", new String[]{"A"});
        ErrorDataSetRenderer renderer1 = new ErrorDataSetRenderer();
        ErrorDataSetRenderer renderer2 = new ErrorDataSetRenderer();
        renderer1.getDatasets().add((Object)dataSet1);
        chart.getRenderers().addAll((Object[])new Renderer[]{renderer1, renderer2});
        renderer2.getDatasets().add((Object)dataSet2);
        double[] xValues = new double[100];
        double[] yValues1 = new double[100];
        double[] yValues2 = new double[100];
        for (int n = 0; n < 100; ++n) {
            xValues[n] = n;
            yValues1[n] = Math.cos(Math.toRadians(10.0 * (double)n));
            yValues2[n] = Math.sin(Math.toRadians(10.0 * (double)n));
        }
        dataSet1.set(xValues, yValues1);
        dataSet2.set(xValues, yValues2);
        dataSet2.setEditConstraints(new EditConstraints(){

            public boolean canAdd(int index) {
                return true;
            }

            public boolean canChange(int index) {
                return index > 4 && index < dataSet2.getDataCount() - 6 && index != 25;
            }

            public boolean canDelete(int index) {
                return index > 4 && index < dataSet2.getDataCount() - 6 && index != 25;
            }

            public boolean isEditable(int dimIndex) {
                return dimIndex != 0;
            }
        });
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.show();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

