/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.renderer.spi.utils.DefaultRenderColorScheme;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import java.util.Arrays;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomColourSchemeSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomColourSchemeSample.class);
    private static final int N_SAMPLES = 2000;
    private static final int N_DATA_SETS_MAX = 10;

    public void start(Stage primaryStage) {
        XYChart chart = new XYChart((Axis)new DefaultNumericAxis("x-Axis"), (Axis)new DefaultNumericAxis("y-Axis"));
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new EditAxis());
        VBox.setVgrow((Node)chart, (Priority)Priority.ALWAYS);
        ErrorDataSetRenderer renderer = (ErrorDataSetRenderer)chart.getRenderers().get(0);
        for (int i = 0; i < 10; ++i) {
            DoubleErrorDataSet dataSet = new DoubleErrorDataSet("Set#" + i);
            for (int n2 = 0; n2 < 2000; ++n2) {
                dataSet.add((double)n2, 0.5 * (double)i + Math.cos(Math.toRadians(1.0 * (double)n2)), 0.15, 0.15);
            }
            chart.getDatasets().add((Object)dataSet);
        }
        ComboBox strokeStyleCB = new ComboBox();
        strokeStyleCB.getItems().setAll((Object[])DefaultRenderColorScheme.Palette.values());
        strokeStyleCB.getSelectionModel().select((Object)DefaultRenderColorScheme.Palette.getValue((ObservableList)((ObservableList)DefaultRenderColorScheme.strokeColorProperty().get())));
        strokeStyleCB.getSelectionModel().selectedItemProperty().addListener((ch, o, n) -> {
            DefaultRenderColorScheme.strokeColorProperty().set((Object)n.getPalette());
            chart.requestLayout();
            chart.getLegend().updateLegend((List)chart.getDatasets(), Arrays.asList(renderer), true);
            LOGGER.atInfo().log("updated stroke colour scheme to " + n.name());
        });
        ComboBox fillStyleCB = new ComboBox();
        fillStyleCB.getItems().setAll((Object[])DefaultRenderColorScheme.Palette.values());
        fillStyleCB.getSelectionModel().select((Object)DefaultRenderColorScheme.Palette.getValue((ObservableList)((ObservableList)DefaultRenderColorScheme.fillColorProperty().get())));
        fillStyleCB.getSelectionModel().selectedItemProperty().addListener((ch, o, n) -> {
            DefaultRenderColorScheme.fillColorProperty().set((Object)n.getPalette());
            DefaultRenderColorScheme.fillStylesProperty().clear();
            DefaultRenderColorScheme.fillStylesProperty().set((Object)DefaultRenderColorScheme.getStandardFillStyle());
            chart.requestLayout();
            chart.getLegend().updateLegend((List)chart.getDatasets(), Arrays.asList(renderer), true);
            LOGGER.atInfo().log("updated fill colour scheme to " + n.name());
        });
        ComboBox errorStyleCB = new ComboBox();
        errorStyleCB.getItems().setAll((Object[])ErrorStyle.values());
        errorStyleCB.getSelectionModel().select((Object)renderer.getErrorType());
        errorStyleCB.getSelectionModel().selectedItemProperty().addListener((ch, o, n) -> {
            renderer.setErrorType(n);
            chart.requestLayout();
            LOGGER.atInfo().log("updated error style to " + n.name());
        });
        Button customFill = new Button("custom fill");
        customFill.setOnAction(evt -> {
            ObservableList values = FXCollections.observableArrayList();
            for (Color colour : DefaultRenderColorScheme.fillColorProperty()) {
                Stop[] stops = new Stop[]{new Stop(0.0, colour.brighter().interpolate(Color.TRANSPARENT, 0.4)), new Stop(1.0, colour.brighter().interpolate(Color.TRANSPARENT, 0.95))};
                LinearGradient gradient = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.REPEAT, stops);
                values.add((Object)gradient);
            }
            DefaultRenderColorScheme.fillStylesProperty().clear();
            DefaultRenderColorScheme.fillStylesProperty().set((Object)values);
            chart.requestLayout();
            chart.getLegend().updateLegend((List)chart.getDatasets(), Arrays.asList(renderer), true);
            LOGGER.atInfo().log("updated to custom filling scheme");
        });
        ToolBar toolBar = new ToolBar(new Node[]{new Label("stroke colour: "), strokeStyleCB, new Label("fill colour: "), fillStyleCB, new Label("error style: "), errorStyleCB, customFill});
        Scene scene = new Scene((Parent)new VBox(new Node[]{toolBar, chart}), 800.0, 600.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

