/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.samples;

import de.gsi.chart.utils.PeriodicScreenCapture;
import de.gsi.math.samples.DataSetAverageSample;
import de.gsi.math.samples.DataSetFilterSample;
import de.gsi.math.samples.DataSetIntegrateDifferentiateSample;
import de.gsi.math.samples.DataSetIntegrationWithLimitsSample;
import de.gsi.math.samples.DataSetSpectrumSample;
import de.gsi.math.samples.EMDSample;
import de.gsi.math.samples.FourierSample;
import de.gsi.math.samples.FrequencyFilterSample;
import de.gsi.math.samples.GaussianFitSample;
import de.gsi.math.samples.IIRFrequencyFilterSample;
import de.gsi.math.samples.WaveletDenoising;
import de.gsi.math.samples.WaveletScalogram;
import java.nio.file.Path;
import java.nio.file.Paths;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunMathSamples
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunMathSamples.class);
    private static final int DEFAULT_DELAY = 2;
    private static final int DEFAULT_PERIOD = 5;
    private final String userHome = System.getProperty("user.home");
    private final Path path = Paths.get(this.userHome + "/ChartMathSamples", new String[0]);
    Stage stage = new Stage();
    CheckBox makeScreenShot = new CheckBox("make screenshot to home directory");

    public void start(Stage primaryStage) {
        BorderPane root = new BorderPane();
        FlowPane buttons = new FlowPane();
        buttons.setAlignment(Pos.CENTER_LEFT);
        root.setCenter((Node)buttons);
        root.setBottom((Node)this.makeScreenShot);
        buttons.getChildren().add((Object)new MyButton("DataSetAverageSample", new DataSetAverageSample()));
        buttons.getChildren().add((Object)new MyButton("DataSetFilterSample", new DataSetFilterSample()));
        buttons.getChildren().add((Object)new MyButton("DataSetIntegrateDifferentiateSample", new DataSetIntegrateDifferentiateSample()));
        buttons.getChildren().add((Object)new MyButton("DataSetIntegrationWithLimitsSample", new DataSetIntegrationWithLimitsSample()));
        buttons.getChildren().add((Object)new MyButton("DataSetSpectrumSample", new DataSetSpectrumSample()));
        buttons.getChildren().add((Object)new MyButton("EMDSample", new EMDSample()));
        buttons.getChildren().add((Object)new MyButton("FourierSample", new FourierSample()));
        buttons.getChildren().add((Object)new MyButton("FrequencyFilterSample", new FrequencyFilterSample()));
        buttons.getChildren().add((Object)new MyButton("GaussianFitSample", new GaussianFitSample()));
        buttons.getChildren().add((Object)new MyButton("IIRFrequencyFilterSample", new IIRFrequencyFilterSample()));
        buttons.getChildren().add((Object)new MyButton("WaveletDenoising", new WaveletDenoising()));
        buttons.getChildren().add((Object)new MyButton("WaveletScalogram", new WaveletScalogram()));
        Scene scene = new Scene((Parent)root);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> System.exit(0));
        primaryStage.show();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    protected class MyButton
    extends Button {
        public MyButton(String buttonText, final Application run) {
            super(buttonText);
            this.setOnAction(e -> {
                block3: {
                    try {
                        run.start(RunMathSamples.this.stage);
                        RunMathSamples.this.stage.getScene().getRoot().layout();
                        RunMathSamples.this.stage.show();
                        if (RunMathSamples.this.makeScreenShot.isSelected()) {
                            new Thread(){

                                @Override
                                public void run() {
                                    block2: {
                                        try {
                                            Thread.sleep(2000L);
                                            Platform.runLater(() -> {
                                                LOGGER.atInfo().log("make screen shot to file of " + run.getClass().getSimpleName());
                                                PeriodicScreenCapture screenCapture = new PeriodicScreenCapture(RunMathSamples.this.path, run.getClass().getSimpleName(), RunMathSamples.this.stage.getScene(), 2.0, 5.0, false);
                                                screenCapture.performScreenCapture();
                                            });
                                        }
                                        catch (InterruptedException e) {
                                            if (!LOGGER.isErrorEnabled()) break block2;
                                            LOGGER.atError().setCause((Throwable)e).log("InterruptedException");
                                        }
                                    }
                                }
                            }.start();
                        }
                    }
                    catch (Exception e1) {
                        if (!LOGGER.isErrorEnabled()) break block3;
                        LOGGER.atError().setCause((Throwable)e1).log("InterruptedException");
                    }
                }
            });
        }
    }
}

