/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.samples;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.math.ArrayMath;
import de.gsi.math.DataSetMath;
import de.gsi.math.samples.utils.AbstractDemoApplication;
import de.gsi.math.samples.utils.DemoChart;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.layout.VBox;

public class FrequencyFilterSample
extends AbstractDemoApplication {
    private static final int N_SAMPLES = 8192;
    private static final int N_SAMPLE_RATE = 1000;

    @Override
    public Node getContent() {
        double[] xValues = new double[8192];
        double[] yValues = new double[8192];
        double fs = 1000.0;
        double fcut = 0.1;
        for (int i = 0; i < 8192; ++i) {
            xValues[i] = (double)i / fs;
        }
        yValues[4096] = 8192.0;
        DefaultDataSet dataSet = new DefaultDataSet("dirac", xValues, yValues, xValues.length, true);
        DemoChart chartLP = new DemoChart();
        chartLP.getXAxis().setName("frequency");
        chartLP.getYAxis().setName("magnitude");
        chartLP.getYAxis().setUnit("dB");
        chartLP.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)dataSet)});
        DefaultDataSet butterWorthA = new DefaultDataSet("Butterworth(4th)", xValues, ArrayMath.filterSignal((double[])yValues, (double)fcut, (double)4.0, (ArrayMath.FilterType)ArrayMath.FilterType.LOW_PASS, (double)0.0), xValues.length, true);
        chartLP.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)butterWorthA)});
        DefaultDataSet butterWorthB = new DefaultDataSet("Butterworth(6th)", xValues, ArrayMath.filterSignal((double[])yValues, (double)fcut, (double)6.0, (ArrayMath.FilterType)ArrayMath.FilterType.LOW_PASS, (double)0.0), xValues.length, true);
        chartLP.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)butterWorthB)});
        DefaultDataSet butterWorthC = new DefaultDataSet("Butterworth(8th)", xValues, ArrayMath.filterSignal((double[])yValues, (double)fcut, (double)8.0, (ArrayMath.FilterType)ArrayMath.FilterType.LOW_PASS, (double)0.0), xValues.length, true);
        chartLP.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)butterWorthC)});
        DemoChart chartHP = new DemoChart();
        chartHP.getXAxis().setName("frequency");
        chartHP.getYAxis().setName("magnitude");
        chartHP.getYAxis().setUnit("dB");
        chartHP.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)dataSet)});
        DefaultDataSet butterWorthA2 = new DefaultDataSet("Butterworth(4th)", xValues, ArrayMath.filterSignal((double[])yValues, (double)fcut, (double)4.0, (ArrayMath.FilterType)ArrayMath.FilterType.HIGH_PASS, (double)0.0), xValues.length, true);
        chartHP.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)butterWorthA2)});
        DefaultDataSet butterWorthB2 = new DefaultDataSet("Butterworth(6th)", xValues, ArrayMath.filterSignal((double[])yValues, (double)fcut, (double)6.0, (ArrayMath.FilterType)ArrayMath.FilterType.HIGH_PASS, (double)0.0), xValues.length, true);
        chartHP.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)butterWorthB2)});
        DefaultDataSet butterWorthC2 = new DefaultDataSet("Butterworth(8th)", xValues, ArrayMath.filterSignal((double[])yValues, (double)fcut, (double)8.0, (ArrayMath.FilterType)ArrayMath.FilterType.HIGH_PASS, (double)0.0), xValues.length, true);
        chartHP.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)butterWorthC2)});
        return new VBox(new Node[]{chartLP, chartHP});
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

