/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.samples.legacy;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.EditableDataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractErrorDataSet;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;

public class DoubleErrorDataSet
extends AbstractErrorDataSet<DoubleErrorDataSet>
implements DataSetError,
EditableDataSet,
DataSet2D {
    protected double[] xValues;
    protected double[] yValues;
    protected double[] yErrorsPos;
    protected double[] yErrorsNeg;
    protected int dataMaxIndex;

    public DoubleErrorDataSet(DataSet2D another) {
        this("");
        this.lock().writeLockGuard(() -> another.lock().writeLockGuard(() -> {
            this.setName(another.getName());
            this.set(another);
        }));
    }

    public DoubleErrorDataSet(String name) {
        this(name, 0);
    }

    public DoubleErrorDataSet(String name, double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos, int nData, boolean deepCopy) {
        this(name, Math.min(xValues.length, Math.min(yValues.length, nData)));
        AssertUtils.notNull((String)"X data", (Object)xValues);
        AssertUtils.notNull((String)"Y data", (Object)yValues);
        AssertUtils.notNull((String)"Y error pos", (Object)yErrorsPos);
        AssertUtils.notNull((String)"Y error neg", (Object)yErrorsNeg);
        int errorMin = Math.min(Math.min(yErrorsPos.length, yErrorsNeg.length), nData);
        this.dataMaxIndex = Math.min(xValues.length, Math.min(yValues.length, errorMin));
        AssertUtils.equalDoubleArrays((double[])xValues, (double[])yValues, (int)this.dataMaxIndex);
        AssertUtils.equalDoubleArrays((double[])xValues, (double[])yErrorsPos, (int)this.dataMaxIndex);
        AssertUtils.equalDoubleArrays((double[])xValues, (double[])yErrorsNeg, (int)this.dataMaxIndex);
        if (this.dataMaxIndex != 0 && deepCopy) {
            System.arraycopy(xValues, 0, this.xValues, 0, this.dataMaxIndex);
            System.arraycopy(yValues, 0, this.yValues, 0, this.dataMaxIndex);
            System.arraycopy(yErrorsPos, 0, this.yErrorsPos, 0, this.dataMaxIndex);
            System.arraycopy(yErrorsNeg, 0, this.yErrorsNeg, 0, this.dataMaxIndex);
        } else {
            this.xValues = xValues;
            this.yValues = yValues;
            this.yErrorsPos = yErrorsPos;
            this.yErrorsNeg = yErrorsNeg;
        }
        this.recomputeLimits(0);
        this.recomputeLimits(1);
    }

    public DoubleErrorDataSet(String name, int initalSize) {
        super(name, 2, new DataSetError.ErrorType[]{DataSetError.ErrorType.NO_ERROR, DataSetError.ErrorType.ASYMMETRIC});
        AssertUtils.gtEqThanZero((String)"initalSize", (int)initalSize);
        this.xValues = new double[initalSize];
        this.yValues = new double[initalSize];
        this.yErrorsPos = new double[initalSize];
        this.yErrorsNeg = new double[initalSize];
        this.dataMaxIndex = 0;
    }

    public DoubleErrorDataSet add(double x, double y) {
        return this.add(x, y, 0.0, 0.0);
    }

    public DoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos) {
        this.lock().writeLockGuard(() -> {
            if (this.dataMaxIndex > this.xValues.length - 1) {
                double[] xValuesNew = new double[this.xValues.length + 1];
                double[] yValuesNew = new double[this.yValues.length + 1];
                double[] yErrorsNegNew = new double[this.yValues.length + 1];
                double[] yErrorsPosNew = new double[this.yValues.length + 1];
                System.arraycopy(this.xValues, 0, xValuesNew, 0, this.xValues.length);
                System.arraycopy(this.yValues, 0, yValuesNew, 0, this.yValues.length);
                System.arraycopy(this.yErrorsNeg, 0, yErrorsNegNew, 0, this.yValues.length);
                System.arraycopy(this.yErrorsPos, 0, yErrorsPosNew, 0, this.yValues.length);
                this.xValues = xValuesNew;
                this.yValues = yValuesNew;
                this.yErrorsPos = yErrorsPosNew;
                this.yErrorsNeg = yErrorsNegNew;
            }
            this.xValues[this.dataMaxIndex] = x;
            this.yValues[this.dataMaxIndex] = y;
            this.yErrorsPos[this.dataMaxIndex] = yErrorPos;
            this.yErrorsNeg[this.dataMaxIndex] = yErrorNeg;
            ++this.dataMaxIndex;
            this.getAxisDescription(0).add(x);
            this.getAxisDescription(1).add(y - yErrorNeg);
            this.getAxisDescription(1).add(y + yErrorPos);
        });
        return (DoubleErrorDataSet)this.fireInvalidated((UpdateEvent)new AddedDataEvent((EventSource)this));
    }

    public DoubleErrorDataSet add(double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos) {
        AssertUtils.notNull((String)"X coordinates", (Object)xValues);
        AssertUtils.notNull((String)"Y coordinates", (Object)yValues);
        AssertUtils.notNull((String)"Y error neg", (Object)yErrorsNeg);
        AssertUtils.notNull((String)"Y error pos", (Object)yErrorsPos);
        AssertUtils.equalDoubleArrays((double[])xValues, (double[])yValues);
        AssertUtils.equalDoubleArrays((double[])xValues, (double[])yErrorsNeg);
        AssertUtils.equalDoubleArrays((double[])xValues, (double[])yErrorsPos);
        this.lock().writeLockGuard(() -> {
            int newLength = this.getDataCount() + xValues.length;
            if (newLength > this.xValues.length) {
                double[] xValuesNew = new double[newLength];
                double[] yValuesNew = new double[newLength];
                double[] yErrorsNegNew = new double[newLength];
                double[] yErrorsPosNew = new double[newLength];
                System.arraycopy(this.xValues, 0, xValuesNew, 0, this.getDataCount());
                System.arraycopy(this.yValues, 0, yValuesNew, 0, this.getDataCount());
                System.arraycopy(yErrorsNeg, 0, yErrorsNegNew, 0, this.getDataCount());
                System.arraycopy(yErrorsPos, 0, yErrorsPosNew, 0, this.getDataCount());
                this.xValues = xValuesNew;
                this.yValues = yValuesNew;
                this.yErrorsNeg = yErrorsNegNew;
                this.yErrorsPos = yErrorsPosNew;
            }
            System.arraycopy(xValues, 0, this.xValues, this.getDataCount(), newLength - this.getDataCount());
            System.arraycopy(yValues, 0, this.yValues, this.getDataCount(), newLength - this.getDataCount());
            System.arraycopy(yErrorsNeg, 0, this.yErrorsNeg, this.getDataCount(), newLength - this.getDataCount());
            System.arraycopy(yErrorsPos, 0, this.yErrorsPos, this.getDataCount(), newLength - this.getDataCount());
            this.dataMaxIndex = Math.max(0, this.dataMaxIndex + xValues.length);
            this.recomputeLimits(0);
            this.recomputeLimits(1);
        });
        return (DoubleErrorDataSet)this.fireInvalidated((UpdateEvent)new AddedDataEvent((EventSource)this));
    }

    public EditableDataSet add(int index, double ... newValue) {
        return null;
    }

    public DoubleErrorDataSet clearData() {
        this.lock().writeLockGuard(() -> {
            this.dataMaxIndex = 0;
            Arrays.fill(this.xValues, 0.0);
            Arrays.fill(this.yValues, 0.0);
            Arrays.fill(this.yErrorsPos, 0.0);
            Arrays.fill(this.yErrorsNeg, 0.0);
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            this.getAxisDescription(0).clear();
            this.getAxisDescription(1).clear();
        });
        return (DoubleErrorDataSet)this.fireInvalidated((UpdateEvent)new RemovedDataEvent((EventSource)this, "clearData()"));
    }

    public double get(int dimIndex, int index) {
        return dimIndex == 0 ? this.xValues[index] : this.yValues[index];
    }

    public int getDataCount(int dimIndex) {
        return Math.min(this.dataMaxIndex, this.xValues.length);
    }

    public double getErrorNegative(int dimIndex, int index) {
        return dimIndex == 0 ? 0.0 : this.yErrorsNeg[index];
    }

    public double getErrorPositive(int dimIndex, int index) {
        return dimIndex == 0 ? 0.0 : this.yErrorsPos[index];
    }

    public double[] getErrorsNegative(int dimIndex) {
        return dimIndex == 1 ? this.yErrorsNeg : super.getErrorsPositive(dimIndex);
    }

    public double[] getErrorsPositive(int dimIndex) {
        return dimIndex == 1 ? this.yErrorsPos : super.getErrorsPositive(dimIndex);
    }

    public double[] getXValues() {
        return this.xValues;
    }

    public double[] getYValues() {
        return this.yValues;
    }

    public EditableDataSet remove(int index) {
        return this.remove(index, index + 1);
    }

    public DoubleErrorDataSet remove(int fromIndex, int toIndex) {
        this.lock().writeLockGuard(() -> {
            AssertUtils.indexInBounds((int)fromIndex, (int)this.getDataCount(), (String)"fromIndex");
            AssertUtils.indexInBounds((int)toIndex, (int)this.getDataCount(), (String)"toIndex");
            AssertUtils.indexOrder((int)fromIndex, (String)"fromIndex", (int)toIndex, (String)"toIndex");
            int diffLength = toIndex - fromIndex;
            int newLength = this.xValues.length - diffLength;
            double[] xValuesNew = new double[newLength];
            double[] yValuesNew = new double[newLength];
            double[] yErrorsNegNew = new double[newLength];
            double[] yErrorsPosNew = new double[newLength];
            System.arraycopy(this.xValues, 0, xValuesNew, 0, fromIndex);
            System.arraycopy(this.yValues, 0, yValuesNew, 0, fromIndex);
            System.arraycopy(this.yErrorsNeg, 0, yErrorsNegNew, 0, fromIndex);
            System.arraycopy(this.yErrorsPos, 0, yErrorsPosNew, 0, fromIndex);
            System.arraycopy(this.xValues, toIndex, xValuesNew, fromIndex, newLength - fromIndex);
            System.arraycopy(this.yValues, toIndex, yValuesNew, fromIndex, newLength - fromIndex);
            System.arraycopy(this.yErrorsNeg, toIndex, yErrorsNegNew, fromIndex, newLength - fromIndex);
            System.arraycopy(this.yErrorsPos, toIndex, yErrorsPosNew, fromIndex, newLength - fromIndex);
            this.xValues = xValuesNew;
            this.yValues = yValuesNew;
            this.yErrorsPos = yErrorsPosNew;
            this.yErrorsNeg = yErrorsNegNew;
            this.dataMaxIndex = Math.max(0, this.dataMaxIndex - diffLength);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (DoubleErrorDataSet)this.fireInvalidated((UpdateEvent)new RemovedDataEvent((EventSource)this));
    }

    public DoubleErrorDataSet set(DataSet2D other) {
        this.lock().writeLockGuard(() -> other.lock().writeLockGuard(() -> {
            int index;
            this.getDataLabelMap().clear();
            for (index = 0; index < other.getDataCount(); ++index) {
                String label = other.getDataLabel(index);
                if (label == null || label.isEmpty()) continue;
                this.addDataLabel(index, label);
            }
            this.getDataStyleMap().clear();
            for (index = 0; index < other.getDataCount(); ++index) {
                String style = other.getStyle(index);
                if (style == null || style.isEmpty()) continue;
                this.addDataStyle(index, style);
            }
            this.setStyle(other.getStyle());
            if (other instanceof DataSetError) {
                this.set(other.getXValues(), other.getYValues(), ((DataSetError)other).getErrorsNegative(1), ((DataSetError)other).getErrorsPositive(1), true);
            } else {
                int count = other.getDataCount();
                this.set(other.getXValues(), other.getYValues(), new double[count], new double[count], true);
            }
        }));
        return (DoubleErrorDataSet)this.getThis();
    }

    public DoubleErrorDataSet set(double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos) {
        return this.set(xValues, yValues, yErrorsNeg, yErrorsPos, true);
    }

    public DoubleErrorDataSet set(double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos, boolean copy) {
        AssertUtils.notNull((String)"X coordinates", (Object)xValues);
        AssertUtils.notNull((String)"Y coordinates", (Object)yValues);
        AssertUtils.notNull((String)"Y error neg", (Object)yErrorsNeg);
        AssertUtils.notNull((String)"Y error pos", (Object)yErrorsPos);
        int errorMin = Math.min(yErrorsPos.length, yErrorsNeg.length);
        this.dataMaxIndex = Math.min(xValues.length, Math.min(yValues.length, errorMin));
        AssertUtils.equalDoubleArrays((double[])xValues, (double[])yValues, (int)this.dataMaxIndex);
        AssertUtils.equalDoubleArrays((double[])xValues, (double[])yErrorsNeg, (int)this.dataMaxIndex);
        AssertUtils.equalDoubleArrays((double[])xValues, (double[])yErrorsPos, (int)this.dataMaxIndex);
        this.lock().writeLockGuard(() -> {
            if (!copy) {
                this.xValues = xValues;
                this.yValues = yValues;
                this.yErrorsNeg = yErrorsNeg;
                this.yErrorsPos = yErrorsPos;
                this.recomputeLimits(0);
                this.recomputeLimits(1);
                return;
            }
            if (xValues.length == this.xValues.length) {
                System.arraycopy(xValues, 0, this.xValues, 0, this.getDataCount());
                System.arraycopy(yValues, 0, this.yValues, 0, this.getDataCount());
                System.arraycopy(yErrorsNeg, 0, this.yErrorsNeg, 0, this.getDataCount());
                System.arraycopy(yErrorsPos, 0, this.yErrorsPos, 0, this.getDataCount());
            } else {
                this.xValues = Arrays.copyOf(xValues, xValues.length);
                this.yValues = Arrays.copyOf(yValues, xValues.length);
                this.yErrorsNeg = Arrays.copyOf(yErrorsNeg, xValues.length);
                this.yErrorsPos = Arrays.copyOf(yErrorsPos, xValues.length);
            }
            this.recomputeLimits(0);
            this.recomputeLimits(1);
        });
        return (DoubleErrorDataSet)this.fireInvalidated((UpdateEvent)new UpdatedDataEvent((EventSource)this));
    }

    public DoubleErrorDataSet set(int index, double ... newValue) {
        return this.set(index, newValue[0], newValue[1], 0.0, 0.0);
    }

    public DoubleErrorDataSet set(int index, double x, double y, double yErrorNeg, double yErrorPos) {
        this.lock().writeLockGuard(() -> {
            if (index < this.dataMaxIndex) {
                this.xValues[index] = x;
                this.yValues[index] = y;
                this.yErrorsPos[index] = yErrorPos;
                this.yErrorsNeg[index] = yErrorNeg;
            } else {
                this.add(x, y, yErrorNeg, yErrorPos);
            }
            this.getAxisDescription(0).add(x);
            this.getAxisDescription(1).add(y - yErrorNeg);
            this.getAxisDescription(1).add(y + yErrorPos);
        });
        return (DoubleErrorDataSet)this.fireInvalidated((UpdateEvent)new UpdatedDataEvent((EventSource)this));
    }
}

