/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Panner;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.spi.MountainRangeRenderer;
import de.gsi.chart.samples.ContourChartSample;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet3D;
import de.gsi.dataset.spi.AbstractDataSet3D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MountainRangeRendererSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(MountainRangeRendererSample.class);

    public DataSet3D createData() {
        double[] x;
        double[] y = x = new double[]{-12.0, -9.0, -8.0, -7.0, -6.0, -5.0, -4.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 12.0};
        double[][] z = new double[x.length][y.length];
        for (int yIndex = 0; yIndex < y.length; ++yIndex) {
            for (int xIndex = 0; xIndex < x.length; ++xIndex) {
                z[xIndex][yIndex] = Math.sin(y[yIndex] * x[xIndex]);
            }
        }
        return new DefaultData("demoDataSet", MountainRangeRendererSample.toNumbers(x), MountainRangeRendererSample.toNumbers(y), z);
    }

    private DataSet3D createTestData(double peakOffset) {
        double val;
        int i;
        int nPointsX = 2000;
        int nPointsY = 100;
        double[] x = new double[2000];
        double[] y = new double[100];
        for (i = 0; i < x.length; ++i) {
            x[i] = val = ((double)i / (double)x.length - 0.5) * 10.0;
        }
        for (i = 0; i < y.length; ++i) {
            y[i] = val = ((double)i / (double)y.length - 0.5) * 10.0;
        }
        double[][] z = new double[x.length][y.length];
        for (int yIndex = 0; yIndex < y.length; ++yIndex) {
            for (int xIndex = 0; xIndex < x.length; ++xIndex) {
                double t = x[xIndex];
                double yRel = (double)yIndex / (double)y.length;
                double mean1 = -3.5;
                double mean2 = -1.0;
                double mean3 = 1.0;
                double mean4 = 3.5;
                double width1 = 2.0 * (1.0 - yRel);
                double width4 = 0.2 + 0.05 * Math.sin(Math.PI * 5 * yRel);
                double y1 = MountainRangeRendererSample.gaussian(t, -3.5 + peakOffset, width1);
                double y2 = MountainRangeRendererSample.gaussian(t, -1.0 + peakOffset + 0.3 * Math.sin(7.853981633974483 * yRel), 0.2);
                double y3 = MountainRangeRendererSample.gaussian(t, 1.0 + peakOffset + 0.3 * Math.sin(7.853981633974483 * yRel), 0.2);
                double y4 = MountainRangeRendererSample.gaussian(t, 3.5 + peakOffset, width4);
                z[xIndex][yIndex] = y1 + y2 + y3 + y4;
            }
        }
        return new DefaultData("demoDataSet", MountainRangeRendererSample.toNumbers(x), MountainRangeRendererSample.toNumbers(y), z);
    }

    public DataSet3D readImage() {
        DefaultData defaultData;
        BufferedReader reader = new BufferedReader(new InputStreamReader(ContourChartSample.class.getResourceAsStream("./testdata/image.txt")));
        try {
            reader.readLine();
            String[] x = reader.readLine().split(" ");
            reader.readLine();
            String[] y = reader.readLine().split(" ");
            reader.readLine();
            String[] z = reader.readLine().split(" ");
            Number[] xValues = MountainRangeRendererSample.toNumberArray(x);
            Number[] yValues = MountainRangeRendererSample.toNumberArray(y);
            double[][] zValues = new double[x.length][y.length];
            int i = 0;
            for (int yIdx = 0; yIdx < y.length; ++yIdx) {
                for (int xIdx = 0; xIdx < x.length; ++xIdx) {
                    zValues[xIdx][yIdx] = Double.parseDouble(z[i++]);
                }
            }
            defaultData = new DefaultData("contour data", xValues, yValues, zValues);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NullPointerException e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.atError().setCause((Throwable)e).log("error reading dataset");
                }
                return null;
            }
        }
        reader.close();
        return defaultData;
    }

    public void start(Stage primaryStage) {
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        DefaultNumericAxis xAxis = new DefaultNumericAxis("X Position");
        DefaultNumericAxis yAxis = new DefaultNumericAxis("Y Position");
        XYChart chart = new XYChart((Axis)xAxis, (Axis)yAxis);
        chart.setTitle("Test data");
        MountainRangeRenderer mountainRangeRenderer = new MountainRangeRenderer();
        chart.getRenderers().set(0, (Object)mountainRangeRenderer);
        chart.getDatasets().setAll((Object[])new DataSet[]{this.createTestData(0.0)});
        chart.setLegendVisible(true);
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new Panner());
        chart.getPlugins().add((Object)new EditAxis());
        Spinner mountainRangeOffset = new Spinner(0.0, 10.0, mountainRangeRenderer.getMountainRangeOffset(), 0.1);
        mountainRangeRenderer.mountainRangeOffsetProperty().bind((ObservableValue)mountainRangeOffset.valueProperty());
        mountainRangeOffset.valueProperty().addListener((ch, o, n) -> {
            if (n.equals(o)) {
                return;
            }
            chart.requestLayout();
        });
        Scene scene = new Scene((Parent)new BorderPane((Node)chart, (Node)new ToolBar(new Node[]{new Label(""), mountainRangeOffset}), null, null, null), 1200.0, 800.0);
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
    }

    public static double gaussian(double x, double mean, double sigma) {
        double norm = 1.0 / (sigma * Math.sqrt(Math.PI * 2));
        double is = 1.0 / sigma;
        double i2s2 = 0.5 * is * is;
        double xMinusMean = x - mean;
        return norm * Math.exp(-xMinusMean * xMinusMean * i2s2);
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private static Number[] toNumberArray(String[] stringValues) {
        Number[] numberValues = new Number[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            numberValues[i] = Double.valueOf(stringValues[i]);
        }
        return numberValues;
    }

    private static Number[] toNumbers(double[] array) {
        Number[] result = new Number[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public class DefaultData
    extends AbstractDataSet3D<DefaultData> {
        private static final long serialVersionUID = 2094218221674496366L;
        private final Number[] xValues;
        private final Number[] yValues;
        private final double[][] zValues;

        DefaultData(String name, Number[] xValues, Number[] yValues, double[][] zValues) {
            super(name);
            this.xValues = xValues;
            this.yValues = yValues;
            this.zValues = zValues;
        }

        public final double get(int dimIndex, int index) {
            return dimIndex == 0 ? this.xValues[index].doubleValue() : this.yValues[index].doubleValue();
        }

        public int getDataCount(int dimIndex) {
            if (dimIndex == 0) {
                return this.xValues.length;
            }
            if (dimIndex == 1) {
                return this.yValues.length;
            }
            return this.xValues.length * this.yValues.length;
        }

        public String getStyle(int index) {
            return null;
        }

        public double getValue(int dimIndex, double x) {
            return 0.0;
        }

        public double getX(int i) {
            return this.xValues[i].doubleValue();
        }

        public double getY(int i) {
            return this.yValues[i].doubleValue();
        }

        public double getZ(int xIndex, int yIndex) {
            return this.zValues[xIndex][yIndex];
        }

        public void set(int xIndex, int yIndex, double x, double y, double z) {
            this.xValues[xIndex] = x;
            this.yValues[yIndex] = y;
            this.zValues[xIndex][yIndex] = z;
        }
    }
}

