/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.HistoryDataSetRenderer;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DoubleDataSet;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.dataset.testdata.spi.GaussFunction;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryDataSetRendererSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(HistoryDataSetRendererSample.class);
    private static final int N_SAMPLES = 10000;
    private static final int UPDATE_DELAY = 1000;
    private static final int UPDATE_PERIOD = 100;
    private Timer timer;
    private double updateIteration;

    private void generateData(XYChart chart) {
        DoubleErrorDataSet dataSet = new DoubleErrorDataSet("TestData", 10000);
        DoubleDataSet dataSetNoError = new DoubleDataSet("TestDataNoErrors", 10000);
        long startTime = ProcessingProfiler.getTimeStamp();
        dataSet.autoNotification().set(false);
        dataSetNoError.autoNotification().set(false);
        for (int n = 0; n < 10000; ++n) {
            double x = n;
            double phase = Math.PI * 2 * this.updateIteration / 40.0;
            double a1 = 1.0 + 0.5 * Math.sin(phase);
            double a2 = 1.0 + 0.5 * Math.cos(phase);
            double y1 = a1 * GaussFunction.gauss((double)x, (double)3333.3333333333335, (double)500.0) * 1000.0;
            double y2 = a2 * GaussFunction.gauss((double)x, (double)6666.666666666667, (double)500.0) * 1000.0;
            double ey1 = 0.01 * y1;
            dataSet.set(n, x, y1, ey1, ey1);
            dataSetNoError.set(n, x, y2);
        }
        dataSetNoError.setStyle("dsIndex=1;");
        this.updateIteration += 1.0;
        dataSetNoError.autoNotification().set(true);
        dataSet.autoNotification().set(true);
        Platform.runLater(() -> {
            dataSet.fireInvalidated(null);
            dataSetNoError.fireInvalidated(null);
            chart.requestLayout();
            ObservableList rendererList = chart.getRenderers();
            for (Renderer rend : rendererList) {
                if (!(rend instanceof HistoryDataSetRenderer)) continue;
                HistoryDataSetRenderer hr = (HistoryDataSetRenderer)rend;
                hr.shiftHistory();
            }
            ((Renderer)rendererList.get(0)).getDatasets().setAll((Object[])new DataSet[]{dataSet});
            ((Renderer)rendererList.get(1)).getDatasets().setAll((Object[])new DataSet[]{dataSetNoError});
        });
        startTime = ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data into DataSet");
    }

    public TimerTask getTask(final XYChart chart) {
        return new TimerTask(){
            private int updateCount;

            @Override
            public void run() {
                HistoryDataSetRendererSample.this.generateData(chart);
                if (this.updateCount % 100 == 0) {
                    LOGGER.atInfo().log("update iteration #" + this.updateCount);
                }
                ++this.updateCount;
            }
        };
    }

    public void start(Stage primaryStage) {
        BorderPane root = new BorderPane();
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        DefaultNumericAxis xAxis = new DefaultNumericAxis("x axis");
        xAxis.setAutoRanging(true);
        DefaultNumericAxis yAxis1 = new DefaultNumericAxis("y axis #1", 0.0, 1.3, 0.2);
        yAxis1.setAutoRanging(true);
        yAxis1.setAnimated(false);
        DefaultNumericAxis yAxis2 = new DefaultNumericAxis("y axis #2", 0.0, 1.3, 0.2);
        yAxis2.setAutoRanging(true);
        yAxis2.setAnimated(false);
        yAxis2.setSide(Side.RIGHT);
        XYChart chart = new XYChart((Axis)xAxis, (Axis)yAxis1);
        chart.setLegendVisible(false);
        chart.setAnimated(false);
        chart.getRenderers().set(0, (Object)new HistoryDataSetRenderer(10));
        HistoryDataSetRenderer historyRenderer2 = new HistoryDataSetRenderer(10);
        historyRenderer2.getAxes().add((Object)yAxis2);
        chart.getRenderers().add((Object)historyRenderer2);
        historyRenderer2.setIntensityFading(0.8);
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new EditAxis());
        Button newDataSet = new Button("new DataSet");
        newDataSet.setOnAction(evt -> Platform.runLater((Runnable)this.getTask(chart)));
        Button clearHistory = new Button("clear history");
        clearHistory.setOnAction(evt -> {
            for (Renderer rend : chart.getRenderers()) {
                if (!(rend instanceof HistoryDataSetRenderer)) continue;
                HistoryDataSetRenderer hr = (HistoryDataSetRenderer)rend;
                hr.clearHistory();
            }
            chart.requestLayout();
        });
        Button startTimer = new Button("timer");
        startTimer.setOnAction(evt -> {
            if (this.timer == null) {
                this.timer = new Timer("sample-update-timer", true);
                this.timer.scheduleAtFixedRate(this.getTask(chart), 1000L, 100L);
            } else {
                this.timer.cancel();
                this.timer = null;
            }
        });
        CheckBox legendVisible = new CheckBox("Legend?:");
        legendVisible.selectedProperty().bindBidirectional((Property)chart.legendVisibleProperty());
        root.setTop((Node)new HBox(new Node[]{newDataSet, clearHistory, startTimer, legendVisible}));
        this.generateData(chart);
        long startTime = ProcessingProfiler.getTimeStamp();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data to chart");
        startTime = ProcessingProfiler.getTimeStamp();
        root.setCenter((Node)chart);
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding chart into StackPane");
        startTime = ProcessingProfiler.getTimeStamp();
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.show();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"for showing");
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

