/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.ParameterMeasurements;
import de.gsi.chart.plugins.Screenshot;
import de.gsi.chart.plugins.TableViewer;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.samples.ProfilerInfoBox;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.spi.DoubleDataSet;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.dataset.testdata.spi.RandomDataGenerator;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorDataSetRendererSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorDataSetRendererSample.class);
    private static final int DEBUG_UPDATE_RATE = 500;
    private static final int N_SAMPLES = 1000000;
    private static final int UPDATE_DELAY = 1000;
    private static final int UPDATE_PERIOD = 1000;
    private final DoubleErrorDataSet dataSet = new DoubleErrorDataSet("TestData", 1000000);
    private final DoubleDataSet dataSetNoError = new DoubleDataSet("TestDataNoErrors", 1000000);
    private Timer timer;

    private HBox getHeaderBar(Scene scene) {
        Button newDataSet = new Button("new DataSet");
        newDataSet.setOnAction(evt -> this.getTimerTask().run());
        Button startTimer = new Button("timer");
        startTimer.setOnAction(evt -> {
            if (this.timer == null) {
                this.timer = new Timer("sample-update-timer", true);
                this.timer.scheduleAtFixedRate(this.getTimerTask(), 1000L, 1000L);
            } else {
                this.timer.cancel();
                this.timer = null;
            }
        });
        Region spacer = new Region();
        spacer.setMinWidth(Double.NEGATIVE_INFINITY);
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        return new HBox(new Node[]{newDataSet, startTimer, spacer, new ProfilerInfoBox(scene, 500)});
    }

    private TimerTask getTimerTask() {
        return new TimerTask(){
            private int updateCount;

            @Override
            public void run() {
                ErrorDataSetRendererSample.generateData(ErrorDataSetRendererSample.this.dataSet, ErrorDataSetRendererSample.this.dataSetNoError);
                if (this.updateCount % 10 == 0 && LOGGER.isDebugEnabled()) {
                    LOGGER.atDebug().addArgument((Object)this.updateCount).log("update iteration #{}");
                }
                ++this.updateCount;
            }
        };
    }

    public void start(Stage primaryStage) {
        ProcessingProfiler.setVerboseOutputState((boolean)true);
        ProcessingProfiler.setLoggerOutputState((boolean)true);
        ProcessingProfiler.setDebugState((boolean)false);
        BorderPane root = new BorderPane();
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        XYChart chart = new XYChart((Axis)new DefaultNumericAxis(), (Axis)new DefaultNumericAxis());
        chart.legendVisibleProperty().set(true);
        chart.getXAxis().setName("time");
        chart.getXAxis().setUnit("s");
        chart.getXAxis().setAutoUnitScaling(true);
        chart.getYAxis().setName("y-axis");
        chart.getYAxis().setAutoUnitScaling(true);
        chart.legendVisibleProperty().set(true);
        chart.getPlugins().add((Object)new ParameterMeasurements());
        chart.getPlugins().add((Object)new Screenshot());
        chart.getPlugins().add((Object)new EditAxis());
        Zoomer zoomer = new Zoomer();
        zoomer.setUpdateTickUnit(true);
        chart.getPlugins().add((Object)zoomer);
        chart.getPlugins().add((Object)new TableViewer());
        chart.setAnimated(false);
        ErrorDataSetRenderer errorRenderer = new ErrorDataSetRenderer();
        chart.getRenderers().setAll((Object[])new Renderer[]{errorRenderer});
        errorRenderer.setErrorType(ErrorStyle.ERRORBARS);
        errorRenderer.setErrorType(ErrorStyle.ERRORCOMBO);
        errorRenderer.setDrawMarker(true);
        errorRenderer.setMarkerSize(1.0);
        root.setTop((Node)this.getHeaderBar(scene));
        ErrorDataSetRendererSample.generateData(this.dataSet, this.dataSetNoError);
        long startTime = ProcessingProfiler.getTimeStamp();
        chart.getDatasets().add((Object)this.dataSet);
        chart.getDatasets().add((Object)this.dataSetNoError);
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data to chart");
        startTime = ProcessingProfiler.getTimeStamp();
        root.setCenter((Node)chart);
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding chart into StackPane");
        startTime = ProcessingProfiler.getTimeStamp();
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.show();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"for showing");
    }

    private static void generateData(DoubleErrorDataSet dataSet, DoubleDataSet dataSetNoErrors) {
        long startTime = ProcessingProfiler.getTimeStamp();
        dataSet.lock().writeLockGuard(() -> dataSetNoErrors.lock().writeLockGuard(() -> {
            dataSet.autoNotification().set(false);
            dataSetNoErrors.autoNotification().set(false);
            dataSet.clearData();
            dataSetNoErrors.clearData();
            double oldY = 0.0;
            for (int n = 0; n < 1000000; ++n) {
                double x = n;
                double y = (oldY += RandomDataGenerator.random() - 0.5) + (n == 500000 ? 500.0 : 0.0);
                double ex = 0.1;
                double ey = 10.0;
                dataSet.add(x, y, 0.1, 10.0);
                dataSetNoErrors.add(x, y + 20.0);
                if (n != 500000) continue;
                dataSet.getDataLabelMap().put((Object)n, (Object)"special outlier");
                dataSetNoErrors.getDataLabelMap().put((Object)n, (Object)"special outlier");
            }
            dataSet.autoNotification().set(true);
            dataSetNoErrors.autoNotification().set(true);
        }));
        dataSet.fireInvalidated((UpdateEvent)new AddedDataEvent((EventSource)dataSet));
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"generating data DataSet");
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

