/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.plugins.DataPointTooltip;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.ParameterMeasurements;
import de.gsi.chart.plugins.TableViewer;
import de.gsi.chart.plugins.XRangeIndicator;
import de.gsi.chart.plugins.XValueIndicator;
import de.gsi.chart.plugins.YRangeIndicator;
import de.gsi.chart.plugins.YValueIndicator;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.spi.ContourDataSetRenderer;
import de.gsi.chart.utils.AxisSynchronizer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet3D;
import de.gsi.dataset.spi.DimReductionDataSet;
import de.gsi.math.samples.EMDSample;
import de.gsi.math.spectra.fft.DoubleFFT_1D;
import de.gsi.math.spectra.wavelet.ContinuousWavelet;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DimReductionDataSetSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(DimReductionDataSetSample.class);
    private static DataSet3D tempDataSet;
    private final DataSet3D waveletScalogram = DimReductionDataSetSample.createDataSet();

    public void start(Stage primaryStage) {
        XYChart waveletChart1 = DimReductionDataSetSample.getChart(true);
        waveletChart1.getDatasets().add((Object)this.waveletScalogram);
        DimReductionDataSet horizontalSlice = new DimReductionDataSet(this.waveletScalogram, 1, DimReductionDataSet.Option.SLICE);
        XValueIndicator xValueIndicator = new XValueIndicator(waveletChart1.getXAxis(), 0.0, "slice-y");
        xValueIndicator.valueProperty().addListener((ch, o, n) -> horizontalSlice.setMinIndex(0, n.doubleValue()));
        xValueIndicator.setValue(300.0);
        waveletChart1.getPlugins().addAll((Object[])new ChartPlugin[]{xValueIndicator});
        DimReductionDataSet horizontalRange = new DimReductionDataSet(this.waveletScalogram, 1, DimReductionDataSet.Option.MEAN);
        XValueIndicator xRangeIndicatorMin = new XValueIndicator(waveletChart1.getXAxis(), 0.0);
        XValueIndicator xRangeIndicatorMax = new XValueIndicator(waveletChart1.getXAxis(), 0.0);
        XRangeIndicator xRangeIndicator = new XRangeIndicator(waveletChart1.getXAxis(), 0.0, 0.0, "range-x");
        xRangeIndicator.setLabelVerticalAnchor(VPos.TOP);
        xRangeIndicator.setLabelVerticalPosition(1.0);
        xRangeIndicator.lowerBoundProperty().bindBidirectional((Property)xRangeIndicatorMin.valueProperty());
        xRangeIndicator.upperBoundProperty().bindBidirectional((Property)xRangeIndicatorMax.valueProperty());
        xRangeIndicator.setEditable(true);
        xRangeIndicator.lowerBoundProperty().addListener((ch, o, n) -> horizontalRange.setMinIndex(0, n.doubleValue()));
        xRangeIndicator.upperBoundProperty().addListener((ch, o, n) -> horizontalRange.setMaxIndex(0, n.doubleValue()));
        xRangeIndicator.setLowerBound(200.0);
        xRangeIndicator.setUpperBound(600.0);
        waveletChart1.getPlugins().addAll((Object[])new ChartPlugin[]{xRangeIndicator, xRangeIndicatorMin, xRangeIndicatorMax});
        XYChart waveletChart2 = DimReductionDataSetSample.getChart(true);
        waveletChart2.getDatasets().add((Object)this.waveletScalogram);
        DimReductionDataSet verticalSlice = new DimReductionDataSet(this.waveletScalogram, 0, DimReductionDataSet.Option.SLICE);
        YValueIndicator yValueIndicator = new YValueIndicator(waveletChart1.getYAxis(), 0.0, "slice-x");
        yValueIndicator.valueProperty().addListener((ch, o, n) -> verticalSlice.setMinIndex(1, n.doubleValue()));
        yValueIndicator.setValue(0.26);
        verticalSlice.setMinIndex(1, 0.1);
        waveletChart2.getPlugins().add((Object)yValueIndicator);
        DimReductionDataSet verticalRange = new DimReductionDataSet(this.waveletScalogram, 0, DimReductionDataSet.Option.MEAN);
        YValueIndicator yRangeIndicatorMin = new YValueIndicator(waveletChart1.getYAxis(), 0.0);
        YValueIndicator yRangeIndicatorMax = new YValueIndicator(waveletChart1.getYAxis(), 0.0);
        YRangeIndicator yRangeIndicator = new YRangeIndicator(waveletChart1.getYAxis(), 0.0, 0.0, "range-y");
        yRangeIndicator.setLabelHorizontalAnchor(HPos.RIGHT);
        yRangeIndicator.setLabelHorizontalPosition(1.0);
        yRangeIndicator.lowerBoundProperty().bindBidirectional((Property)yRangeIndicatorMin.valueProperty());
        yRangeIndicator.upperBoundProperty().bindBidirectional((Property)yRangeIndicatorMax.valueProperty());
        yRangeIndicator.setEditable(true);
        yRangeIndicator.lowerBoundProperty().addListener((ch, o, n) -> verticalRange.setMinIndex(1, n.doubleValue()));
        yRangeIndicator.upperBoundProperty().addListener((ch, o, n) -> verticalRange.setMaxIndex(1, n.doubleValue()));
        yRangeIndicator.setLowerBound(0.175);
        yRangeIndicator.setUpperBound(0.225);
        waveletChart2.getPlugins().addAll((Object[])new ChartPlugin[]{yRangeIndicator, yRangeIndicatorMin, yRangeIndicatorMax});
        XYChart horizontalChart = DimReductionDataSetSample.getChart(false);
        horizontalChart.getFirstAxis(Orientation.HORIZONTAL).setName("frequency");
        horizontalChart.getFirstAxis(Orientation.HORIZONTAL).setUnit("fs");
        horizontalChart.getFirstAxis(Orientation.VERTICAL).setName("magnitude");
        horizontalChart.getDatasets().addAll((Object[])new DataSet[]{horizontalSlice, horizontalRange});
        AxisSynchronizer sync1 = new AxisSynchronizer();
        sync1.add(waveletChart1.getYAxis());
        sync1.add(horizontalChart.getXAxis());
        XYChart verticalChart = DimReductionDataSetSample.getChart(false);
        verticalChart.getFirstAxis(Orientation.VERTICAL).setName("magnitude");
        verticalChart.getDatasets().addAll((Object[])new DataSet[]{verticalSlice, verticalRange});
        AxisSynchronizer sync2 = new AxisSynchronizer();
        sync2.add(waveletChart2.getXAxis());
        sync2.add(verticalChart.getXAxis());
        GridPane root = new GridPane();
        root.add((Node)waveletChart1, 0, 0);
        root.add((Node)waveletChart2, 1, 0);
        root.add((Node)horizontalChart, 0, 1);
        root.add((Node)verticalChart, 1, 1);
        Scene scene = new Scene((Parent)new StackPane(new Node[]{root}), 1200.0, 600.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
    }

    private static DataSet3D createDataSet() {
        double nu = 50.0;
        int nQuantx = 512;
        int nQuanty = 1024;
        double fmin = 0.05;
        double fmax = 0.5;
        final double[] yValues = DimReductionDataSetSample.readDemoData(1);
        final ContinuousWavelet wtrafo = new ContinuousWavelet();
        new Thread(){

            @Override
            public void run() {
                tempDataSet = wtrafo.getScalogram(yValues, 512, 1024, 50.0, 0.05, 0.5);
            }
        }.start();
        do {
            DimReductionDataSetSample.sleep(100);
            int status = wtrafo.getStatus();
            LOGGER.atInfo().log(status + " % of computation done");
        } while (wtrafo.isBusy());
        DoubleFFT_1D fft = new DoubleFFT_1D(yValues.length);
        double[] fftSpectra = Arrays.copyOf(yValues, yValues.length);
        fft.realForward(fftSpectra);
        double[] frequency1 = wtrafo.getScalogramFrequencyAxis(512, 1024, 50.0, 0.05, 0.5);
        double[] magWavelet = new double[frequency1.length];
        int nboundary = tempDataSet.getDataCount(0) / 20;
        for (int i = 0; i < tempDataSet.getDataCount(1); ++i) {
            double val = 0.0;
            double count = 0.0;
            for (int j = nboundary; j < tempDataSet.getDataCount(0) - nboundary; ++j) {
                val += tempDataSet.getZ(j, i);
                count += 1.0;
            }
            magWavelet[i] = count == 0.0 ? Double.NaN : val / count;
        }
        return tempDataSet;
    }

    private static XYChart getChart(boolean isWavelet) {
        DefaultNumericAxis xAxis = new DefaultNumericAxis("time", "turns");
        DefaultNumericAxis yAxis = new DefaultNumericAxis("frequency", "fs");
        XYChart chart = new XYChart((Axis)xAxis, (Axis)yAxis);
        chart.getXAxis().setName("time");
        chart.getXAxis().setUnit("turns");
        chart.getYAxis().setName("frequency");
        chart.getYAxis().setUnit("fs");
        if (isWavelet) {
            ContourDataSetRenderer contourChartRenderer = new ContourDataSetRenderer();
            chart.getRenderers().set(0, (Object)contourChartRenderer);
            xAxis.setAutoRangeRounding(false);
            xAxis.setAutoRangePadding(0.0);
            yAxis.setAutoRangeRounding(false);
            yAxis.setAutoRangePadding(0.0);
        }
        chart.getPlugins().add((Object)new ParameterMeasurements());
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new TableViewer());
        chart.getPlugins().add((Object)new EditAxis());
        chart.getPlugins().add((Object)new DataPointTooltip());
        GridPane.setHgrow((Node)chart, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)chart, (Priority)Priority.ALWAYS);
        return chart;
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private static double[] readDemoData(int index) {
        double[] dArray;
        String fileName = index <= 1 ? "./rawDataCPS2.dat" : "./rawDataLHCInj.dat";
        BufferedReader reader = new BufferedReader(new InputStreamReader(EMDSample.class.getResourceAsStream(fileName)));
        try {
            String line = reader.readLine();
            int nDim = line == null ? 0 : Integer.parseInt(line);
            double[] ret = new double[nDim];
            for (int i = 0; i < nDim && (line = reader.readLine()) != null; ++i) {
                String[] x = line.split("\t");
                ret[i] = Double.parseDouble(x[1]);
            }
            dArray = ret;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.atError().setCause((Throwable)e).log("read error");
                }
                return new double[1000];
            }
        }
        reader.close();
        return dArray;
    }

    private static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.atError().setCause((Throwable)e).log("InterruptedException");
            }
            Thread.currentThread().interrupt();
        }
    }
}

