/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.viewer;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Panner;
import de.gsi.chart.plugins.ParameterMeasurements;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.utils.ScientificNotationStringConverter;
import de.gsi.chart.viewer.DataView;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.utils.ProcessingProfiler;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import jfxtras.labs.scene.control.window.RotateIcon;
import jfxtras.labs.scene.control.window.Window;
import jfxtras.labs.scene.control.window.WindowIcon;

public class DataViewPane
extends Window {
    private final WindowIcon minimizeButton = new WindowIcon();
    private final WindowIcon maximizeRestoreButton = new WindowIcon();
    private final WindowIcon closeButton = new WindowIcon();
    private final WindowIcon detachButton = new WindowIcon();
    private final MyDialog dialog = new MyDialog();
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private XYChart chart;
    private final StringProperty name = new SimpleStringProperty((Object)this, "name");
    private final ObjectProperty<Node> graphic = new SimpleObjectProperty((Object)this, "graphic");
    private final ObjectProperty<DataView> dataView = new SimpleObjectProperty((Object)this, "dataView");
    EventHandler<ActionEvent> maximizeButtonAction = event -> {
        boolean maximized;
        if (this.dialog.isShowing()) {
            this.dialog.maximizeRestore();
            if (!this.dialog.isMaximized) {
                this.maximizeRestoreButton.getStyleClass().setAll((Object[])new String[]{"window-maximize-icon"});
            } else {
                this.maximizeRestoreButton.getStyleClass().setAll((Object[])new String[]{"window-restore-icon"});
            }
            return;
        }
        boolean bl = maximized = ((DataView)this.dataView.get()).getMaximizedView() == this;
        if (!((DataView)this.dataView.get()).getVisibleChildren().contains((Object)this)) {
            ((DataView)this.dataView.get()).getMinimizedChildren().remove((Object)this);
            this.setMinimized(false);
            ((DataView)this.dataView.get()).getVisibleChildren().add((Object)this);
            this.minimizeButton.setDisable(false);
            return;
        }
        if (maximized) {
            this.maximizeRestoreButton.getStyleClass().setAll((Object[])new String[]{"window-maximize-icon"});
        } else {
            this.maximizeRestoreButton.getStyleClass().setAll((Object[])new String[]{"window-restore-icon"});
        }
        ((DataView)this.dataView.get()).setMaximizedView(maximized ? null : this);
    };
    EventHandler<ActionEvent> minimizeButtonAction = event -> {
        boolean maximized;
        if (this.dialog.isShowing()) {
            this.dialog.hide();
            this.maximizeRestoreButton.getStyleClass().setAll((Object[])new String[]{"window-maximize-icon"});
            return;
        }
        boolean bl = maximized = ((DataView)this.dataView.get()).getMaximizedView() == this;
        if (!maximized) {
            this.maximizeRestoreButton.getStyleClass().setAll((Object[])new String[]{"window-maximize-icon"});
        } else {
            ((DataView)this.dataView.get()).setMaximizedView(null);
        }
        this.setMinimized(true);
        ((DataView)this.dataView.get()).getMinimizedChildren().add((Object)this);
        ((DataView)this.dataView.get()).getVisibleChildren().remove((Object)this);
        this.minimizeButton.setDisable(true);
    };
    EventHandler<ActionEvent> closeButtonAction = event -> {
        boolean maximized;
        System.err.println("asked to remove pane");
        if (this.dialog.isShowing()) {
            this.dialog.hide();
            return;
        }
        boolean bl = maximized = ((DataView)this.dataView.get()).getMaximizedView() == this;
        if (maximized) {
            ((DataView)this.dataView.get()).setMaximizedView(null);
        }
        if (((DataView)this.dataView.get()).getMinimizedChildren() == null) {
            System.err.println("getMinimizedChildren list is null");
        }
        if (((DataView)this.dataView.get()).getVisibleChildren() == null) {
            System.err.println("getVisibleChildren list is null");
        }
        ((DataView)this.dataView.get()).getMinimizedChildren().remove((Object)this);
        ((DataView)this.dataView.get()).getVisibleChildren().remove((Object)this);
        ((DataView)this.dataView.get()).getChildren().remove((Object)this);
    };

    public DataViewPane(String name, XYChart chart) {
        super(name);
        this.setName(name);
        this.chart = chart;
        this.getStyleClass().add((Object)"data-view-pane");
        String css = DataViewPane.class.getResource("window.css").toExternalForm();
        this.getStylesheets().clear();
        this.getStylesheets().add((Object)css);
        this.getLeftIcons().add((Object)new RotateIcon((Window)this));
        this.minimizeButton.getStyleClass().setAll((Object[])new String[]{"window-minimize-icon2"});
        this.maximizeRestoreButton.getStyleClass().setAll((Object[])new String[]{"window-maximize-icon"});
        this.closeButton.getStyleClass().setAll((Object[])new String[]{"window-close-icon"});
        this.getRightIcons().addAll((Object[])new WindowIcon[]{this.minimizeButton});
        this.getRightIcons().addAll((Object[])new WindowIcon[]{this.maximizeRestoreButton});
        this.getRightIcons().addAll((Object[])new WindowIcon[]{this.closeButton});
        this.minimizeButton.setOnAction(this.minimizeButtonAction);
        this.maximizeRestoreButton.setOnAction(this.maximizeButtonAction);
        this.closeButton.setOnAction(this.closeButtonAction);
        this.detachButton.getStyleClass().setAll((Object[])new String[]{"window-detach-icon"});
        this.detachButton.setOnAction(evt -> this.dialog.show(null));
        this.getLeftIcons().add((Object)this.detachButton);
        this.setOnMouseReleased(mevt -> {
            boolean isInMinimized = ((DataView)this.dataView.get()).getMinimizedChildren().contains((Object)this);
            if (this.isMinimized() || isInMinimized) {
                return;
            }
            Point2D mouseLoc = new Point2D(mevt.getScreenX(), mevt.getScreenY());
            Bounds screenBounds = this.localToScreen(this.getBoundsInLocal());
            if (!screenBounds.contains(mouseLoc)) {
                System.err.println("mouse move outside window detected -- launch dialog");
                if (!this.dialog.isShowing()) {
                    this.dialog.show((MouseEvent)mevt);
                    return;
                }
                this.dialog.setX(mevt.getScreenX() - this.xOffset);
                this.dialog.setY(mevt.getScreenY() - this.yOffset);
                return;
            }
            if (this.dialog.isShowing()) {
                this.dialog.setX(mevt.getScreenX() - this.xOffset);
                this.dialog.setY(mevt.getScreenY() - this.yOffset);
            }
        });
        this.setOnMousePressed(event -> {
            System.err.println("setOnMousePressed dialogue");
            this.xOffset = event.getSceneX();
            this.yOffset = event.getSceneY();
        });
        this.setOnMouseDragged(event -> {
            System.err.println("dragging dialogue");
            this.dialog.setX(event.getScreenX() - this.xOffset);
            this.dialog.setY(event.getScreenY() - this.yOffset);
        });
        chart.getPlugins().add((Object)new ParameterMeasurements());
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new Panner());
        chart.getPlugins().add((Object)new EditAxis());
        chart.legendVisibleProperty().set(true);
        if (chart.getXAxis() instanceof DefaultNumericAxis) {
            ((DefaultNumericAxis)chart.getXAxis()).setTickLabelFormatter(new ScientificNotationStringConverter(3));
        }
        if (chart.getYAxis() instanceof DefaultNumericAxis) {
            ((DefaultNumericAxis)chart.getYAxis()).setTickLabelFormatter(new ScientificNotationStringConverter(2));
        }
        this.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.getContentPane().getChildren().add((Object)chart);
        this.setPrefSize(300.0, 200.0);
        this.widthProperty().addListener((ch, o, n) -> chart.requestLayout());
        this.heightProperty().addListener((ch, o, n) -> chart.requestLayout());
    }

    public void switchToTableView() {
    }

    public void switchToChartView() {
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final ObjectProperty<Node> graphicProperty() {
        return this.graphic;
    }

    public final Node getGraphic() {
        return (Node)this.graphicProperty().get();
    }

    public final void setGraphic(Node graphic) {
        this.graphicProperty().set((Object)graphic);
    }

    final void setDataView(DataView value) {
        this.dataView.set((Object)value);
    }

    protected void layoutChildren() {
        long start = ProcessingProfiler.getTimeStamp();
        super.layoutChildren();
        ProcessingProfiler.getTimeDiff((long)start, (String)("pane updated with data set = " + ((DataSet)this.chart.getDatasets().get(0)).getName()));
    }

    class MyDialog
    extends Stage {
        private final BorderPane dialogContent = new BorderPane();
        private final Scene scene = new Scene((Parent)this.dialogContent, 640.0, 480.0);
        private double posX = 640.0;
        private double posY = 480.0;
        private double width = 640.0;
        private double height = 480.0;
        private boolean isMaximized = false;

        public MyDialog() {
            this.titleProperty().bind((ObservableValue)DataViewPane.this.titleProperty());
            this.setScene(this.scene);
            this.setOnShown(windowEvent -> {
                ((DataView)DataViewPane.this.dataView.get()).getMinimizedChildren().remove((Object)DataViewPane.this);
                ((DataView)DataViewPane.this.dataView.get()).getVisibleChildren().remove((Object)DataViewPane.this);
                this.dialogContent.setCenter((Node)DataViewPane.this);
            });
            this.setOnHidden(windowEvent -> {
                this.dialogContent.setCenter(null);
                ((DataView)DataViewPane.this.dataView.get()).getVisibleChildren().add((Object)DataViewPane.this);
            });
        }

        public void maximizeRestore() {
            if (this.isMaximized) {
                this.setWidth(this.width);
                this.setHeight(this.height);
                this.setX(this.posX);
                this.setY(this.posY);
                this.isMaximized = false;
                return;
            }
            Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
            this.width = this.getWidth();
            this.height = this.getHeight();
            this.posX = this.getX();
            this.posY = this.getY();
            this.setX(primaryScreenBounds.getMinX());
            this.setY(primaryScreenBounds.getMinY());
            this.setWidth(primaryScreenBounds.getWidth());
            this.setHeight(primaryScreenBounds.getHeight());
            this.isMaximized = true;
        }

        public void show(MouseEvent mouseEvent) {
            if (mouseEvent == null) {
                this.setX(DataViewPane.this.getScene().getWindow().getX() + 50.0);
                this.setY(DataViewPane.this.getScene().getWindow().getY() + 50.0);
            } else {
                this.setX(mouseEvent.getScreenX());
                this.setY(mouseEvent.getScreenY());
            }
            this.posX = this.getX();
            this.posY = this.getY();
            this.show();
        }
    }
}

