/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.viewer;

import de.gsi.chart.XYChart;
import de.gsi.chart.viewer.DataViewPane;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class DataView {
    private final StringProperty name = new SimpleStringProperty((Object)this, "name");
    private final ObjectProperty<Layout> layout = new SimpleObjectProperty((Object)this, "layout", (Object)Layout.GRID);
    private final ObservableList<DataViewPane> children = FXCollections.observableArrayList();
    private final ObjectProperty<DataViewPane> maximizedView = new SimpleObjectProperty((Object)this, "maximizedView");
    private final ObservableList<DataViewPane> minimizedView = FXCollections.observableArrayList();
    private final ObservableList<DataViewPane> visibleView = FXCollections.observableArrayList();

    public DataView() {
        this(null);
    }

    public DataView(String name) {
        this.setName(name);
        this.children.addListener(change -> {
            while (change.next()) {
                change.getRemoved().forEach(v -> v.setDataView(null));
                change.getAddedSubList().forEach(v -> v.setDataView(this));
                change.getAddedSubList().forEach(v -> this.getVisibleChildren().add((Object)v));
                if (!change.getRemoved().contains((Object)this.getMaximizedView())) continue;
                this.setMaximizedView(null);
            }
        });
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final ObjectProperty<Layout> layoutProperty() {
        return this.layout;
    }

    public final Layout getLayout() {
        return (Layout)((Object)this.layoutProperty().get());
    }

    public final void setLayout(Layout layout) {
        this.layoutProperty().set((Object)layout);
    }

    public final ObservableList<DataViewPane> getChildren() {
        return this.children;
    }

    public void add(String chartName, XYChart chart) {
        this.getChildren().add((Object)new DataViewPane(chartName, chart));
    }

    public final ObjectProperty<DataViewPane> maximizedViewProperty() {
        return this.maximizedView;
    }

    public final DataViewPane getMaximizedView() {
        return (DataViewPane)((Object)this.maximizedViewProperty().get());
    }

    public final void setMaximizedView(DataViewPane view) {
        this.maximizedViewProperty().set((Object)view);
    }

    public final ObservableList<DataViewPane> getMinimizedChildren() {
        return this.minimizedView;
    }

    public final ObservableList<DataViewPane> getVisibleChildren() {
        return this.visibleView;
    }

    public static enum Layout {
        HBOX,
        VBOX,
        GRID;

    }
}

