/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import java.util.LinkedList;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public final class XYChartUtils {
    private XYChartUtils() {
    }

    public static double getLocationX(Node node) {
        return node.getLayoutX() + node.getTranslateX();
    }

    public static double getLocationY(Node node) {
        return node.getLayoutY() + node.getTranslateY();
    }

    public static Region getChartContent(Chart chart) {
        return (Region)chart.lookup(".chart-content");
    }

    public static Node getPlotContent(XYChart chart) {
        return chart.lookup(".plot-content");
    }

    public static Pane getLegend(XYChart chart) {
        return (Pane)chart.lookup(".chart-legend");
    }

    public static double getHorizontalInsets(Insets insets) {
        return insets.getLeft() + insets.getRight();
    }

    public static double getVerticalInsets(Insets insets) {
        return insets.getTop() + insets.getBottom();
    }

    public static Chart getChart(Node chartChildNode) {
        Node node;
        for (node = chartChildNode; node != null && !(node instanceof Chart); node = node.getParent()) {
        }
        return (Chart)node;
    }

    public static List<Label> getChildLabels(List<? extends Parent> parents) {
        LinkedList<Label> labels = new LinkedList<Label>();
        for (Parent parent : parents) {
            for (Node node : parent.getChildrenUnmodifiable()) {
                if (!(node instanceof Label)) continue;
                labels.add((Label)node);
            }
        }
        return labels;
    }
}

