/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StyleParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(StyleParser.class);
    private static final int DEFAULT_FONT_SIZE = 18;
    private static final String DEFAULT_FONT = "Helvetia";

    private StyleParser() {
    }

    public static Map<String, String> splitIntoMap(String style) {
        String[] keyVals;
        ConcurrentHashMap<String, String> retVal = new ConcurrentHashMap<String, String>();
        if (style == null) {
            return retVal;
        }
        for (String keyVal : keyVals = style.toLowerCase().replaceAll("\\s+", "").split("[;,]")) {
            String[] parts = keyVal.split("[=:]", 2);
            if (parts == null || parts[0] == null || parts.length <= 1) continue;
            retVal.put(parts[0], parts[1].replaceAll("[\"']", ""));
        }
        return retVal;
    }

    public static String mapToString(Map<String, String> map) {
        String ret = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            ret = ret.concat(key).concat("=").concat(value).concat(";");
        }
        return ret;
    }

    public static String getPropertyValue(String style, String key) {
        if (style == null || key == null) {
            return null;
        }
        Map<String, String> map = StyleParser.splitIntoMap(style);
        return map.get(key.toLowerCase());
    }

    public static Color getColorPropertyValue(String style, String key) {
        if (style == null || key == null) {
            return null;
        }
        Map<String, String> map = StyleParser.splitIntoMap(style);
        String value = map.get(key.toLowerCase());
        if (value == null) {
            return null;
        }
        try {
            return Color.web((String)value);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error("could not parse color description for '" + key + "'='" + value + "' returning null", (Throwable)ex);
            return null;
        }
    }

    public static Integer getIntegerPropertyValue(String style, String key) {
        if (style == null || key == null) {
            return null;
        }
        Map<String, String> map = StyleParser.splitIntoMap(style);
        String value = map.get(key.toLowerCase());
        if (value == null) {
            return null;
        }
        try {
            return Integer.decode(value);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("could not parse integer description for '" + key + "'='" + value + "' returning null", (Throwable)ex);
            return null;
        }
    }

    public static Double getFloatingDecimalPropertyValue(String style, String key) {
        if (style == null || key == null) {
            return null;
        }
        Map<String, String> map = StyleParser.splitIntoMap(style);
        String value = map.get(key.toLowerCase());
        if (value == null) {
            return null;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("could not parse integer description for '" + key + "'='" + value + "' returning null", (Throwable)ex);
            return null;
        }
    }

    public static double[] getFloatingDecimalArrayPropertyValue(String style, String key) {
        if (style == null || key == null) {
            return null;
        }
        Map<String, String> map = StyleParser.splitIntoMap(style);
        String value = map.get(key.toLowerCase());
        if (value == null) {
            return null;
        }
        try {
            String[] splitValues = value.split(",");
            if (splitValues == null || splitValues.length == 0) {
                return null;
            }
            double[] retArray = new double[splitValues.length];
            for (int i = 0; i < splitValues.length; ++i) {
                retArray[i] = Double.parseDouble(splitValues[i]);
            }
            return retArray;
        }
        catch (NumberFormatException ex) {
            LOGGER.error("could not parse integer description for '" + key + "'='" + value + "' returning null", (Throwable)ex);
            return null;
        }
    }

    public static Boolean getBooleanPropertyValue(String style, String key) {
        if (style == null || key == null) {
            return null;
        }
        Map<String, String> map = StyleParser.splitIntoMap(style);
        String value = map.get(key.toLowerCase());
        if (value == null) {
            return null;
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("could not parse boolean description for '" + key + "'='" + value + "' returning null", (Throwable)ex);
            return null;
        }
    }

    public static Font getFontPropertyValue(String style) {
        if (style == null) {
            return Font.font((String)DEFAULT_FONT, (double)18.0);
        }
        try {
            String font;
            double fontSize = 18.0;
            Double fontSizeObj = StyleParser.getFloatingDecimalPropertyValue(style, "fontSize");
            if (fontSizeObj != null) {
                fontSize = fontSizeObj;
            }
            FontWeight fontWeight = null;
            String fontW = StyleParser.getPropertyValue(style, "fontWheight");
            if (fontW != null) {
                fontWeight = FontWeight.findByName((String)fontW);
            }
            FontPosture fontPosture = null;
            String fontP = StyleParser.getPropertyValue(style, "fontPosture");
            if (fontP != null) {
                fontPosture = FontPosture.findByName((String)fontP);
            }
            if ((font = StyleParser.getPropertyValue(style, "font")) == null) {
                return Font.font((String)DEFAULT_FONT, (FontWeight)fontWeight, (FontPosture)fontPosture, (double)fontSize);
            }
            return Font.font((String)font, (FontWeight)fontWeight, (FontPosture)fontPosture, (double)fontSize);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("could not parse font description style='" + style + "' returning default font", (Throwable)ex);
            return Font.font((String)DEFAULT_FONT, (double)18.0);
        }
    }

    public static void main(String[] args) {
        String testStyle = " color1 = blue; stroke= 0; bool1=true; color2 = red2, unclean=\"a', index1=2,index2=0xFE, float1=10e7, float2=10.333";
        System.out.println("colour parser1 = " + StyleParser.getPropertyValue(" color1 = blue; stroke= 0; bool1=true; color2 = red2, unclean=\"a', index1=2,index2=0xFE, float1=10e7, float2=10.333", "color1"));
        System.out.println("colour parser2 = " + StyleParser.getColorPropertyValue(" color1 = blue; stroke= 0; bool1=true; color2 = red2, unclean=\"a', index1=2,index2=0xFE, float1=10e7, float2=10.333", "color2"));
        System.out.println("int parser1 = " + StyleParser.getIntegerPropertyValue(" color1 = blue; stroke= 0; bool1=true; color2 = red2, unclean=\"a', index1=2,index2=0xFE, float1=10e7, float2=10.333", "index1"));
        System.out.println("int parser2 = " + StyleParser.getIntegerPropertyValue(" color1 = blue; stroke= 0; bool1=true; color2 = red2, unclean=\"a', index1=2,index2=0xFE, float1=10e7, float2=10.333", "index2"));
        System.out.println("float parser1 = " + StyleParser.getFloatingDecimalPropertyValue(" color1 = blue; stroke= 0; bool1=true; color2 = red2, unclean=\"a', index1=2,index2=0xFE, float1=10e7, float2=10.333", "float1"));
        System.out.println("float parser2 = " + StyleParser.getFloatingDecimalPropertyValue(" color1 = blue; stroke= 0; bool1=true; color2 = red2, unclean=\"a', index1=2,index2=0xFE, float1=10e7, float2=10.333", "float2"));
        System.out.println("boolean parser1 = " + StyleParser.getBooleanPropertyValue(" color1 = blue; stroke= 0; bool1=true; color2 = red2, unclean=\"a', index1=2,index2=0xFE, float1=10e7, float2=10.333", "bool1"));
    }
}

